/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.launcher;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.codegen.Mnemonics;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.ProgramFileReader;
import org.ballerinalang.util.program.BLangFunctions;
import org.wso2.ballerinalang.compiler.Compiler;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.programfile.ProgramFile;
import org.wso2.ballerinalang.programfile.ProgramFileWriter;

public class BTester {
    private static CompilerOptions options;

    public static void main(String[] args) throws Exception {
        CompilerContext context = new CompilerContext();
        options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.SOURCE_ROOT, System.getProperty("user.dir") + "/bal-src");
        options.put(CompilerOptionName.COMPILER_PHASE, "codeGen");
        options.put(CompilerOptionName.PRESERVE_WHITESPACE, "false");
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        compiler.compile("pkg.bal");
        ProgramFile programFile = compiler.getCompiledProgram();
        if (programFile != null) {
            org.ballerinalang.util.codegen.ProgramFile executableProgram = BTester.getExecutableProgram(programFile);
            BLangFunctions.invokeNew((org.ballerinalang.util.codegen.ProgramFile)executableProgram, (String)executableProgram.getEntryPkgName(), (String)"main", (BValue[])new BValue[1]);
        }
    }

    private static void traceCode(PackageInfo packageInfo) {
        PrintStream printStream = System.out;
        for (int i = 0; i < packageInfo.getInstructions().length; ++i) {
            printStream.println(i + ": " + Mnemonics.getMnem((int)packageInfo.getInstructions()[i].getOpcode()) + " " + BTester.getOperandsLine(packageInfo.getInstructions()[i].getOperands()));
        }
    }

    private static String getOperandsLine(int[] operands) {
        if (operands.length == 0) {
            return "";
        }
        if (operands.length == 1) {
            return "" + operands[0];
        }
        StringBuilder sb = new StringBuilder();
        sb.append(operands[0]);
        for (int i = 1; i < operands.length; ++i) {
            sb.append(" ");
            sb.append(operands[i]);
        }
        return sb.toString();
    }

    private static org.ballerinalang.util.codegen.ProgramFile getExecutableProgram(ProgramFile programFile) {
        ByteArrayInputStream byteIS = null;
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        try {
            ProgramFileWriter.writeProgram((ProgramFile)programFile, (OutputStream)byteOutStream);
            ProgramFileReader reader = new ProgramFileReader();
            byteIS = new ByteArrayInputStream(byteOutStream.toByteArray());
            org.ballerinalang.util.codegen.ProgramFile programFile2 = reader.readProgram((InputStream)byteIS);
            return programFile2;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (byteIS != null) {
                try {
                    byteIS.close();
                }
                catch (IOException iOException) {}
            }
            try {
                byteOutStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

