/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.launcher;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.LogManager;
import org.ballerinalang.BLangProgramLoader;
import org.ballerinalang.BLangProgramRunner;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.config.utils.ConfigFileParserException;
import org.ballerinalang.connector.impl.ServerConnectorRegistry;
import org.ballerinalang.launcher.BLauncherException;
import org.ballerinalang.logging.BLogManager;
import org.ballerinalang.runtime.threadpool.ThreadPoolFactory;
import org.ballerinalang.util.codegen.ProgramFileReader;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.wso2.ballerinalang.compiler.Compiler;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.programfile.ProgramFile;
import org.wso2.ballerinalang.programfile.ProgramFileWriter;

public class LauncherUtils {
    public static void runProgram(Path sourceRootPath, Path sourcePath, boolean runServices, String[] args) {
        org.ballerinalang.util.codegen.ProgramFile programFile;
        String srcPathStr = sourcePath.toString();
        if (srcPathStr.endsWith(".balx")) {
            programFile = BLangProgramLoader.read((Path)sourcePath);
        } else if (Files.isDirectory(sourcePath, new LinkOption[0]) || srcPathStr.endsWith(".bal")) {
            programFile = LauncherUtils.compile(sourceRootPath, sourcePath);
        } else {
            throw new BallerinaException("Invalid Ballerina source path, it should either be a directory or a file with a '.bal' extension.");
        }
        if (!programFile.isMainEPAvailable() && !programFile.isServiceEPAvailable()) {
            throw new RuntimeException("main function not found in '" + programFile.getProgramFilePath() + "'");
        }
        try {
            ConfigRegistry.getInstance().loadConfigurations();
            ((BLogManager)LogManager.getLogManager()).loadUserProvidedLogConfiguration();
        }
        catch (ConfigFileParserException e) {
            throw new RuntimeException("failed to start ballerina runtime: " + e.getMessage(), e);
        }
        if (runServices || !programFile.isMainEPAvailable()) {
            if (args.length > 0) {
                throw LauncherUtils.createUsageException("too many arguments");
            }
            LauncherUtils.runServices(programFile);
        } else {
            LauncherUtils.runMain(programFile, args);
        }
    }

    public static void runMain(org.ballerinalang.util.codegen.ProgramFile programFile, String[] args) {
        BLangProgramRunner.runMain((org.ballerinalang.util.codegen.ProgramFile)programFile, (String[])args);
        try {
            ThreadPoolFactory.getInstance().getWorkerExecutor().shutdown();
            ThreadPoolFactory.getInstance().getWorkerExecutor().awaitTermination(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Runtime.getRuntime().exit(0);
    }

    public static void runServices(org.ballerinalang.util.codegen.ProgramFile programFile) {
        PrintStream outStream = System.out;
        ServerConnectorRegistry.getInstance().initServerConnectors();
        outStream.println("ballerina: deploying service(s) in '" + programFile.getProgramFilePath() + "'");
        BLangProgramRunner.runService((org.ballerinalang.util.codegen.ProgramFile)programFile);
        ServerConnectorRegistry.getInstance().deploymentComplete();
    }

    public static Path getSourceRootPath(String sourceRoot) {
        Path sourceRootPath;
        if (sourceRoot == null || sourceRoot.isEmpty()) {
            sourceRootPath = Paths.get(System.getProperty("user.dir"), new String[0]);
        } else {
            try {
                sourceRootPath = Paths.get(sourceRoot, new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS);
            }
            catch (IOException e) {
                throw new RuntimeException("error reading from directory: " + sourceRoot + " reason: " + e.getMessage(), e);
            }
            if (!Files.isDirectory(sourceRootPath, LinkOption.NOFOLLOW_LINKS)) {
                throw new RuntimeException("source root must be a directory");
            }
        }
        return sourceRootPath;
    }

    public static BLauncherException createUsageException(String errorMsg) {
        BLauncherException launcherException = new BLauncherException();
        launcherException.addMessage("ballerina: " + errorMsg);
        launcherException.addMessage("Run 'ballerina help' for usage.");
        return launcherException;
    }

    static BLauncherException createLauncherException(String errorMsg) {
        BLauncherException launcherException = new BLauncherException();
        launcherException.addMessage(errorMsg);
        return launcherException;
    }

    static void printLauncherException(BLauncherException e, PrintStream outStream) {
        List<String> errorMessages = e.getMessages();
        errorMessages.forEach(outStream::println);
    }

    static String makeFirstLetterLowerCase(String s) {
        if (s == null) {
            return null;
        }
        char[] c = s.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return new String(c);
    }

    static void writePID(String ballerinaHome) {
        Throwable throwable;
        Process p;
        String[] cmd = new String[]{"bash", "-c", "echo $PPID"};
        String pid = "";
        try {
            p = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            return;
        }
        try {
            throwable = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                StringBuilder builder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                }
                pid = builder.toString();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable e) {
            throw LauncherUtils.createLauncherException("error: fail to write ballerina.pid file: " + LauncherUtils.makeFirstLetterLowerCase(e.getMessage()));
        }
        if (pid.length() != 0) {
            try {
                throwable = null;
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(Paths.get(ballerinaHome, "ballerina.pid").toString()), StandardCharsets.UTF_8));){
                    writer.write(pid);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException("error: fail to write ballerina.pid file: " + LauncherUtils.makeFirstLetterLowerCase(e.getMessage()));
            }
        }
    }

    private static org.ballerinalang.util.codegen.ProgramFile compile(Path sourceRootPath, Path sourcePath) {
        CompilerContext context = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.SOURCE_ROOT, sourceRootPath.toString());
        options.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.CODE_GEN.toString());
        options.put(CompilerOptionName.PRESERVE_WHITESPACE, "false");
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        compiler.compile(sourcePath.toString());
        ProgramFile programFile = compiler.getCompiledProgram();
        if (programFile == null) {
            throw LauncherUtils.createLauncherException("compilation contains errors");
        }
        org.ballerinalang.util.codegen.ProgramFile progFile = LauncherUtils.getExecutableProgram(programFile);
        progFile.setProgramFilePath(sourcePath);
        return progFile;
    }

    public static org.ballerinalang.util.codegen.ProgramFile getExecutableProgram(ProgramFile programFile) {
        ByteArrayInputStream byteIS = null;
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        try {
            ProgramFileWriter.writeProgram((ProgramFile)programFile, (OutputStream)byteOutStream);
            ProgramFileReader reader = new ProgramFileReader();
            byteIS = new ByteArrayInputStream(byteOutStream.toByteArray());
            org.ballerinalang.util.codegen.ProgramFile programFile2 = reader.readProgram((InputStream)byteIS);
            return programFile2;
        }
        catch (Throwable e) {
            throw LauncherUtils.createLauncherException("error: fail to compile file: " + LauncherUtils.makeFirstLetterLowerCase(e.getMessage()));
        }
        finally {
            if (byteIS != null) {
                try {
                    byteIS.close();
                }
                catch (IOException iOException) {}
            }
            try {
                byteOutStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

