/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.launcher;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.launcher.BLauncherCmd;
import org.ballerinalang.launcher.BLauncherException;
import org.ballerinalang.launcher.LauncherUtils;
import org.ballerinalang.util.exceptions.BLangRuntimeException;
import org.ballerinalang.util.exceptions.ParserException;
import org.ballerinalang.util.exceptions.SemanticException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final String JC_UNKNOWN_OPTION_PREFIX = "Unknown option:";
    private static final String JC_EXPECTED_A_VALUE_AFTER_PARAMETER_PREFIX = "Expected a value after parameter";
    private static PrintStream outStream = System.err;
    private static final Logger breLog = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) {
        try {
            Optional<BLauncherCmd> optionalInvokedCmd = Main.getInvokedCmd(args);
            optionalInvokedCmd.ifPresent(BLauncherCmd::execute);
        }
        catch (BLangRuntimeException | ParserException | SemanticException e) {
            outStream.println(e.getMessage());
            Runtime.getRuntime().exit(1);
        }
        catch (BLauncherException e) {
            LauncherUtils.printLauncherException(e, outStream);
            Runtime.getRuntime().exit(1);
        }
        catch (Throwable e) {
            String msg = e.getMessage();
            msg = msg == null ? "ballerina: internal error occurred" : "ballerina: " + LauncherUtils.makeFirstLetterLowerCase(msg);
            outStream.println(msg);
            breLog.error(msg, e);
            Runtime.getRuntime().exit(1);
        }
    }

    private static JCommander addSubCommand(JCommander parentCmd, String commandName, Object commandObject) {
        parentCmd.addCommand(commandName, commandObject);
        return (JCommander)parentCmd.getCommands().get(commandName);
    }

    private static Optional<BLauncherCmd> getInvokedCmd(String ... args) {
        try {
            DefaultCmd defaultCmd = new DefaultCmd();
            JCommander cmdParser = new JCommander((Object)defaultCmd);
            defaultCmd.setParentCmdParser(cmdParser);
            RunCmd runCmd = new RunCmd();
            JCommander jcRunCmd = Main.addSubCommand(cmdParser, "run", runCmd);
            runCmd.setParentCmdParser(cmdParser);
            runCmd.setSelfCmdParser(jcRunCmd);
            HelpCmd helpCmd = new HelpCmd();
            cmdParser.addCommand("help", (Object)helpCmd);
            helpCmd.setParentCmdParser(cmdParser);
            ServiceLoader<BLauncherCmd> bCmds = ServiceLoader.load(BLauncherCmd.class);
            for (BLauncherCmd bCmd : bCmds) {
                cmdParser.addCommand(bCmd.getName(), (Object)bCmd);
                bCmd.setParentCmdParser(cmdParser);
            }
            VersionCmd versionCmd = new VersionCmd();
            cmdParser.addCommand("version", (Object)versionCmd);
            versionCmd.setParentCmdParser(cmdParser);
            cmdParser.setProgramName("ballerina");
            cmdParser.parse(args);
            String parsedCmdName = cmdParser.getParsedCommand();
            if (parsedCmdName == null) {
                return Optional.of(defaultCmd);
            }
            Map commanderMap = cmdParser.getCommands();
            return Optional.of((BLauncherCmd)((JCommander)commanderMap.get(parsedCmdName)).getObjects().get(0));
        }
        catch (MissingCommandException e) {
            String errorMsg = "unknown command '" + e.getUnknownCommand() + "'";
            throw LauncherUtils.createUsageException(errorMsg);
        }
        catch (ParameterException e) {
            String msg = e.getMessage();
            if (msg == null) {
                throw LauncherUtils.createUsageException("internal error occurred");
            }
            if (msg.startsWith(JC_UNKNOWN_OPTION_PREFIX)) {
                String flag = msg.substring(JC_UNKNOWN_OPTION_PREFIX.length());
                throw LauncherUtils.createUsageException("unknown flag '" + flag.trim() + "'");
            }
            if (msg.startsWith(JC_EXPECTED_A_VALUE_AFTER_PARAMETER_PREFIX)) {
                String flag = msg.substring(JC_EXPECTED_A_VALUE_AFTER_PARAMETER_PREFIX.length());
                throw LauncherUtils.createUsageException("flag '" + flag.trim() + "' needs an argument");
            }
            throw LauncherUtils.createUsageException(LauncherUtils.makeFirstLetterLowerCase(msg));
        }
    }

    private static void printUsageInfo(JCommander cmdParser) {
        StringBuilder out = new StringBuilder();
        out.append("Ballerina is a general purpose, concurrent and strongly typed programming language \n");
        out.append("with both textual and graphical syntaxes, optimized for integration.\n");
        out.append("\n");
        out.append("* Find more information at http://ballerinalang.org\n");
        out.append("\n");
        out.append("Usage:\n");
        out.append("  ballerina [command] [options]\n");
        out.append("\n");
        out.append("Available Commands:\n");
        BLauncherCmd.printCommandList(cmdParser, out);
        out.append("\n");
        BLauncherCmd.printFlags(cmdParser.getParameters(), out);
        out.append("\n");
        out.append("Use \"ballerina help [command]\" for more information about a command.");
        outStream.println(out.toString());
    }

    private static void printVersionInfo() {
        try (InputStream inputStream = Main.class.getResourceAsStream("/META-INF/launcher.properties");){
            Properties properties = new Properties();
            properties.load(inputStream);
            String version = "Ballerina " + properties.getProperty("ballerina.version") + "\n";
            outStream.print(version);
        }
        catch (Throwable ignore) {
            throw LauncherUtils.createUsageException("version info not available");
        }
    }

    private static class DefaultCmd
    implements BLauncherCmd {
        @Parameter(names={"--help", "-h"}, description="for more information")
        private boolean helpFlag;
        @Parameter(names={"--debug <port>"}, description="start Ballerina in remote debugging mode")
        private String debugPort;
        @Parameter(names={"--java.debug"}, hidden=true)
        private String javaDebugPort;
        private JCommander parentCmdParser;

        private DefaultCmd() {
        }

        @Override
        public void execute() {
            Main.printUsageInfo(this.parentCmdParser);
        }

        @Override
        public String getName() {
            return "default-cmd";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
        }

        @Override
        public void printUsage(StringBuilder out) {
        }

        @Override
        public void setParentCmdParser(JCommander parentCmdParser) {
            this.parentCmdParser = parentCmdParser;
        }

        @Override
        public void setSelfCmdParser(JCommander selfCmdParser) {
        }
    }

    @Parameters(commandNames={"version"}, commandDescription="print Ballerina version")
    private static class VersionCmd
    implements BLauncherCmd {
        @Parameter(description="Command name")
        private List<String> versionCommands;
        @Parameter(names={"--java.debug"}, hidden=true)
        private String javaDebugPort;
        @Parameter(names={"--help", "-h"}, hidden=true)
        private boolean helpFlag;
        private JCommander parentCmdParser;

        private VersionCmd() {
        }

        @Override
        public void execute() {
            if (this.helpFlag) {
                String commandUsageInfo = BLauncherCmd.getCommandUsageInfo(this.parentCmdParser, "version");
                outStream.println(commandUsageInfo);
                return;
            }
            if (this.versionCommands == null) {
                Main.printVersionInfo();
                return;
            }
            if (this.versionCommands.size() > 1) {
                throw LauncherUtils.createUsageException("too many arguments given");
            }
            String userCommand = this.versionCommands.get(0);
            if (this.parentCmdParser.getCommands().get(userCommand) == null) {
                throw LauncherUtils.createUsageException("unknown command `" + userCommand + "`");
            }
        }

        @Override
        public String getName() {
            return "version";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
        }

        @Override
        public void printUsage(StringBuilder out) {
            out.append("  ballerina version\n");
        }

        @Override
        public void setParentCmdParser(JCommander parentCmdParser) {
            this.parentCmdParser = parentCmdParser;
        }

        @Override
        public void setSelfCmdParser(JCommander selfCmdParser) {
        }
    }

    @Parameters(commandNames={"help"}, commandDescription="print usage information")
    private static class HelpCmd
    implements BLauncherCmd {
        @Parameter(description="Command name")
        private List<String> helpCommands;
        @Parameter(names={"--java.debug"}, hidden=true)
        private String javaDebugPort;
        private JCommander parentCmdParser;

        private HelpCmd() {
        }

        @Override
        public void execute() {
            if (this.helpCommands == null) {
                Main.printUsageInfo(this.parentCmdParser);
                return;
            }
            if (this.helpCommands.size() > 1) {
                throw LauncherUtils.createUsageException("too many arguments given");
            }
            String userCommand = this.helpCommands.get(0);
            if (this.parentCmdParser.getCommands().get(userCommand) == null) {
                throw LauncherUtils.createUsageException("unknown help topic `" + userCommand + "`");
            }
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo(this.parentCmdParser, userCommand);
            outStream.println(commandUsageInfo);
        }

        @Override
        public String getName() {
            return "help";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
        }

        @Override
        public void printUsage(StringBuilder out) {
        }

        @Override
        public void setParentCmdParser(JCommander parentCmdParser) {
            this.parentCmdParser = parentCmdParser;
        }

        @Override
        public void setSelfCmdParser(JCommander selfCmdParser) {
        }
    }

    @Parameters(commandNames={"run"}, commandDescription="compile and run Ballerina program")
    private static class RunCmd
    implements BLauncherCmd {
        private JCommander parentCmdParser;
        @Parameter(arity=1, description="arguments")
        private List<String> argList;
        @Parameter(names={"--service", "-s"}, description="run services instead of main")
        private boolean runServices;
        @Parameter(names={"--sourceroot"}, description="path to the directory containing source files and packages")
        private String sourceRoot;
        @Parameter(names={"--help", "-h"}, hidden=true)
        private boolean helpFlag;
        @Parameter(names={"--debug"}, hidden=true)
        private String debugPort;
        @Parameter(names={"--java.debug"}, hidden=true, description="remote java debugging port")
        private String javaDebugPort;
        @DynamicParameter(names={"-B"}, description="collects dynamic parameters")
        private Map<String, String> configRuntimeParams = new HashMap<String, String>();

        private RunCmd() {
        }

        @Override
        public void execute() {
            String[] programArgs;
            if (this.helpFlag) {
                String commandUsageInfo = BLauncherCmd.getCommandUsageInfo(this.parentCmdParser, "run");
                outStream.println(commandUsageInfo);
                return;
            }
            if (this.argList == null || this.argList.size() == 0) {
                throw LauncherUtils.createUsageException("no ballerina program given");
            }
            ConfigRegistry.getInstance().initRegistry(this.configRuntimeParams);
            if (null != this.debugPort) {
                System.setProperty("debug", this.debugPort);
            }
            Path sourceRootPath = LauncherUtils.getSourceRootPath(this.sourceRoot);
            if (this.runServices) {
                if (this.argList.size() > 1) {
                    throw LauncherUtils.createUsageException("too many arguments");
                }
                LauncherUtils.runProgram(sourceRootPath, Paths.get(this.argList.get(0), new String[0]), true, new String[0]);
                return;
            }
            Path sourcePath = Paths.get(this.argList.get(0), new String[0]);
            if (this.argList.size() >= 2) {
                this.argList.remove(0);
                programArgs = this.argList.toArray(new String[0]);
            } else {
                programArgs = new String[]{};
            }
            LauncherUtils.runProgram(sourceRootPath, sourcePath, false, programArgs);
        }

        @Override
        public String getName() {
            return "run";
        }

        @Override
        public void printLongDesc(StringBuilder out) {
            out.append("Run command runs a compiled Ballerina program. \n");
            out.append("\n");
            out.append("If a Ballerina source file or a source package is given, \n");
            out.append("run command compiles and runs it. \n");
            out.append("\n");
            out.append("By default, 'ballerina run' executes the main function. \n");
            out.append("If the main function is not there, it executes services. \n");
            out.append("\n");
            out.append("If the -s flag is given, 'ballerina run' executes\n");
            out.append("services instead of the main function.\n");
        }

        @Override
        public void printUsage(StringBuilder out) {
            out.append("  ballerina run [flags] <balfile | packagename | balxfile> [args...] \n");
        }

        @Override
        public void setParentCmdParser(JCommander parentCmdParser) {
            this.parentCmdParser = parentCmdParser;
        }

        @Override
        public void setSelfCmdParser(JCommander selfCmdParser) {
        }
    }
}

