/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.launcher.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.launcher.LauncherUtils;
import org.ballerinalang.launcher.util.BRunUtil;
import org.ballerinalang.launcher.util.CompileResult;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.types.BStructType;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.StructInfo;
import org.ballerinalang.util.diagnostic.DiagnosticListener;
import org.wso2.ballerinalang.compiler.Compiler;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.programfile.ProgramFile;

public class BCompileUtil {
    private static Path resourceDir = Paths.get("src/test/resources", new String[0]).toAbsolutePath();

    public static CompileResult compileAndSetup(String sourceFilePath) {
        CompileResult compileResult = BCompileUtil.compile(sourceFilePath, CompilerPhase.CODE_GEN);
        BRunUtil.invokePackageInit(compileResult);
        return compileResult;
    }

    public static CompileResult compileAndSetup(Object obj, String sourceRoot, String packageName) {
        CompileResult compileResult = BCompileUtil.compile(obj, sourceRoot, packageName);
        BRunUtil.invokePackageInit(compileResult, packageName);
        return compileResult;
    }

    public static CompileResult compile(String sourceFilePath) {
        return BCompileUtil.compile(sourceFilePath, CompilerPhase.CODE_GEN);
    }

    public static CompileResult compile(Object obj, String sourceRoot, String packageName) {
        try {
            String effectiveSource;
            CodeSource codeSource = obj.getClass().getProtectionDomain().getCodeSource();
            URL location = codeSource.getLocation();
            URI locationUri = location.toURI();
            Path pathLocation = Paths.get(locationUri);
            String filePath = BCompileUtil.concatFileName(sourceRoot, pathLocation);
            Path rootPath = Paths.get(filePath, new String[0]);
            Path packagePath = Paths.get(packageName, new String[0]);
            if (Files.isDirectory(packagePath, new LinkOption[0])) {
                String[] pkgParts = packageName.split("\\/");
                List pkgNameComps = Arrays.stream(pkgParts).map(part -> {
                    if (part.equals("")) {
                        return Names.EMPTY;
                    }
                    if (part.equals("_")) {
                        return Names.EMPTY;
                    }
                    return new Name(part);
                }).collect(Collectors.toList());
                PackageID pkgId = new PackageID(pkgNameComps, Names.DEFAULT_VERSION);
                effectiveSource = pkgId.getName().getValue();
            } else {
                effectiveSource = packageName;
            }
            return BCompileUtil.compile(rootPath.toString(), effectiveSource, CompilerPhase.CODE_GEN);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("error while running test: " + e.getMessage());
        }
    }

    public static String concatFileName(String fileName, Path pathLocation) {
        String windowsFolderSeparator = "\\";
        String unixFolderSeparator = "/";
        StringBuilder path = new StringBuilder(pathLocation.toAbsolutePath().toString());
        path = pathLocation.endsWith("\\") ? path.append("\\").append(fileName) : path.append("/").append(fileName);
        return path.toString();
    }

    public static CompileResult compile(String sourceFilePath, CompilerPhase compilerPhase) {
        Path sourcePath = Paths.get(sourceFilePath, new String[0]);
        String packageName = sourcePath.getFileName().toString();
        Path sourceRoot = resourceDir.resolve(sourcePath.getParent());
        return BCompileUtil.compile(sourceRoot.toString(), packageName, compilerPhase);
    }

    public static CompileResult compile(String sourceRoot, String packageName, CompilerPhase compilerPhase) {
        CompilerContext context = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.SOURCE_ROOT, resourceDir.resolve(sourceRoot).toString());
        options.put(CompilerOptionName.COMPILER_PHASE, compilerPhase.toString());
        options.put(CompilerOptionName.PRESERVE_WHITESPACE, "false");
        CompileResult comResult = new CompileResult();
        DiagnosticListener listener = comResult::addDiagnostic;
        context.put(DiagnosticListener.class, (Object)listener);
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        compiler.compile(packageName);
        ProgramFile programFile = compiler.getCompiledProgram();
        if (programFile != null) {
            comResult.setProgFile(LauncherUtils.getExecutableProgram(programFile));
        }
        return comResult;
    }

    public static BLangPackage compileAndGetPackage(String sourceFilePath) {
        Path sourcePath = Paths.get(sourceFilePath, new String[0]);
        String packageName = sourcePath.getFileName().toString();
        Path sourceRoot = resourceDir.resolve(sourcePath.getParent());
        CompilerContext context = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.SOURCE_ROOT, resourceDir.resolve(sourceRoot).toString());
        options.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.CODE_GEN.toString());
        options.put(CompilerOptionName.PRESERVE_WHITESPACE, "false");
        CompileResult comResult = new CompileResult();
        DiagnosticListener listener = comResult::addDiagnostic;
        context.put(DiagnosticListener.class, (Object)listener);
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        compiler.compile(packageName);
        BLangPackage compiledPkg = (BLangPackage)compiler.getAST();
        return compiledPkg;
    }

    public static void run(String sourceFilePath) {
        CompileResult result = BCompileUtil.compile(sourceFilePath);
        org.ballerinalang.util.codegen.ProgramFile programFile = result.getProgFile();
        if (!programFile.isMainEPAvailable() && !programFile.isServiceEPAvailable()) {
            throw new RuntimeException("main function not found in '" + programFile.getProgramFilePath() + "'");
        }
        if (programFile.isMainEPAvailable()) {
            LauncherUtils.runMain(programFile, new String[0]);
        } else {
            LauncherUtils.runServices(programFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(String path) {
        InputStream is = ClassLoader.getSystemResourceAsStream(path);
        InputStreamReader inputStreamREader = null;
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            inputStreamREader = new InputStreamReader(is, StandardCharsets.UTF_8);
            br = new BufferedReader(inputStreamREader);
            String content = br.readLine();
            if (content == null) {
                String string = sb.toString();
                return string;
            }
            sb.append(content);
            while ((content = br.readLine()) != null) {
                sb.append("\n" + content);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (inputStreamREader != null) {
                try {
                    inputStreamREader.close();
                }
                catch (IOException iOException) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    public static BStruct createAndGetStruct(org.ballerinalang.util.codegen.ProgramFile programFile, String packagePath, String structName) {
        PackageInfo structPackageInfo = programFile.getPackageInfo(packagePath);
        StructInfo structInfo = structPackageInfo.getStructInfo(structName);
        BStructType structType = structInfo.getType();
        return new BStruct(structType);
    }
}

