/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.launcher.util;

import org.ballerinalang.bre.Context;
import org.ballerinalang.launcher.util.CompileResult;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.codegen.FunctionInfo;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.program.BLangFunctions;

public class BRunUtil {
    public static BValue[] invokeStateful(CompileResult compileResult, String functionName) {
        BValue[] args = new BValue[]{};
        return BRunUtil.invokeStateful(compileResult, functionName, args);
    }

    public static BValue[] invokeStateful(CompileResult compileResult, String functionName, BValue[] args) {
        if (compileResult.getErrorCount() > 0) {
            throw new IllegalStateException("compilation contains errors.");
        }
        return BRunUtil.invokeStateful(compileResult, compileResult.getProgFile().getEntryPkgName(), functionName, args);
    }

    public static BValue[] invokeStateful(CompileResult compileResult, String packageName, String functionName) {
        BValue[] args = new BValue[]{};
        return BRunUtil.invokeStateful(compileResult, packageName, functionName, args);
    }

    public static BValue[] invokeStateful(CompileResult compileResult, String packageName, String functionName, BValue[] args) {
        if (compileResult.getErrorCount() > 0) {
            throw new IllegalStateException("compilation contains errors.");
        }
        ProgramFile programFile = compileResult.getProgFile();
        PackageInfo packageInfo = programFile.getPackageInfo(packageName);
        FunctionInfo functionInfo = packageInfo.getFunctionInfo(functionName);
        if (functionInfo == null) {
            throw new RuntimeException("Function '" + functionName + "' is not defined");
        }
        if (functionInfo.getParamTypes().length != args.length) {
            throw new RuntimeException("Size of input argument arrays is not equal to size of function parameters");
        }
        return BLangFunctions.invokeFunction((ProgramFile)programFile, (FunctionInfo)functionInfo, (BValue[])args, (Context)compileResult.getContext());
    }

    protected static void invokePackageInit(CompileResult compileResult) {
        if (compileResult.getErrorCount() > 0) {
            throw new IllegalStateException("compilation contains errors.");
        }
        BRunUtil.invokePackageInit(compileResult, compileResult.getProgFile().getEntryPkgName());
    }

    protected static void invokePackageInit(CompileResult compileResult, String packageName) {
        if (compileResult.getErrorCount() > 0) {
            throw new IllegalStateException("compilation contains errors.");
        }
        ProgramFile programFile = compileResult.getProgFile();
        PackageInfo packageInfo = programFile.getPackageInfo(packageName);
        Context context = new Context(programFile);
        compileResult.setContext(context);
        BLangFunctions.invokePackageInitFunction((ProgramFile)programFile, (FunctionInfo)packageInfo.getInitFunctionInfo(), (Context)context);
    }

    public static BValue[] invoke(CompileResult compileResult, String packageName, String functionName, BValue[] args) {
        if (compileResult.getErrorCount() > 0) {
            throw new IllegalStateException("compilation contains errors.");
        }
        ProgramFile programFile = compileResult.getProgFile();
        return BLangFunctions.invokeNew((ProgramFile)programFile, (String)packageName, (String)functionName, (BValue[])args);
    }

    public static BValue[] invoke(CompileResult compileResult, String packageName, String functionName) {
        BValue[] args = new BValue[]{};
        return BRunUtil.invoke(compileResult, packageName, functionName, args);
    }

    public static BValue[] invoke(CompileResult compileResult, String functionName, BValue[] args) {
        if (compileResult.getErrorCount() > 0) {
            throw new IllegalStateException("compilation contains errors.");
        }
        ProgramFile programFile = compileResult.getProgFile();
        return BLangFunctions.invokeNew((ProgramFile)programFile, (String)programFile.getEntryPkgName(), (String)functionName, (BValue[])args);
    }

    public static BValue[] invoke(CompileResult compileResult, String functionName, BValue[] args, Context context) {
        if (compileResult.getErrorCount() > 0) {
            throw new IllegalStateException("compilation contains errors.");
        }
        ProgramFile programFile = compileResult.getProgFile();
        return BLangFunctions.invokeNew((ProgramFile)programFile, (String)programFile.getEntryPkgName(), (String)functionName, (BValue[])args, (Context)context);
    }

    public static BValue[] invoke(CompileResult compileResult, String functionName) {
        BValue[] args = new BValue[]{};
        return BRunUtil.invoke(compileResult, functionName, args);
    }

    public static void invoke(CompileResult compileResult, FunctionInfo initFuncInfo, Context context) {
        BLangFunctions.invokeFunction((ProgramFile)compileResult.getProgFile(), (FunctionInfo)initFuncInfo, (Context)context);
    }
}

