/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.launcher.util;

import org.ballerinalang.BLangProgramRunner;
import org.ballerinalang.connector.impl.ServerConnectorRegistry;
import org.ballerinalang.launcher.util.BCompileUtil;
import org.ballerinalang.launcher.util.CompileResult;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.ServiceInfo;

public class BServiceUtil {
    public static void runService(CompileResult compileResult) {
        ServerConnectorRegistry.getInstance().initServerConnectors();
        BLangProgramRunner.runService((ProgramFile)compileResult.getProgFile());
    }

    public static CompileResult setupProgramFile(Object obj, String sourcePath, String pkgPath) {
        CompileResult compileResult = pkgPath == null ? BCompileUtil.compile(sourcePath) : BCompileUtil.compile(obj, sourcePath, pkgPath);
        BServiceUtil.runService(compileResult);
        return compileResult;
    }

    public static CompileResult setupProgramFile(Object obj, String sourcePath) {
        return BServiceUtil.setupProgramFile(obj, sourcePath, null);
    }

    public static void cleanup(CompileResult compileResult) {
        ProgramFile programFile = compileResult.getProgFile();
        PackageInfo packageInfo = programFile.getEntryPackage();
        for (ServiceInfo serviceInfo : packageInfo.getServiceInfoEntries()) {
            ServerConnectorRegistry.getInstance().unRegisterService(serviceInfo);
        }
    }
}

