/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.system.nativeimpl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.stdlib.system.utils.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exec {
    private static final Logger log = LoggerFactory.getLogger(Exec.class);

    public static Object exec(String command, MapValue<String, String> env, Object dir, ArrayValue args) {
        String space = " ";
        ArrayList<String> commandList = new ArrayList<String>(Arrays.asList(command.split(space)));
        for (String arg : args.getStringArray()) {
            commandList.addAll(Arrays.asList(arg.split(space)));
        }
        ProcessBuilder pb = new ProcessBuilder(commandList);
        if (dir != null) {
            pb.directory(new File((String)dir));
        }
        if (env != null) {
            Map<String, String> pbEnv = pb.environment();
            env.entrySet().forEach(entry -> {
                String cfr_ignored_0 = (String)pbEnv.put((String)entry.getKey(), (String)entry.getValue());
            });
        }
        try {
            return SystemUtils.getProcessObject(pb.start());
        }
        catch (IOException e) {
            log.error("IO error while executing the command: " + commandList, (Throwable)e);
            return SystemUtils.getBallerinaError("{ballerina/system}InvalidOperationError", e);
        }
    }
}

