/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.docgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.docgen.model.ActionDoc;
import org.ballerinalang.docgen.model.AnnotationDoc;
import org.ballerinalang.docgen.model.ConnectorDoc;
import org.ballerinalang.docgen.model.Documentable;
import org.ballerinalang.docgen.model.EnumDoc;
import org.ballerinalang.docgen.model.Field;
import org.ballerinalang.docgen.model.FunctionDoc;
import org.ballerinalang.docgen.model.GlobalVariableDoc;
import org.ballerinalang.docgen.model.Link;
import org.ballerinalang.docgen.model.PackageName;
import org.ballerinalang.docgen.model.Page;
import org.ballerinalang.docgen.model.PrimitiveTypeDoc;
import org.ballerinalang.docgen.model.StaticCaption;
import org.ballerinalang.docgen.model.StructDoc;
import org.ballerinalang.docgen.model.Variable;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.tree.AnnotatableNode;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.EnumNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.types.TypeNode;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructType;
import org.wso2.ballerinalang.compiler.tree.BLangAction;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotAttribute;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangConnector;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangStruct;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;

public class Generator {
    private static final String ANONYMOUS_STRUCT = "$anonStruct$";

    public static Page generatePage(BLangPackage balPackage, List<Link> packages) {
        ArrayList<Documentable> documentables = new ArrayList<Documentable>();
        String currentPackageName = balPackage.symbol.pkgID.name.value;
        if (balPackage.getStructs().size() > 0) {
            for (BLangStruct struct : balPackage.getStructs()) {
                if (!struct.getFlags().contains(Flag.PUBLIC)) continue;
                documentables.add(Generator.createDocForNode(struct));
            }
        }
        if (balPackage.getFunctions().size() > 0) {
            for (BLangFunction function : balPackage.getFunctions()) {
                if (!function.getFlags().contains(Flag.PUBLIC)) continue;
                if (function.getReceiver() != null) {
                    if (documentables.size() <= 0) continue;
                    for (Documentable parentDocumentable : documentables) {
                        TypeNode langType = function.getReceiver().getTypeNode();
                        String typeName = langType instanceof BLangUserDefinedType ? ((BLangUserDefinedType)langType).typeName.value : langType.toString();
                        if (!typeName.equals(parentDocumentable.name)) continue;
                        parentDocumentable.children.add(Generator.createDocForNode(function));
                    }
                    continue;
                }
                documentables.add(Generator.createDocForNode(function));
            }
        }
        for (BLangConnector connector : balPackage.getConnectors()) {
            if (!connector.getFlags().contains(Flag.PUBLIC)) continue;
            documentables.add(Generator.createDocForNode(connector));
        }
        for (EnumNode enumNode : balPackage.getEnums()) {
            if (!enumNode.getFlags().contains(Flag.PUBLIC)) continue;
            documentables.add(Generator.createDocForNode(enumNode));
        }
        for (BLangAnnotation annotation : balPackage.getAnnotations()) {
            if (!annotation.getFlags().contains(Flag.PUBLIC)) continue;
            documentables.add(Generator.createDocForNode(annotation));
        }
        for (BLangVariable var : balPackage.getGlobalVariables()) {
            if (!var.getFlags().contains(Flag.PUBLIC)) continue;
            documentables.add(Generator.createDocForNode(var));
        }
        ArrayList<Link> links = new ArrayList<Link>();
        PackageName packageNameHeading = null;
        for (Link pkgLink : packages) {
            if (pkgLink.caption.value.equals(currentPackageName)) {
                packageNameHeading = (PackageName)pkgLink.caption;
                links.add(new Link(pkgLink.caption, pkgLink.href, true));
                continue;
            }
            links.add(new Link(pkgLink.caption, pkgLink.href, false));
        }
        return new Page(packageNameHeading, documentables, links);
    }

    public static Page generatePageForPrimitives(BLangPackage balPackage, List<Link> packages) {
        ArrayList<Documentable> primitiveTypes = new ArrayList<Documentable>();
        if (balPackage.getFunctions().size() > 0) {
            for (BLangFunction function : balPackage.getFunctions()) {
                PrimitiveTypeDoc primitiveTypeDoc;
                TypeNode langType;
                if (!function.getFlags().contains(Flag.PUBLIC) || function.getReceiver() == null || (langType = function.getReceiver().getTypeNode()) instanceof BLangUserDefinedType) continue;
                Optional<PrimitiveTypeDoc> existingPrimitiveType = primitiveTypes.stream().filter(doc -> doc instanceof PrimitiveTypeDoc && ((PrimitiveTypeDoc)doc).name.equals(langType.toString())).map(doc -> (PrimitiveTypeDoc)doc).findFirst();
                if (existingPrimitiveType.isPresent()) {
                    primitiveTypeDoc = existingPrimitiveType.get();
                } else {
                    primitiveTypeDoc = new PrimitiveTypeDoc(langType.toString(), new ArrayList<Documentable>());
                    primitiveTypes.add(primitiveTypeDoc);
                }
                primitiveTypeDoc.children.add(Generator.createDocForNode(function));
            }
        }
        ArrayList<Link> links = new ArrayList<Link>();
        for (Link pkgLink : packages) {
            if ("Primitive Types".equals(pkgLink.caption.value)) {
                links.add(new Link(pkgLink.caption, pkgLink.href, true));
                continue;
            }
            links.add(new Link(pkgLink.caption, pkgLink.href, false));
        }
        StaticCaption primitivesPageHeading = new StaticCaption("Primitive Types");
        return new Page(primitivesPageHeading, primitiveTypes, links);
    }

    public static EnumDoc createDocForNode(EnumNode enumNode) {
        String enumName = enumNode.getName().getValue();
        ArrayList<Variable> enumerators = new ArrayList<Variable>();
        if (enumNode.getEnumerators().size() > 0) {
            for (EnumNode.Enumerator enumerator : enumNode.getEnumerators()) {
                String desc = Generator.fieldAnnotation((BLangNode)enumNode, (BLangNode)enumerator);
                Variable variable = new Variable(enumerator.getName().getValue(), "", desc);
                enumerators.add(variable);
            }
        }
        return new EnumDoc(enumName, Generator.description((BLangNode)enumNode), new ArrayList<Documentable>(), enumerators);
    }

    public static AnnotationDoc createDocForNode(BLangAnnotation annotationNode) {
        String annotationName = annotationNode.getName().getValue();
        ArrayList<Variable> attributes = new ArrayList<Variable>();
        if (annotationNode.getAttributes().size() > 0) {
            for (BLangAnnotAttribute annotAttribute : annotationNode.getAttributes()) {
                String dataType = Generator.getTypeName(annotAttribute.getTypeNode());
                String desc = Generator.annotFieldAnnotation(annotationNode, annotAttribute);
                Variable variable = new Variable(annotAttribute.getName().value, dataType, desc);
                attributes.add(variable);
            }
        }
        return new AnnotationDoc(annotationName, Generator.description((BLangNode)annotationNode), new ArrayList<Documentable>(), attributes);
    }

    public static GlobalVariableDoc createDocForNode(BLangVariable bLangVariable) {
        String globalVarName = bLangVariable.getName().getValue();
        String dataType = Generator.getTypeName(bLangVariable.getTypeNode());
        String desc = Generator.description((BLangNode)bLangVariable);
        return new GlobalVariableDoc(globalVarName, desc, new ArrayList<Documentable>(), dataType);
    }

    public static FunctionDoc createDocForNode(BLangFunction functionNode) {
        String functionName = functionNode.getName().value;
        ArrayList<Variable> parameters = new ArrayList<Variable>();
        ArrayList<Variable> returnParams = new ArrayList<Variable>();
        if (functionNode.getParameters().size() > 0) {
            for (BLangVariable param : functionNode.getParameters()) {
                String dataType = Generator.type(param);
                String desc = Generator.paramAnnotation((BLangNode)functionNode, param);
                Variable variable = new Variable(param.getName().value, dataType, desc);
                parameters.add(variable);
            }
        }
        return new FunctionDoc(functionName, Generator.description((BLangNode)functionNode), new ArrayList<Documentable>(), parameters, returnParams);
    }

    public static ActionDoc createDocForNode(BLangAction actionNode) {
        String actionName = actionNode.getName().value;
        ArrayList<Variable> parameters = new ArrayList<Variable>();
        ArrayList<Variable> returnParams = new ArrayList<Variable>();
        if (actionNode.getParameters().size() > 0) {
            for (BLangVariable param : actionNode.getParameters()) {
                String dataType = Generator.type(param);
                String desc = Generator.paramAnnotation((BLangNode)actionNode, param);
                Variable variable = new Variable(param.getName().value, dataType, desc);
                parameters.add(variable);
            }
        }
        return new ActionDoc(actionName, Generator.description((BLangNode)actionNode), new ArrayList<Documentable>(), parameters, returnParams);
    }

    public static StructDoc createDocForNode(BLangStruct structNode) {
        String structName = structNode.getName().value;
        if (structName.contains(ANONYMOUS_STRUCT)) {
            structName = "Anonymous Struct";
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        if (structNode.getFields().size() > 0) {
            for (BLangVariable param : structNode.getFields()) {
                String dataType = Generator.type(param);
                String desc = Generator.fieldAnnotation((BLangNode)structNode, (BLangNode)param);
                String defaultValue = "";
                if (null != param.getInitialExpression()) {
                    defaultValue = param.getInitialExpression().toString();
                }
                Field variable = new Field(param.getName().value, dataType, desc, defaultValue);
                fields.add(variable);
            }
        }
        return new StructDoc(structName, Generator.description((BLangNode)structNode), new ArrayList<Documentable>(), fields);
    }

    public static ConnectorDoc createDocForNode(BLangConnector connectorNode) {
        String connectorName = connectorNode.getName().value;
        ArrayList<Variable> parameters = new ArrayList<Variable>();
        ArrayList<Documentable> actions = new ArrayList<Documentable>();
        if (connectorNode.getParameters().size() > 0) {
            for (BLangVariable param : connectorNode.getParameters()) {
                String dataType = Generator.type(param);
                String desc = Generator.paramAnnotation((BLangNode)connectorNode, param);
                Variable variable = new Variable(param.getName().value, dataType, desc);
                parameters.add(variable);
            }
        }
        if (connectorNode.getActions().size() > 0) {
            for (BLangAction action : connectorNode.getActions()) {
                actions.add(Generator.createDocForNode(action));
            }
        }
        return new ConnectorDoc(connectorName, Generator.description((BLangNode)connectorNode), actions, parameters);
    }

    private static String type(BLangVariable bLangVariable) {
        if (bLangVariable.typeNode.getKind() == NodeKind.USER_DEFINED_TYPE && ((BLangUserDefinedType)bLangVariable.typeNode).typeName.value.contains(ANONYMOUS_STRUCT)) {
            return Generator.getAnonStructString((BStructType)bLangVariable.type);
        }
        return Generator.getTypeName(bLangVariable.typeNode);
    }

    private static String getTypeName(BLangType bLangType) {
        return bLangType instanceof BLangUserDefinedType ? ((BLangUserDefinedType)bLangType).typeName.value : bLangType.toString();
    }

    private static List<? extends AnnotationAttachmentNode> getAnnotationAttachments(BLangNode node) {
        return ((AnnotatableNode)node).getAnnotationAttachments();
    }

    private static String paramAnnotation(BLangNode node, BLangVariable param) {
        String subName = param.getName() == null ? param.type.tsymbol.name.value : param.getName().getValue();
        for (AnnotationAttachmentNode annotationAttachmentNode : Generator.getAnnotationAttachments(node)) {
            BLangRecordLiteral bLangRecordLiteral = (BLangRecordLiteral)annotationAttachmentNode.getExpression();
            if (bLangRecordLiteral.getKeyValuePairs().size() != 1) continue;
            BLangExpression bLangLiteral = ((BLangRecordLiteral.BLangRecordKeyValue)bLangRecordLiteral.getKeyValuePairs().get(0)).getValue();
            String attribVal = bLangLiteral.toString();
            if (!annotationAttachmentNode.getAnnotationName().getValue().equals("Param") || !attribVal.startsWith(subName + ":")) continue;
            return attribVal.split(subName + ":")[1].trim();
        }
        return "";
    }

    public static String returnParamAnnotation(BLangNode node, int returnTypeIndex) {
        int currentReturnAnnotationIndex = 0;
        for (AnnotationAttachmentNode annotationAttachmentNode : Generator.getAnnotationAttachments(node)) {
            BLangRecordLiteral bLangRecordLiteral = (BLangRecordLiteral)annotationAttachmentNode.getExpression();
            if (bLangRecordLiteral.getKeyValuePairs().size() != 1 || !annotationAttachmentNode.getAnnotationName().getValue().equals("Return")) continue;
            if (currentReturnAnnotationIndex == returnTypeIndex) {
                BLangExpression bLangLiteral = ((BLangRecordLiteral.BLangRecordKeyValue)bLangRecordLiteral.getKeyValuePairs().get(0)).getValue();
                return bLangLiteral.toString();
            }
            ++currentReturnAnnotationIndex;
        }
        return "";
    }

    private static String fieldAnnotation(BLangNode node, BLangNode param) {
        BLangExpression bLangLiteral;
        BLangRecordLiteral bLangRecordLiteral;
        String subName = "";
        if (param instanceof BLangVariable) {
            BLangVariable paramVariable = (BLangVariable)param;
            subName = paramVariable.getName() == null ? paramVariable.type.tsymbol.name.value : paramVariable.getName().getValue();
        } else if (param instanceof EnumNode.Enumerator) {
            EnumNode.Enumerator paramEnumVal = (EnumNode.Enumerator)param;
            subName = paramEnumVal.getName().getValue();
        }
        for (AnnotationAttachmentNode annotationAttachmentNode : Generator.getAnnotationAttachments(node)) {
            bLangRecordLiteral = (BLangRecordLiteral)annotationAttachmentNode.getExpression();
            if (bLangRecordLiteral.getKeyValuePairs().size() != 1) continue;
            bLangLiteral = ((BLangRecordLiteral.BLangRecordKeyValue)bLangRecordLiteral.getKeyValuePairs().get(0)).getValue();
            String attribVal = bLangLiteral.toString();
            if (!annotationAttachmentNode.getAnnotationName().getValue().equals("Field") || !attribVal.startsWith(subName + ":")) continue;
            return attribVal.split(subName + ":")[1].trim();
        }
        for (AnnotationAttachmentNode annotationAttachmentNode : Generator.getAnnotationAttachments(node)) {
            bLangRecordLiteral = (BLangRecordLiteral)annotationAttachmentNode.getExpression();
            if (bLangRecordLiteral.getKeyValuePairs().size() != 1 || !annotationAttachmentNode.getAnnotationName().getValue().equals("Field")) continue;
            bLangLiteral = ((BLangRecordLiteral.BLangRecordKeyValue)bLangRecordLiteral.getKeyValuePairs().get(0)).getValue();
            return bLangLiteral.toString();
        }
        return "";
    }

    private static String annotFieldAnnotation(BLangAnnotation annotationNode, BLangAnnotAttribute annotAttribute) {
        List<? extends AnnotationAttachmentNode> annotationAttachments = Generator.getAnnotationAttachments((BLangNode)annotationNode);
        for (AnnotationAttachmentNode annotationAttachmentNode : annotationAttachments) {
            BLangRecordLiteral bLangRecordLiteral;
            BLangExpression bLangLiteral;
            String value;
            if (!"Field".equals(annotationAttachmentNode.getAnnotationName().getValue()) || !(value = (bLangLiteral = ((BLangRecordLiteral.BLangRecordKeyValue)(bLangRecordLiteral = (BLangRecordLiteral)annotationAttachmentNode.getExpression()).getKeyValuePairs().get(0)).getValue()).toString()).startsWith(annotAttribute.getName().getValue())) continue;
            String[] valueParts = value.split(":");
            return valueParts.length == 2 ? valueParts[1] : valueParts[0];
        }
        return "";
    }

    private static String description(BLangNode node) {
        if (Generator.getAnnotationAttachments(node).size() == 0) {
            return null;
        }
        for (AnnotationAttachmentNode annotationAttachmentNode : Generator.getAnnotationAttachments(node)) {
            BLangRecordLiteral bLangRecordLiteral = (BLangRecordLiteral)annotationAttachmentNode.getExpression();
            if (bLangRecordLiteral.getKeyValuePairs().size() != 1 || !annotationAttachmentNode.getAnnotationName().getValue().equals("Description")) continue;
            BLangExpression bLangLiteral = ((BLangRecordLiteral.BLangRecordKeyValue)bLangRecordLiteral.getKeyValuePairs().get(0)).getValue();
            return bLangLiteral.toString();
        }
        return "";
    }

    private static String getAnonStructString(BStructType type) {
        StringBuilder builder = new StringBuilder();
        builder.append("struct {");
        int nFields = type.fields.size();
        for (int i = 0; i < nFields; ++i) {
            BStructType.BStructField field = (BStructType.BStructField)type.fields.get(i);
            builder.append(field.type.toString()).append(" ").append(field.name.value);
            if (i == nFields - 1) {
                return builder.append("}").toString();
            }
            builder.append(", ");
        }
        return builder.append("}").toString();
    }
}

