/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.docgen.docs;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.docgen.Generator;
import org.ballerinalang.docgen.Writer;
import org.ballerinalang.docgen.docs.BallerinaDocDataHolder;
import org.ballerinalang.docgen.docs.utils.BallerinaDocUtils;
import org.ballerinalang.docgen.model.Link;
import org.ballerinalang.docgen.model.PackageName;
import org.ballerinalang.docgen.model.Page;
import org.ballerinalang.docgen.model.StaticCaption;
import org.ballerinalang.launcher.LauncherUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.ballerinalang.compiler.Compiler;
import org.wso2.ballerinalang.compiler.PackageLoader;
import org.wso2.ballerinalang.compiler.semantics.analyzer.CodeAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SemanticAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.Names;

public class BallerinaDocGenerator {
    private static final Logger log = LoggerFactory.getLogger(BallerinaDocGenerator.class);
    private static final PrintStream out = System.out;
    private static final String BSOURCE_FILE_EXT = ".bal";
    private static final Path BAL_BUILTIN = Paths.get("ballerina/builtin", new String[0]);
    private static final Path BAL_BUILTIN_CORE = Paths.get("ballerina/builtin/core", new String[0]);
    private static final String HTML = ".html";

    public static void generateApiDocs(String output, String packageFilter, boolean isNative, String ... sources) {
        out.println("docerina: API documentation generation for sources - " + Arrays.toString(sources));
        for (String source : sources) {
            source = source.trim();
            try {
                Map<String, BLangPackage> docsMap;
                if (source.endsWith(BSOURCE_FILE_EXT)) {
                    Path sourceFilePath = Paths.get(source, new String[0]);
                    Path parentDir = sourceFilePath.getParent();
                    Path fileName = sourceFilePath.getFileName();
                    if (fileName == null) {
                        log.warn("Skipping the source generation for invalid path: " + sourceFilePath);
                        continue;
                    }
                    if (parentDir == null) {
                        parentDir = Paths.get(".", new String[0]);
                    }
                    docsMap = BallerinaDocGenerator.generatePackageDocsFromBallerina(parentDir.toString(), fileName, packageFilter, isNative);
                } else {
                    Path dirPath = Paths.get(source, new String[0]);
                    Path projectFolder = dirPath.resolve(".ballerina");
                    Files.createDirectory(projectFolder, new FileAttribute[0]);
                    Path sourceRootPath = LauncherUtils.getSourceRootPath((String)dirPath.toString());
                    docsMap = BallerinaDocGenerator.generatePackageDocsFromBallerina(sourceRootPath.toString(), dirPath, packageFilter, isNative);
                }
                if (docsMap.size() == 0) {
                    out.println("docerina: no package definitions found!");
                    return;
                }
                if (BallerinaDocUtils.isDebugEnabled()) {
                    out.println("Generating HTML API documentation...");
                }
                String userDir = System.getProperty("user.dir");
                if (output == null) {
                    output = System.getProperty("html.output.path", userDir + File.separator + "api-docs" + File.separator + "html");
                }
                Files.createDirectories(Paths.get(output, new String[0]), new FileAttribute[0]);
                ArrayList<BLangPackage> packageList = new ArrayList<BLangPackage>(docsMap.values());
                packageList.sort(Comparator.comparing(pkg -> pkg.packageID.toString()));
                ArrayList<String> packageNames = new ArrayList<String>(docsMap.keySet());
                Collections.sort(packageNames);
                List<Link> packageNameList = PackageName.convertList(packageNames);
                if (packageNames.contains("ballerina.builtin")) {
                    StaticCaption primitivesLinkName = new StaticCaption("Primitive Types");
                    packageNameList.add(0, new Link(primitivesLinkName, "primitive-types", false));
                }
                String packageTemplateName = System.getProperty("package.template.name", "page");
                for (BLangPackage bLangPackage : packageList) {
                    bLangPackage.getFunctions().sort(Comparator.comparing(f -> (f.getReceiver() == null ? "" : f.getReceiver().getName()) + f.getName().getValue()));
                    bLangPackage.getConnectors().sort(Comparator.comparing(c -> c.getName().getValue()));
                    bLangPackage.getStructs().sort(Comparator.comparing(s -> s.getName().getValue()));
                    bLangPackage.getAnnotations().sort(Comparator.comparing(a -> a.getName().getValue()));
                    bLangPackage.getEnums().sort(Comparator.comparing(a -> a.getName().getValue()));
                    if (bLangPackage.getConnectors() != null && bLangPackage.getConnectors().size() > 0) {
                        bLangPackage.getConnectors().forEach(connector -> connector.getActions().sort(Comparator.comparing(a -> a.getName().getValue())));
                    }
                    String packagePath = BallerinaDocGenerator.refinePackagePath(bLangPackage);
                    Page page = Generator.generatePage(bLangPackage, packageNameList);
                    String filePath = output + File.separator + packagePath + HTML;
                    Writer.writeHtmlDocument(page, packageTemplateName, filePath);
                    if (!"ballerina.builtin".equals(packagePath)) continue;
                    Page primitivesPage = Generator.generatePageForPrimitives(bLangPackage, packageNameList);
                    String primitivesFilePath = output + File.separator + "primitive-types" + HTML;
                    Writer.writeHtmlDocument(primitivesPage, packageTemplateName, primitivesFilePath);
                }
                String indexTemplateName = System.getProperty("package.template.name", "index");
                String indexFilePath = output + File.separator + "index" + HTML;
                Writer.writeHtmlDocument(packageNameList, indexTemplateName, indexFilePath);
                if (BallerinaDocUtils.isDebugEnabled()) {
                    out.println("Copying HTML theme...");
                }
                BallerinaDocUtils.copyResources("docerina-theme", output);
            }
            catch (IOException e) {
                out.println(String.format("docerina: API documentation generation failed for %s: %s", source, e.getMessage()));
                log.error(String.format("API documentation generation failed for %s", source), (Throwable)e);
            }
        }
        try {
            String zipPath = System.getProperty("output.zip.path");
            if (zipPath != null) {
                BallerinaDocUtils.packageToZipFile(output, zipPath);
            }
        }
        catch (IOException e) {
            out.println(String.format("docerina: API documentation zip packaging failed for %s: %s", output, e.getMessage()));
            log.error(String.format("API documentation zip packaging failed for %s", output), (Throwable)e);
        }
    }

    protected static Map<String, BLangPackage> generatePackageDocsFromBallerina(String sourceRoot, String packagePath) throws IOException {
        return BallerinaDocGenerator.generatePackageDocsFromBallerina(sourceRoot, packagePath, null);
    }

    protected static Map<String, BLangPackage> generatePackageDocsFromBallerina(String sourceRoot, String packagePath, String packageFilter) throws IOException {
        return BallerinaDocGenerator.generatePackageDocsFromBallerina(sourceRoot, packagePath, packageFilter, false);
    }

    protected static Map<String, BLangPackage> generatePackageDocsFromBallerina(String sourceRoot, String packagePath, String packageFilter, boolean isNative) throws IOException {
        return BallerinaDocGenerator.generatePackageDocsFromBallerina(sourceRoot, Paths.get(packagePath, new String[0]), packageFilter, isNative);
    }

    protected static Map<String, BLangPackage> generatePackageDocsFromBallerina(String sourceRoot, Path packagePath, String packageFilter, boolean isNative) throws IOException {
        ArrayList<Path> packagePaths = new ArrayList<Path>();
        if (Files.isDirectory(packagePath, new LinkOption[0])) {
            BallerinaSubPackageVisitor subPackageVisitor = new BallerinaSubPackageVisitor(packagePath, packagePaths);
            Files.walkFileTree(packagePath, subPackageVisitor);
        } else {
            packagePaths.add(packagePath);
        }
        BallerinaDocDataHolder dataHolder = BallerinaDocDataHolder.getInstance();
        if (!isNative) {
            System.setProperty("skipNatives", "true");
        }
        for (Path path : packagePaths) {
            CompilerContext context = new CompilerContext();
            CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
            options.put(CompilerOptionName.PROJECT_DIR, sourceRoot);
            options.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.DESUGAR.toString());
            options.put(CompilerOptionName.PRESERVE_WHITESPACE, "false");
            Compiler compiler = Compiler.getInstance((CompilerContext)context);
            BLangPackage bLangPackage = BAL_BUILTIN.equals(path) || BAL_BUILTIN_CORE.equals(path) ? BallerinaDocGenerator.loadBuiltInPackage(context) : compiler.compile(BallerinaDocGenerator.getPackageNameFromPath(path));
            if (bLangPackage == null) {
                out.println(String.format("docerina: invalid Ballerina package: %s", packagePath));
                continue;
            }
            String packageName = bLangPackage.symbol.pkgID.name.value;
            if (BallerinaDocGenerator.isFilteredPackage(packageName, packageFilter)) {
                if (!BallerinaDocUtils.isDebugEnabled()) continue;
                out.println("Package " + packageName + " excluded");
                continue;
            }
            dataHolder.getPackageMap().put(packageName, bLangPackage);
        }
        return dataHolder.getPackageMap();
    }

    private static boolean isFilteredPackage(String packageName, String packageFilter) {
        if (packageFilter != null && packageFilter.trim().length() > 0) {
            return Arrays.asList(packageFilter.split(",")).stream().filter(e -> packageName.startsWith(e.replace(".*", ""))).findAny().isPresent();
        }
        return false;
    }

    private static String getPackageNameFromPath(Path path) {
        StringJoiner sj = new StringJoiner(".");
        Iterator<Path> pathItr = path.iterator();
        while (pathItr.hasNext()) {
            sj.add(pathItr.next().toString());
        }
        return sj.toString();
    }

    private static BLangPackage loadBuiltInPackage(CompilerContext context) {
        SymbolTable symbolTable = SymbolTable.getInstance((CompilerContext)context);
        BLangPackage builtInPkg = BallerinaDocGenerator.getBuiltInPackage(context);
        symbolTable.builtInPackageSymbol = builtInPkg.symbol;
        return builtInPkg;
    }

    private static BLangPackage getBuiltInPackage(CompilerContext context) {
        PackageLoader pkgLoader = PackageLoader.getInstance((CompilerContext)context);
        SemanticAnalyzer semAnalyzer = SemanticAnalyzer.getInstance((CompilerContext)context);
        CodeAnalyzer codeAnalyzer = CodeAnalyzer.getInstance((CompilerContext)context);
        return codeAnalyzer.analyze(semAnalyzer.analyze(pkgLoader.loadAndDefinePackage(Names.BUILTIN_ORG.getValue(), Names.BUILTIN_PACKAGE.getValue())));
    }

    private static String refinePackagePath(BLangPackage bLangPackage) {
        if (bLangPackage == null) {
            return "";
        }
        if (bLangPackage.getPosition().getSource().getPackageName().equals(".")) {
            return bLangPackage.getPosition().getSource().getCompilationUnitName();
        }
        return bLangPackage.symbol.pkgID.name.value;
    }

    static class BallerinaSubPackageVisitor
    extends SimpleFileVisitor<Path> {
        private Path source;
        private List<Path> subPackages;

        public BallerinaSubPackageVisitor(Path source, List<Path> aList) {
            this.source = source;
            this.subPackages = aList;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path relativePath;
            if (file.toString().endsWith(BallerinaDocGenerator.BSOURCE_FILE_EXT) && !this.subPackages.contains(relativePath = this.source.relativize(file.getParent()))) {
                this.subPackages.add(relativePath);
            }
            return FileVisitResult.CONTINUE;
        }

        public List<Path> getSubPackages() {
            return this.subPackages;
        }
    }
}

