/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.docgen.model;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.docgen.model.Caption;
import org.ballerinalang.docgen.model.Link;

public class PackageName
extends Caption {
    public final boolean isPackageName;
    public final String prefix;
    public final String suffix;

    public PackageName(String prefix, String suffix) {
        super(prefix + suffix);
        this.prefix = prefix;
        this.suffix = suffix;
        this.isPackageName = true;
    }

    public static List<Link> convertList(List<String> packageNames) {
        AbstractList commonPackagePart = null;
        for (String packageName2 : packageNames) {
            String[] packageNameParts = packageName2.split("\\.");
            if (commonPackagePart == null) {
                commonPackagePart = new LinkedList<String>(Arrays.asList(packageNameParts));
                if (packageNameParts.length - 1 > 0) {
                    commonPackagePart.remove(packageNameParts.length - 1);
                    continue;
                }
            }
            for (int i = 0; i < commonPackagePart.size(); ++i) {
                if (packageNameParts[i].equals(commonPackagePart.get(i))) continue;
                ArrayList<String> newCommonPackagePart = new ArrayList<String>();
                newCommonPackagePart.addAll(Arrays.asList(packageNameParts).subList(0, i));
                commonPackagePart = newCommonPackagePart;
            }
        }
        if (null != commonPackagePart) {
            String prefix = String.join((CharSequence)".", commonPackagePart);
            if (!"".equals(prefix)) {
                prefix = prefix + ".";
            }
            String finalPrefix = prefix;
            return packageNames.stream().map(packageName -> new PackageName(finalPrefix, packageName.replace(finalPrefix, ""))).map(packageObj -> new Link((Caption)packageObj, packageObj.value, true)).collect(Collectors.toList());
        }
        return new ArrayList<Link>();
    }

    public String toString() {
        return "PackageName{prefix='" + this.prefix + '\'' + ", suffix='" + this.suffix + '\'' + '}';
    }
}

