/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars;

import com.github.jknack.handlebars.PathExpression;
import com.github.jknack.handlebars.internal.PathExpressionList;
import com.github.jknack.handlebars.internal.path.DataPath;
import com.github.jknack.handlebars.internal.path.IndexedPath;
import com.github.jknack.handlebars.internal.path.ParentPath;
import com.github.jknack.handlebars.internal.path.PropertyPath;
import com.github.jknack.handlebars.internal.path.ResolveParentPath;
import com.github.jknack.handlebars.internal.path.ResolveThisPath;
import com.github.jknack.handlebars.internal.path.ThisPath;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PathCompiler {
    private static final char RP = ']';
    private static final char LP = '[';
    private static final char AT = '@';
    private static final String PARENT_PATH = "../";
    private static final String PARENT = "..";
    private static final String DOT = ".";
    private static final String DOT_PATH = "./";
    private static final String THIS = "this";
    private static Map<String, List<PathExpression>> cache = new ConcurrentHashMap<String, List<PathExpression>>();
    private static Pattern pattern = Pattern.compile("((\\[[^\\[\\]]+])|(../)|([^" + Pattern.quote("./") + "]+))");

    private PathCompiler() {
    }

    public static List<PathExpression> compile(String key) {
        return PathCompiler.compile(key, true);
    }

    public static List<PathExpression> compile(String key, boolean parentScopeResolution) {
        boolean local = !parentScopeResolution;
        String ukey = key + local;
        List<PathExpression> path = cache.get(ukey);
        if (path == null) {
            path = PathCompiler.parse(key, local);
            cache.put(ukey, path);
        }
        return path;
    }

    private static List<PathExpression> parse(String path, boolean local) {
        PathExpressionList resolvers = new PathExpressionList(path);
        if (THIS.equals(path) || DOT_PATH.equals(path) || DOT.equals(path)) {
            resolvers.add(new ResolveThisPath(path));
            return resolvers;
        }
        if (PARENT.equals(path)) {
            resolvers.add(new ResolveParentPath());
            return resolvers;
        }
        if (path.startsWith(PARENT_PATH)) {
            resolvers.add(new ParentPath());
            resolvers.addAll(PathCompiler.parse(path.substring(PARENT_PATH.length()), local));
            return resolvers;
        }
        if (path.startsWith(DOT_PATH)) {
            resolvers.add(new ThisPath(DOT_PATH));
            resolvers.addAll(PathCompiler.parse(path.substring(DOT_PATH.length()), local));
            return resolvers;
        }
        Matcher matcher = pattern.matcher(path);
        boolean data = false;
        while (matcher.find()) {
            String key = matcher.group(1);
            if (THIS.equals(key)) {
                resolvers.add(new ThisPath(key));
                continue;
            }
            if (PARENT_PATH.equals(key)) {
                resolvers.add(new ParentPath());
                continue;
            }
            if (key.charAt(0) == '@') {
                if (key.length() == 1) {
                    data = true;
                    continue;
                }
                resolvers.add(new DataPath(key));
                continue;
            }
            if (key.charAt(0) == '[' && key.charAt(key.length() - 1) == ']') {
                key = key.substring(1, key.length() - 1);
            }
            try {
                resolvers.add(new IndexedPath(Integer.parseInt(key), key, local));
            }
            catch (NumberFormatException ex) {
                if (data) {
                    resolvers.add(new DataPath('@' + key));
                    continue;
                }
                resolvers.add(new PropertyPath(key, local));
            }
        }
        return resolvers;
    }
}

