/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.SaveImagesCmd;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nonnull;

public class SaveImagesCmdImpl
extends AbstrDockerCmd<SaveImagesCmd, InputStream>
implements SaveImagesCmd {
    private final ImmutableList.Builder<SaveImagesCmd.TaggedImage> taggedImages = ImmutableList.builder();

    public SaveImagesCmdImpl(SaveImagesCmd.Exec exec) {
        super(exec);
    }

    @Override
    public SaveImagesCmd withImage(@Nonnull String name, @Nonnull String tag) {
        this.taggedImages.add((Object)new TaggedImageImpl(name, tag));
        return this;
    }

    @Override
    public List<SaveImagesCmd.TaggedImage> getImages() {
        return this.taggedImages.build();
    }

    @Override
    public InputStream exec() throws NotFoundException {
        return (InputStream)super.exec();
    }

    private static class TaggedImageImpl
    implements SaveImagesCmd.TaggedImage {
        private final String name;
        private final String tag;

        private TaggedImageImpl(String name, String tag) {
            Preconditions.checkNotNull((Object)name, (Object)"image name was not specified");
            Preconditions.checkNotNull((Object)tag, (Object)"image tag was not specified");
            this.name = name;
            this.tag = tag;
        }

        @Override
        public String asString() {
            return this.name + ":" + this.tag;
        }

        public String toString() {
            return this.asString();
        }
    }
}

