/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinax.docker.generator.models;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ballerinax.docker.generator.exceptions.DockerGenException;
import org.ballerinax.docker.generator.models.CopyFileModel;

public class DockerModel {
    private static final boolean WINDOWS_BUILD = Boolean.parseBoolean(System.getenv("BAL_DOCKER_WINDOWS"));
    private String name;
    private String registry;
    private String tag = "latest";
    private boolean push = false;
    private String username;
    private String password;
    private boolean buildImage = true;
    private String baseImage = WINDOWS_BUILD ? "openjdk:8-windowsservercore" : "ballerina/jre8:v1";
    private Set<Integer> ports;
    private boolean enableDebug = false;
    private int debugPort = 5005;
    private String dockerAPIVersion;
    private String dockerHost;
    private String dockerCertPath;
    private boolean isService;
    private String uberJarFileName;
    private Set<CopyFileModel> externalFiles;
    private String commandArg;
    private String cmd;
    private Map<String, String> env;
    private String dockerConfig;

    public DockerModel() {
        this.setDockerAPIVersion(System.getenv("DOCKER_API_VERSION"));
        this.externalFiles = new HashSet<CopyFileModel>();
        this.commandArg = "";
        this.env = new HashMap<String, String>();
    }

    public void setDockerAPIVersion(String dockerAPIVersion) {
        if (null != dockerAPIVersion && !dockerAPIVersion.startsWith("v")) {
            dockerAPIVersion = "v" + dockerAPIVersion;
        }
        this.dockerAPIVersion = dockerAPIVersion;
    }

    public Set<CopyFileModel> getCopyFiles() {
        return this.externalFiles;
    }

    public void setCopyFiles(Set<CopyFileModel> externalFiles) throws DockerGenException {
        this.externalFiles = externalFiles;
        for (CopyFileModel externalFile : externalFiles) {
            if (!externalFile.isBallerinaConf()) continue;
            if (Files.isDirectory(Paths.get(externalFile.getSource(), new String[0]), new LinkOption[0])) {
                throw new DockerGenException("invalid config file given: " + externalFile.getSource());
            }
            this.addCommandArg(" --b7a.config.file=" + externalFile.getTarget());
        }
    }

    public void addCommandArg(String commandArg) {
        this.commandArg = this.commandArg + commandArg;
    }

    public String getCmd() {
        if (this.cmd == null) {
            return null;
        }
        String configFile = "";
        for (CopyFileModel externalFile : this.externalFiles) {
            if (!externalFile.isBallerinaConf()) continue;
            configFile = externalFile.getTarget();
        }
        return this.cmd.replace("${APP}", this.uberJarFileName).replace("${CONFIG_FILE}", configFile);
    }

    public String toString() {
        return "DockerModel{name='" + this.name + '\'' + ", registry='" + this.registry + '\'' + ", tag='" + this.tag + '\'' + ", push=" + this.push + ", username='" + this.username + '\'' + ", buildImage=" + this.buildImage + ", baseImage='" + this.baseImage + '\'' + ", ports=" + this.ports + ", enableDebug=" + this.enableDebug + ", debugPort=" + this.debugPort + ", dockerAPIVersion='" + this.dockerAPIVersion + '\'' + ", dockerHost='" + this.dockerHost + '\'' + ", dockerCertPath='" + this.dockerCertPath + '\'' + ", isService=" + this.isService + ", uberJarFileName='" + this.uberJarFileName + '\'' + ", externalFiles=" + this.externalFiles + ", commandArg='" + this.commandArg + '\'' + ", cmd='" + this.cmd + '\'' + '}';
    }

    public String getName() {
        return this.name;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean isPush() {
        return this.push;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isBuildImage() {
        return this.buildImage;
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public Set<Integer> getPorts() {
        return this.ports;
    }

    public boolean isEnableDebug() {
        return this.enableDebug;
    }

    public int getDebugPort() {
        return this.debugPort;
    }

    public String getDockerAPIVersion() {
        return this.dockerAPIVersion;
    }

    public String getDockerHost() {
        return this.dockerHost;
    }

    public String getDockerCertPath() {
        return this.dockerCertPath;
    }

    public boolean isService() {
        return this.isService;
    }

    public String getUberJarFileName() {
        return this.uberJarFileName;
    }

    public Set<CopyFileModel> getExternalFiles() {
        return this.externalFiles;
    }

    public String getCommandArg() {
        return this.commandArg;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public String getDockerConfig() {
        return this.dockerConfig;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRegistry(String registry) {
        this.registry = registry;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setPush(boolean push) {
        this.push = push;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setBuildImage(boolean buildImage) {
        this.buildImage = buildImage;
    }

    public void setBaseImage(String baseImage) {
        this.baseImage = baseImage;
    }

    public void setPorts(Set<Integer> ports) {
        this.ports = ports;
    }

    public void setEnableDebug(boolean enableDebug) {
        this.enableDebug = enableDebug;
    }

    public void setDebugPort(int debugPort) {
        this.debugPort = debugPort;
    }

    public void setDockerHost(String dockerHost) {
        this.dockerHost = dockerHost;
    }

    public void setDockerCertPath(String dockerCertPath) {
        this.dockerCertPath = dockerCertPath;
    }

    public void setService(boolean isService) {
        this.isService = isService;
    }

    public void setUberJarFileName(String uberJarFileName) {
        this.uberJarFileName = uberJarFileName;
    }

    public void setExternalFiles(Set<CopyFileModel> externalFiles) {
        this.externalFiles = externalFiles;
    }

    public void setCommandArg(String commandArg) {
        this.commandArg = commandArg;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    public void setDockerConfig(String dockerConfig) {
        this.dockerConfig = dockerConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DockerModel)) {
            return false;
        }
        DockerModel other = (DockerModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$registry = this.getRegistry();
        String other$registry = other.getRegistry();
        if (this$registry == null ? other$registry != null : !this$registry.equals(other$registry)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        if (this.isPush() != other.isPush()) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        if (this.isBuildImage() != other.isBuildImage()) {
            return false;
        }
        String this$baseImage = this.getBaseImage();
        String other$baseImage = other.getBaseImage();
        if (this$baseImage == null ? other$baseImage != null : !this$baseImage.equals(other$baseImage)) {
            return false;
        }
        Set<Integer> this$ports = this.getPorts();
        Set<Integer> other$ports = other.getPorts();
        if (this$ports == null ? other$ports != null : !((Object)this$ports).equals(other$ports)) {
            return false;
        }
        if (this.isEnableDebug() != other.isEnableDebug()) {
            return false;
        }
        if (this.getDebugPort() != other.getDebugPort()) {
            return false;
        }
        String this$dockerAPIVersion = this.getDockerAPIVersion();
        String other$dockerAPIVersion = other.getDockerAPIVersion();
        if (this$dockerAPIVersion == null ? other$dockerAPIVersion != null : !this$dockerAPIVersion.equals(other$dockerAPIVersion)) {
            return false;
        }
        String this$dockerHost = this.getDockerHost();
        String other$dockerHost = other.getDockerHost();
        if (this$dockerHost == null ? other$dockerHost != null : !this$dockerHost.equals(other$dockerHost)) {
            return false;
        }
        String this$dockerCertPath = this.getDockerCertPath();
        String other$dockerCertPath = other.getDockerCertPath();
        if (this$dockerCertPath == null ? other$dockerCertPath != null : !this$dockerCertPath.equals(other$dockerCertPath)) {
            return false;
        }
        if (this.isService() != other.isService()) {
            return false;
        }
        String this$uberJarFileName = this.getUberJarFileName();
        String other$uberJarFileName = other.getUberJarFileName();
        if (this$uberJarFileName == null ? other$uberJarFileName != null : !this$uberJarFileName.equals(other$uberJarFileName)) {
            return false;
        }
        Set<CopyFileModel> this$externalFiles = this.getExternalFiles();
        Set<CopyFileModel> other$externalFiles = other.getExternalFiles();
        if (this$externalFiles == null ? other$externalFiles != null : !((Object)this$externalFiles).equals(other$externalFiles)) {
            return false;
        }
        String this$commandArg = this.getCommandArg();
        String other$commandArg = other.getCommandArg();
        if (this$commandArg == null ? other$commandArg != null : !this$commandArg.equals(other$commandArg)) {
            return false;
        }
        String this$cmd = this.getCmd();
        String other$cmd = other.getCmd();
        if (this$cmd == null ? other$cmd != null : !this$cmd.equals(other$cmd)) {
            return false;
        }
        Map<String, String> this$env = this.getEnv();
        Map<String, String> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        String this$dockerConfig = this.getDockerConfig();
        String other$dockerConfig = other.getDockerConfig();
        return !(this$dockerConfig == null ? other$dockerConfig != null : !this$dockerConfig.equals(other$dockerConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DockerModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $registry = this.getRegistry();
        result = result * 59 + ($registry == null ? 43 : $registry.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        result = result * 59 + (this.isPush() ? 79 : 97);
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        result = result * 59 + (this.isBuildImage() ? 79 : 97);
        String $baseImage = this.getBaseImage();
        result = result * 59 + ($baseImage == null ? 43 : $baseImage.hashCode());
        Set<Integer> $ports = this.getPorts();
        result = result * 59 + ($ports == null ? 43 : ((Object)$ports).hashCode());
        result = result * 59 + (this.isEnableDebug() ? 79 : 97);
        result = result * 59 + this.getDebugPort();
        String $dockerAPIVersion = this.getDockerAPIVersion();
        result = result * 59 + ($dockerAPIVersion == null ? 43 : $dockerAPIVersion.hashCode());
        String $dockerHost = this.getDockerHost();
        result = result * 59 + ($dockerHost == null ? 43 : $dockerHost.hashCode());
        String $dockerCertPath = this.getDockerCertPath();
        result = result * 59 + ($dockerCertPath == null ? 43 : $dockerCertPath.hashCode());
        result = result * 59 + (this.isService() ? 79 : 97);
        String $uberJarFileName = this.getUberJarFileName();
        result = result * 59 + ($uberJarFileName == null ? 43 : $uberJarFileName.hashCode());
        Set<CopyFileModel> $externalFiles = this.getExternalFiles();
        result = result * 59 + ($externalFiles == null ? 43 : ((Object)$externalFiles).hashCode());
        String $commandArg = this.getCommandArg();
        result = result * 59 + ($commandArg == null ? 43 : $commandArg.hashCode());
        String $cmd = this.getCmd();
        result = result * 59 + ($cmd == null ? 43 : $cmd.hashCode());
        Map<String, String> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        String $dockerConfig = this.getDockerConfig();
        result = result * 59 + ($dockerConfig == null ? 43 : $dockerConfig.hashCode());
        return result;
    }
}

