/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwx;

import java.security.Key;
import java.security.cert.X509Certificate;
import org.jose4j.base64url.Base64Url;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.CompactSerializer;
import org.jose4j.jwx.Headers;
import org.jose4j.keys.X509Util;
import org.jose4j.lang.JoseException;

public abstract class JsonWebStructure {
    protected Base64Url base64url = new Base64Url();
    protected Headers headers = new Headers();
    private byte[] integrity;
    private Key key;
    protected boolean doKeyValidation = true;
    private AlgorithmConstraints algorithmConstraints = AlgorithmConstraints.NO_CONSTRAINTS;

    public abstract String getCompactSerialization() throws JoseException;

    protected abstract void setCompactSerializationParts(String[] var1) throws JoseException;

    public abstract String getPayload() throws JoseException;

    public abstract void setPayload(String var1);

    public static JsonWebStructure fromCompactSerialization(String cs) throws JoseException {
        JsonWebStructure jsonWebObject;
        String[] parts = CompactSerializer.deserialize(cs);
        if (parts.length == 5) {
            jsonWebObject = new JsonWebEncryption();
        } else if (parts.length == 3) {
            jsonWebObject = new JsonWebSignature();
        } else {
            throw new JoseException("Invalid JOSE Compact Serialization. Expecting either 3 or 5 parts for JWS or JWE respectively but was " + parts.length + ".");
        }
        ((JsonWebStructure)jsonWebObject).setCompactSerializationParts(parts);
        return jsonWebObject;
    }

    public void setCompactSerialization(String compactSerialization) throws JoseException {
        String[] parts = CompactSerializer.deserialize(compactSerialization);
        this.setCompactSerializationParts(parts);
    }

    public String getHeader() {
        return this.getHeaders().getFullHeaderAsJsonString();
    }

    protected String getEncodedHeader() {
        return this.headers.getEncodedHeader();
    }

    public void setHeader(String name, String value) {
        this.headers.setStringHeaderValue(name, value);
    }

    protected void setEncodedHeader(String encodedHeader) throws JoseException {
        this.checkNotEmptyPart(encodedHeader, "Encoded Header");
        this.headers.setEncodedHeader(encodedHeader);
    }

    public Headers getHeaders() {
        return this.headers;
    }

    protected void checkNotEmptyPart(String encodedPart, String partName) throws JoseException {
        if (encodedPart == null || encodedPart.length() == 0) {
            throw new JoseException("The " + partName + " cannot be empty.");
        }
    }

    public String getHeader(String name) {
        return this.headers.getStringHeaderValue(name);
    }

    public void setAlgorithmHeaderValue(String alg) {
        this.setHeader("alg", alg);
    }

    public String getAlgorithmHeaderValue() {
        return this.getHeader("alg");
    }

    public void setKeyIdHeaderValue(String kid) {
        this.setHeader("kid", kid);
    }

    public String getKeyIdHeaderValue() {
        return this.getHeader("kid");
    }

    public String getX509CertSha1ThumbprintHeaderValue() {
        return this.getHeader("x5t");
    }

    public void setX509CertSha1ThumbprintHeaderValue(String x5t) {
        this.setHeader("x5t", x5t);
    }

    public void setX509CertSha1ThumbprintHeaderValue(X509Certificate certificate) {
        String x5t = X509Util.x5t(certificate);
        this.setX509CertSha1ThumbprintHeaderValue(x5t);
    }

    public String getX509CertSha256ThumbprintHeaderValue() {
        return this.getHeader("x5t#S256");
    }

    public void setX509CertSha256ThumbprintHeaderValue(String x5tS256) {
        this.setHeader("x5t#S256", x5tS256);
    }

    public void setX509CertSha256ThumbprintHeaderValue(X509Certificate certificate) {
        String x5tS256 = X509Util.x5tS256(certificate);
        this.setX509CertSha256ThumbprintHeaderValue(x5tS256);
    }

    public Key getKey() {
        return this.key;
    }

    public void setKey(Key key) {
        boolean same;
        boolean bl = key == null ? this.key == null : (same = key.equals(this.key));
        if (!same) {
            this.onNewKey();
        }
        this.key = key;
    }

    protected void onNewKey() {
    }

    protected byte[] getIntegrity() {
        return this.integrity;
    }

    protected void setIntegrity(byte[] integrity) {
        this.integrity = integrity;
    }

    public boolean isDoKeyValidation() {
        return this.doKeyValidation;
    }

    public void setDoKeyValidation(boolean doKeyValidation) {
        this.doKeyValidation = doKeyValidation;
    }

    protected AlgorithmConstraints getAlgorithmConstraints() {
        return this.algorithmConstraints;
    }

    public void setAlgorithmConstraints(AlgorithmConstraints algorithmConstraints) {
        this.algorithmConstraints = algorithmConstraints;
    }
}

