/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;

public class CMSSignedDataGenerator
extends CMSSignedGenerator {
    private boolean isDefiniteLength = false;

    public CMSSignedDataGenerator() {
    }

    public CMSSignedDataGenerator(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        super(digestAlgorithmIdentifierFinder);
    }

    public void setDefiniteLengthEncoding(boolean bl) {
        this.isDefiniteLength = bl;
    }

    public CMSSignedData generate(CMSTypedData cMSTypedData) throws CMSException {
        return this.generate(cMSTypedData, false);
    }

    public CMSSignedData generate(CMSTypedData cMSTypedData, boolean bl) throws CMSException {
        SignerInfo signerInfo;
        SignerInfoGenerator signerInfoGenerator;
        Object object;
        SignerInformation signerInformation;
        LinkedHashSet<AlgorithmIdentifier> linkedHashSet = new LinkedHashSet<AlgorithmIdentifier>();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        this.digests.clear();
        ASN1ObjectIdentifier aSN1ObjectIdentifier = this._signers.iterator();
        while (aSN1ObjectIdentifier.hasNext()) {
            signerInformation = (SignerInformation)aSN1ObjectIdentifier.next();
            CMSUtils.addDigestAlgs(linkedHashSet, signerInformation, this.digestAlgIdFinder);
            aSN1EncodableVector.add((ASN1Encodable)signerInformation.toASN1Structure());
        }
        aSN1ObjectIdentifier = cMSTypedData.getContentType();
        signerInformation = null;
        if (cMSTypedData.getContent() != null) {
            if (bl) {
                object = new ByteArrayOutputStream();
                this.writeContentViaSignerGens(cMSTypedData, (OutputStream)object);
                signerInformation = this.isDefiniteLength ? new DEROctetString(((ByteArrayOutputStream)object).toByteArray()) : new BEROctetString(((ByteArrayOutputStream)object).toByteArray());
            } else {
                this.writeContentViaSignerGens(cMSTypedData, null);
            }
        }
        object = this.signerGens.iterator();
        while (object.hasNext()) {
            signerInfoGenerator = (SignerInfoGenerator)object.next();
            signerInfo = this.generateSignerInfo(signerInfoGenerator, aSN1ObjectIdentifier);
            linkedHashSet.add(signerInfo.getDigestAlgorithm());
            aSN1EncodableVector.add((ASN1Encodable)signerInfo);
        }
        object = CMSSignedDataGenerator.createSetFromList(this.certs, this.isDefiniteLength);
        signerInfoGenerator = CMSSignedDataGenerator.createSetFromList(this.crls, this.isDefiniteLength);
        signerInfo = new ContentInfo(aSN1ObjectIdentifier, (ASN1Encodable)signerInformation);
        SignedData signedData = new SignedData(CMSUtils.convertToDlSet(linkedHashSet), (ContentInfo)signerInfo, (ASN1Set)object, (ASN1Set)signerInfoGenerator, (ASN1Set)new DERSet(aSN1EncodableVector));
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, (ASN1Encodable)signedData);
        return new CMSSignedData((CMSProcessable)cMSTypedData, contentInfo);
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signerInformation) throws CMSException {
        SignerInfo signerInfo;
        Object object;
        this.digests.clear();
        CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray(null, signerInformation.getSignature());
        ArrayList<SignerInformation> arrayList = new ArrayList<SignerInformation>();
        Iterator iterator = this._signers.iterator();
        while (iterator.hasNext()) {
            object = (SignerInformation)iterator.next();
            signerInfo = ((SignerInformation)object).toASN1Structure();
            arrayList.add(new SignerInformation(signerInfo, null, cMSProcessableByteArray, null));
        }
        this.writeContentViaSignerGens(cMSProcessableByteArray, null);
        iterator = this.signerGens.iterator();
        while (iterator.hasNext()) {
            object = (SignerInfoGenerator)iterator.next();
            signerInfo = this.generateSignerInfo((SignerInfoGenerator)object, null);
            arrayList.add(new SignerInformation(signerInfo, null, cMSProcessableByteArray, null));
        }
        return new SignerInformationStore(arrayList);
    }

    private SignerInfo generateSignerInfo(SignerInfoGenerator signerInfoGenerator, ASN1ObjectIdentifier aSN1ObjectIdentifier) throws CMSException {
        SignerInfo signerInfo = signerInfoGenerator.generate(aSN1ObjectIdentifier);
        byte[] byArray = signerInfoGenerator.getCalculatedDigest();
        if (byArray != null) {
            this.digests.put(signerInfo.getDigestAlgorithm().getAlgorithm().getId(), byArray);
        }
        return signerInfo;
    }

    private void writeContentViaSignerGens(CMSTypedData cMSTypedData, OutputStream outputStream) throws CMSException {
        OutputStream outputStream2 = CMSUtils.attachSignersToOutputStream(this.signerGens, outputStream);
        outputStream2 = CMSUtils.getSafeOutputStream(outputStream2);
        try {
            cMSTypedData.write(outputStream2);
            outputStream2.close();
        }
        catch (IOException iOException) {
            throw new CMSException("data processing exception: " + iOException.getMessage(), iOException);
        }
    }

    private static ASN1Set createSetFromList(List list, boolean bl) {
        return list.size() < 1 ? null : (bl ? CMSUtils.createDlSetFromList(list) : CMSUtils.createBerSetFromList(list));
    }
}

