/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.jcajce;

import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.InputStreamWithMAC;
import org.bouncycastle.jcajce.io.CipherInputStream;
import org.bouncycastle.operator.InputAEADDecryptor;

class CMSInputAEADDecryptor
implements InputAEADDecryptor {
    private final AlgorithmIdentifier contentEncryptionAlgorithm;
    private final Cipher dataCipher;
    private InputStream inputStream;

    CMSInputAEADDecryptor(AlgorithmIdentifier algorithmIdentifier, Cipher cipher) {
        this.contentEncryptionAlgorithm = algorithmIdentifier;
        this.dataCipher = cipher;
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.contentEncryptionAlgorithm;
    }

    public InputStream getInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return new CipherInputStream(inputStream, this.dataCipher);
    }

    public OutputStream getAADStream() {
        return null;
    }

    public byte[] getMAC() {
        if (this.inputStream instanceof InputStreamWithMAC) {
            return ((InputStreamWithMAC)this.inputStream).getMAC();
        }
        return null;
    }
}

