/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.ec;

import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;

public class AlgorithmParametersSpi
extends java.security.AlgorithmParametersSpi {
    private ECParameterSpec ecParameterSpec;
    private String curveName;

    protected boolean isASN1FormatString(String format) {
        return format == null || format.equals("ASN.1");
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof ECNamedCurveGenParameterSpec) {
            ECNamedCurveGenParameterSpec ecGenParameterSpec = (ECNamedCurveGenParameterSpec)algorithmParameterSpec;
            X9ECParameters params = ECNamedCurveTable.getByName(ecGenParameterSpec.getName());
            this.curveName = ecGenParameterSpec.getName();
            this.ecParameterSpec = new ECParameterSpec(params.getCurve(), params.getG(), params.getN(), params.getH(), params.getSeed());
        } else if (algorithmParameterSpec instanceof ECParameterSpec) {
            this.curveName = null;
            this.ecParameterSpec = (ECParameterSpec)algorithmParameterSpec;
        } else {
            throw new InvalidParameterSpecException("AlgorithmParameterSpec class not recognized: " + algorithmParameterSpec.getClass().getName());
        }
    }

    protected void engineInit(byte[] bytes) throws IOException {
        this.engineInit(bytes, "ASN.1");
    }

    protected void engineInit(byte[] bytes, String format) throws IOException {
        X962Parameters params;
        if (this.isASN1FormatString(format)) {
            params = X962Parameters.getInstance(bytes);
            if (params.isNamedCurve()) {
                this.curveName = ECNamedCurveTable.getName(ASN1ObjectIdentifier.getInstance(params.getParameters()));
                X9ECParameters curveParams = ECNamedCurveTable.getByName(this.curveName);
                this.ecParameterSpec = new ECNamedCurveParameterSpec(this.curveName, curveParams.getCurve(), curveParams.getG(), curveParams.getN(), curveParams.getH(), curveParams.getSeed());
                return;
            }
        } else {
            throw new IOException("Unknown encoded parameters format in AlgorithmParameters object: " + format);
        }
        X9ECParameters curveParams = X9ECParameters.getInstance(params.getParameters());
        this.ecParameterSpec = new ECParameterSpec(curveParams.getCurve(), curveParams.getG(), curveParams.getN(), curveParams.getH(), curveParams.getSeed());
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (ECParameterSpec.class.isAssignableFrom(paramSpec) || paramSpec == AlgorithmParameterSpec.class) {
            return this.ecParameterSpec;
        }
        if (ECNamedCurveGenParameterSpec.class.isAssignableFrom(paramSpec) && this.curveName != null) {
            return new ECNamedCurveGenParameterSpec(this.curveName);
        }
        throw new InvalidParameterSpecException("EC AlgorithmParameters cannot convert to " + paramSpec.getName());
    }

    protected byte[] engineGetEncoded() throws IOException {
        return this.engineGetEncoded("ASN.1");
    }

    protected byte[] engineGetEncoded(String format) throws IOException {
        if (this.isASN1FormatString(format)) {
            X962Parameters params;
            if (this.ecParameterSpec == null) {
                params = new X962Parameters(DERNull.INSTANCE);
            } else if (this.curveName != null) {
                params = new X962Parameters(ECNamedCurveTable.getOID(this.curveName));
            } else {
                X9ECParameters ecP = new X9ECParameters(this.ecParameterSpec.getCurve(), this.ecParameterSpec.getG(), this.ecParameterSpec.getN(), this.ecParameterSpec.getH(), this.ecParameterSpec.getSeed());
                params = new X962Parameters(ecP);
            }
            return params.getEncoded();
        }
        throw new IOException("Unknown parameters format in AlgorithmParameters object: " + format);
    }

    protected String engineToString() {
        return "EC AlgorithmParameters ";
    }
}

