/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.falcon;

import org.bouncycastle.pqc.crypto.falcon.FalconConversions;
import org.bouncycastle.pqc.crypto.falcon.SHAKE256;

class FalconRNG {
    byte[] bd = new byte[512];
    long bdummy_u64 = 0L;
    int ptr = 0;
    byte[] sd = new byte[256];
    long sdummy_u64 = 0L;
    int type = 0;
    FalconConversions convertor = new FalconConversions();

    FalconRNG() {
    }

    void prng_init(SHAKE256 src) {
        byte[] tmp = new byte[56];
        src.inner_shake256_extract(tmp, 0, 56);
        for (int i = 0; i < 14; ++i) {
            int w = tmp[(i << 2) + 0] & 0xFF | (tmp[(i << 2) + 1] & 0xFF) << 8 | (tmp[(i << 2) + 2] & 0xFF) << 16 | (tmp[(i << 2) + 3] & 0xFF) << 24;
            System.arraycopy(this.convertor.int_to_bytes(w), 0, this.sd, i << 2, 4);
        }
        long tl = (long)this.convertor.bytes_to_int(this.sd, 48) & 0xFFFFFFFFL;
        long th = (long)this.convertor.bytes_to_int(this.sd, 52) & 0xFFFFFFFFL;
        System.arraycopy(this.convertor.long_to_bytes(tl + (th << 32)), 0, this.sd, 48, 8);
        this.prng_refill();
    }

    void prng_refill() {
        int[] CW = new int[]{1634760805, 857760878, 2036477234, 1797285236};
        long cc = this.convertor.bytes_to_long(this.sd, 48);
        for (int u = 0; u < 8; ++u) {
            int v;
            int[] state = new int[16];
            System.arraycopy(CW, 0, state, 0, CW.length);
            System.arraycopy(this.convertor.bytes_to_int_array(this.sd, 0, 12), 0, state, 4, 12);
            state[14] = state[14] ^ (int)cc;
            state[15] = state[15] ^ (int)(cc >>> 32);
            for (int i = 0; i < 10; ++i) {
                this.QROUND(0, 4, 8, 12, state);
                this.QROUND(1, 5, 9, 13, state);
                this.QROUND(2, 6, 10, 14, state);
                this.QROUND(3, 7, 11, 15, state);
                this.QROUND(0, 5, 10, 15, state);
                this.QROUND(1, 6, 11, 12, state);
                this.QROUND(2, 7, 8, 13, state);
                this.QROUND(3, 4, 9, 14, state);
            }
            for (v = 0; v < 4; ++v) {
                int n = v;
                state[n] = state[n] + CW[v];
            }
            for (v = 4; v < 14; ++v) {
                int n = v;
                state[n] = state[n] + this.convertor.bytes_to_int(this.sd, 4 * v - 16);
            }
            state[14] = state[14] + (this.convertor.bytes_to_int(this.sd, 40) ^ (int)cc);
            state[15] = state[15] + (this.convertor.bytes_to_int(this.sd, 44) ^ (int)(cc >>> 32));
            ++cc;
            for (v = 0; v < 16; ++v) {
                this.bd[(u << 2) + (v << 5) + 0] = (byte)state[v];
                this.bd[(u << 2) + (v << 5) + 1] = (byte)(state[v] >>> 8);
                this.bd[(u << 2) + (v << 5) + 2] = (byte)(state[v] >>> 16);
                this.bd[(u << 2) + (v << 5) + 3] = (byte)(state[v] >>> 24);
            }
        }
        System.arraycopy(this.convertor.long_to_bytes(cc), 0, this.sd, 48, 8);
        this.ptr = 0;
    }

    void prng_get_bytes(byte[] srcdst, int dst, int len) {
        int buf = dst;
        while (len > 0) {
            int clen = this.bd.length - this.ptr;
            if (clen > len) {
                clen = len;
            }
            System.arraycopy(this.bd, 0, srcdst, buf, clen);
            buf += clen;
            len -= clen;
            this.ptr += clen;
            if (this.ptr != this.bd.length) continue;
            this.prng_refill();
        }
    }

    private void QROUND(int a, int b, int c, int d, int[] state) {
        int n = a;
        state[n] = state[n] + state[b];
        int n2 = d;
        state[n2] = state[n2] ^ state[a];
        state[d] = state[d] << 16 | state[d] >>> 16;
        int n3 = c;
        state[n3] = state[n3] + state[d];
        int n4 = b;
        state[n4] = state[n4] ^ state[c];
        state[b] = state[b] << 12 | state[b] >>> 20;
        int n5 = a;
        state[n5] = state[n5] + state[b];
        int n6 = d;
        state[n6] = state[n6] ^ state[a];
        state[d] = state[d] << 8 | state[d] >>> 24;
        int n7 = c;
        state[n7] = state[n7] + state[d];
        int n8 = b;
        state[n8] = state[n8] ^ state[c];
        state[b] = state[b] << 7 | state[b] >>> 25;
    }

    long prng_get_u64() {
        int u = this.ptr;
        if (u >= this.bd.length - 9) {
            this.prng_refill();
            u = 0;
        }
        this.ptr = u + 8;
        return (long)this.bd[u + 0] & 0xFFL | ((long)this.bd[u + 1] & 0xFFL) << 8 | ((long)this.bd[u + 2] & 0xFFL) << 16 | ((long)this.bd[u + 3] & 0xFFL) << 24 | ((long)this.bd[u + 4] & 0xFFL) << 32 | ((long)this.bd[u + 5] & 0xFFL) << 40 | ((long)this.bd[u + 6] & 0xFFL) << 48 | ((long)this.bd[u + 7] & 0xFFL) << 56;
    }

    byte prng_get_u8() {
        byte v = this.bd[this.ptr++];
        if (this.ptr == this.bd.length) {
            this.prng_refill();
        }
        return v;
    }
}

