/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.OutputLengthException;

public class AsconDigest
implements Digest {
    AsconParameters asconParameters;
    private final String algorithmName;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private long x0;
    private long x1;
    private long x2;
    private long x3;
    private long x4;
    private final int CRYPTO_BYTES = 32;
    private final int ASCON_PB_ROUNDS;

    public AsconDigest(AsconParameters parameters) {
        this.asconParameters = parameters;
        switch (parameters.ord) {
            case 0: {
                this.ASCON_PB_ROUNDS = 12;
                this.algorithmName = "Ascon-Hash";
                break;
            }
            case 1: {
                this.ASCON_PB_ROUNDS = 8;
                this.algorithmName = "Ascon-HashA";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid parameter settings for Ascon Hash");
            }
        }
        this.reset();
    }

    private long ROR(long x, int n) {
        return x >>> n | x << 64 - n;
    }

    private void ROUND(long C) {
        long t0 = this.x0 ^ this.x1 ^ this.x2 ^ this.x3 ^ C ^ this.x1 & (this.x0 ^ this.x2 ^ this.x4 ^ C);
        long t1 = this.x0 ^ this.x2 ^ this.x3 ^ this.x4 ^ C ^ (this.x1 ^ this.x2 ^ C) & (this.x1 ^ this.x3);
        long t2 = this.x1 ^ this.x2 ^ this.x4 ^ C ^ this.x3 & this.x4;
        long t3 = this.x0 ^ this.x1 ^ this.x2 ^ C ^ (this.x0 ^ 0xFFFFFFFFFFFFFFFFL) & (this.x3 ^ this.x4);
        long t4 = this.x1 ^ this.x3 ^ this.x4 ^ (this.x0 ^ this.x4) & this.x1;
        this.x0 = t0 ^ this.ROR(t0, 19) ^ this.ROR(t0, 28);
        this.x1 = t1 ^ this.ROR(t1, 39) ^ this.ROR(t1, 61);
        this.x2 = t2 ^ this.ROR(t2, 1) ^ this.ROR(t2, 6) ^ 0xFFFFFFFFFFFFFFFFL;
        this.x3 = t3 ^ this.ROR(t3, 10) ^ this.ROR(t3, 17);
        this.x4 = t4 ^ this.ROR(t4, 7) ^ this.ROR(t4, 41);
    }

    private void P(int nr) {
        if (nr == 12) {
            this.ROUND(240L);
            this.ROUND(225L);
            this.ROUND(210L);
            this.ROUND(195L);
        }
        if (nr >= 8) {
            this.ROUND(180L);
            this.ROUND(165L);
        }
        this.ROUND(150L);
        this.ROUND(135L);
        this.ROUND(120L);
        this.ROUND(105L);
        this.ROUND(90L);
        this.ROUND(75L);
    }

    private long PAD(int i) {
        return 128L << 56 - (i << 3);
    }

    private long LOADBYTES(byte[] bytes, int inOff, int n) {
        long x = 0L;
        for (int i = 0; i < n; ++i) {
            x |= ((long)bytes[i + inOff] & 0xFFL) << (7 - i << 3);
        }
        return x;
    }

    private void STOREBYTES(byte[] bytes, int inOff, long w, int n) {
        for (int i = 0; i < n; ++i) {
            bytes[i + inOff] = (byte)(w >>> (7 - i << 3));
        }
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public int getDigestSize() {
        return 32;
    }

    public void update(byte in) {
        this.buffer.write(in);
    }

    public void update(byte[] input, int inOff, int len) {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.buffer.write(input, inOff, len);
    }

    public int doFinal(byte[] output, int outOff) {
        int len;
        if (32 + outOff > output.length) {
            throw new OutputLengthException("output buffer is too short");
        }
        byte[] input = this.buffer.toByteArray();
        int inOff = 0;
        int ASCON_HASH_RATE = 8;
        for (len = this.buffer.size(); len >= ASCON_HASH_RATE; len -= ASCON_HASH_RATE) {
            this.x0 ^= this.LOADBYTES(input, inOff, 8);
            this.P(this.ASCON_PB_ROUNDS);
            inOff += ASCON_HASH_RATE;
        }
        this.x0 ^= this.LOADBYTES(input, inOff, len);
        this.x0 ^= this.PAD(len);
        int ASCON_PA_ROUNDS = 12;
        this.P(ASCON_PA_ROUNDS);
        for (len = 32; len > ASCON_HASH_RATE; len -= ASCON_HASH_RATE) {
            this.STOREBYTES(output, outOff, this.x0, 8);
            this.P(this.ASCON_PB_ROUNDS);
            outOff += ASCON_HASH_RATE;
        }
        this.STOREBYTES(output, outOff, this.x0, len);
        this.reset();
        return 32;
    }

    public void reset() {
        this.buffer.reset();
        switch (this.asconParameters.ord) {
            case 1: {
                this.x0 = 92044056785660070L;
                this.x1 = 8326807761760157607L;
                this.x2 = 3371194088139667532L;
                this.x3 = -2956994353054992515L;
                this.x4 = -6828509670848688761L;
                break;
            }
            case 0: {
                this.x0 = -1255492011513352131L;
                this.x1 = -8380609354527731710L;
                this.x2 = -5437372128236807582L;
                this.x3 = 4834782570098516968L;
                this.x4 = 3787428097924915520L;
            }
        }
    }

    public static class AsconParameters {
        public static final AsconParameters AsconHash = new AsconParameters(0);
        public static final AsconParameters AsconHashA = new AsconParameters(1);
        private final int ord;

        AsconParameters(int ord) {
            this.ord = ord;
        }
    }
}

