/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.picnic;

import java.io.ByteArrayOutputStream;
import java.util.Properties;
import org.bouncycastle.pqc.crypto.picnic.KMatrices;
import org.bouncycastle.pqc.crypto.picnic.KMatricesWithPointer;
import org.bouncycastle.pqc.crypto.picnic.PicnicEngine;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.encoders.Hex;

abstract class LowmcConstants {
    protected int[] linearMatrices;
    protected int[] roundConstants;
    protected int[] keyMatrices;
    protected KMatrices LMatrix;
    protected KMatrices KMatrix;
    protected KMatrices RConstants;
    protected int[] linearMatrices_full;
    protected int[] keyMatrices_full;
    protected int[] keyMatrices_inv;
    protected int[] linearMatrices_inv;
    protected int[] roundConstants_full;
    protected KMatrices LMatrix_full;
    protected KMatrices LMatrix_inv;
    protected KMatrices KMatrix_full;
    protected KMatrices KMatrix_inv;
    protected KMatrices RConstants_full;

    LowmcConstants() {
    }

    static int[] ReadFromProperty(Properties props, String key, int intSize) {
        String s = props.getProperty(key);
        byte[] bytes = Hex.decode(LowmcConstants.removeCommas(s));
        int[] ints = new int[intSize];
        for (int i = 0; i < bytes.length / 4; ++i) {
            ints[i] = Pack.littleEndianToInt(bytes, i * 4);
        }
        return ints;
    }

    private static byte[] removeCommas(String s) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        for (int i = 0; i != s.length(); ++i) {
            if (s.charAt(i) == ',') continue;
            bOut.write(s.charAt(i));
        }
        return bOut.toByteArray();
    }

    private KMatricesWithPointer GET_MAT(KMatrices m, int r) {
        KMatricesWithPointer mwp = new KMatricesWithPointer(m);
        mwp.setMatrixPointer(r * mwp.getSize());
        return mwp;
    }

    protected KMatricesWithPointer LMatrix(PicnicEngine engine, int round) {
        if (engine.stateSizeBits == 128) {
            return this.GET_MAT(this.LMatrix, round);
        }
        if (engine.stateSizeBits == 129) {
            return this.GET_MAT(this.LMatrix_full, round);
        }
        if (engine.stateSizeBits == 192) {
            if (engine.numRounds == 4) {
                return this.GET_MAT(this.LMatrix_full, round);
            }
            return this.GET_MAT(this.LMatrix, round);
        }
        if (engine.stateSizeBits == 255) {
            return this.GET_MAT(this.LMatrix_full, round);
        }
        if (engine.stateSizeBits == 256) {
            return this.GET_MAT(this.LMatrix, round);
        }
        return null;
    }

    protected KMatricesWithPointer LMatrixInv(PicnicEngine engine, int round) {
        if (engine.stateSizeBits == 129) {
            return this.GET_MAT(this.LMatrix_inv, round);
        }
        if (engine.stateSizeBits == 192 && engine.numRounds == 4) {
            return this.GET_MAT(this.LMatrix_inv, round);
        }
        if (engine.stateSizeBits == 255) {
            return this.GET_MAT(this.LMatrix_inv, round);
        }
        return null;
    }

    protected KMatricesWithPointer KMatrix(PicnicEngine engine, int round) {
        if (engine.stateSizeBits == 128) {
            return this.GET_MAT(this.KMatrix, round);
        }
        if (engine.stateSizeBits == 129) {
            return this.GET_MAT(this.KMatrix_full, round);
        }
        if (engine.stateSizeBits == 192) {
            if (engine.numRounds == 4) {
                return this.GET_MAT(this.KMatrix_full, round);
            }
            return this.GET_MAT(this.KMatrix, round);
        }
        if (engine.stateSizeBits == 255) {
            return this.GET_MAT(this.KMatrix_full, round);
        }
        if (engine.stateSizeBits == 256) {
            return this.GET_MAT(this.KMatrix, round);
        }
        return null;
    }

    protected KMatricesWithPointer KMatrixInv(PicnicEngine engine) {
        int round = 0;
        if (engine.stateSizeBits == 129) {
            return this.GET_MAT(this.KMatrix_inv, round);
        }
        if (engine.stateSizeBits == 192 && engine.numRounds == 4) {
            return this.GET_MAT(this.KMatrix_inv, round);
        }
        if (engine.stateSizeBits == 255) {
            return this.GET_MAT(this.KMatrix_inv, round);
        }
        return null;
    }

    protected KMatricesWithPointer RConstant(PicnicEngine engine, int round) {
        if (engine.stateSizeBits == 128) {
            return this.GET_MAT(this.RConstants, round);
        }
        if (engine.stateSizeBits == 129) {
            return this.GET_MAT(this.RConstants_full, round);
        }
        if (engine.stateSizeBits == 192) {
            if (engine.numRounds == 4) {
                return this.GET_MAT(this.RConstants_full, round);
            }
            return this.GET_MAT(this.RConstants, round);
        }
        if (engine.stateSizeBits == 255) {
            return this.GET_MAT(this.RConstants_full, round);
        }
        if (engine.stateSizeBits == 256) {
            return this.GET_MAT(this.RConstants, round);
        }
        return null;
    }
}

