/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.rfc8032;

abstract class Codec {
    Codec() {
    }

    static int decode16(byte[] bs, int off) {
        int n = bs[off] & 0xFF;
        return n |= (bs[++off] & 0xFF) << 8;
    }

    static int decode24(byte[] bs, int off) {
        int n = bs[off] & 0xFF;
        n |= (bs[++off] & 0xFF) << 8;
        return n |= (bs[++off] & 0xFF) << 16;
    }

    static int decode32(byte[] bs, int off) {
        int n = bs[off] & 0xFF;
        n |= (bs[++off] & 0xFF) << 8;
        n |= (bs[++off] & 0xFF) << 16;
        return n |= bs[++off] << 24;
    }

    static void decode32(byte[] bs, int bsOff, int[] n, int nOff, int nLen) {
        for (int i = 0; i < nLen; ++i) {
            n[nOff + i] = Codec.decode32(bs, bsOff + i * 4);
        }
    }

    static void encode24(int n, byte[] bs, int off) {
        bs[off] = (byte)n;
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)(n >>> 16);
    }

    static void encode32(int n, byte[] bs, int off) {
        bs[off] = (byte)n;
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)(n >>> 16);
        bs[++off] = (byte)(n >>> 24);
    }

    static void encode32(int[] n, int nOff, int nLen, byte[] bs, int bsOff) {
        for (int i = 0; i < nLen; ++i) {
            Codec.encode32(n[nOff + i], bs, bsOff + i * 4);
        }
    }

    static void encode56(long n, byte[] bs, int off) {
        Codec.encode32((int)n, bs, off);
        Codec.encode24((int)(n >>> 32), bs, off + 4);
    }
}

