/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.sike;

import java.security.SecureRandom;
import org.bouncycastle.pqc.crypto.sike.Fpx;
import org.bouncycastle.pqc.crypto.sike.PointProj;
import org.bouncycastle.pqc.crypto.sike.PointProjFull;
import org.bouncycastle.pqc.crypto.sike.SIKEEngine;
import org.bouncycastle.util.Arrays;

class SIDH_Compressed {
    private SIKEEngine engine;
    private static final int t_points = 2;

    public SIDH_Compressed(SIKEEngine sIKEEngine) {
        this.engine = sIKEEngine;
    }

    protected void init_basis(long[] lArray, long[][] lArray2, long[][] lArray3, long[][] lArray4) {
        this.engine.fpx.fpcopy(lArray, 0, lArray2[0]);
        this.engine.fpx.fpcopy(lArray, this.engine.params.NWORDS_FIELD, lArray2[1]);
        this.engine.fpx.fpcopy(lArray, 2 * this.engine.params.NWORDS_FIELD, lArray3[0]);
        this.engine.fpx.fpcopy(lArray, 3 * this.engine.params.NWORDS_FIELD, lArray3[1]);
        this.engine.fpx.fpcopy(lArray, 4 * this.engine.params.NWORDS_FIELD, lArray4[0]);
        this.engine.fpx.fpcopy(lArray, 5 * this.engine.params.NWORDS_FIELD, lArray4[1]);
    }

    protected void FormatPrivKey_B(byte[] byArray) {
        int n = this.engine.params.SECRETKEY_B_BYTES - 2;
        byArray[n] = (byte)(byArray[n] & this.engine.params.MASK3_BOB);
        int n2 = this.engine.params.SECRETKEY_B_BYTES - 1;
        byArray[n2] = (byte)(byArray[n2] & this.engine.params.MASK2_BOB);
        this.engine.fpx.mul3(byArray);
    }

    protected void random_mod_order_A(byte[] byArray, SecureRandom secureRandom) {
        byte[] byArray2 = new byte[this.engine.params.SECRETKEY_A_BYTES];
        secureRandom.nextBytes(byArray2);
        System.arraycopy(byArray2, 0, byArray, 0, this.engine.params.SECRETKEY_A_BYTES);
        byArray[0] = (byte)(byArray[0] & 0xFE);
        int n = this.engine.params.SECRETKEY_A_BYTES - 1;
        byArray[n] = (byte)(byArray[n] & this.engine.params.MASK_ALICE);
    }

    protected void random_mod_order_B(byte[] byArray, SecureRandom secureRandom) {
        byte[] byArray2 = new byte[this.engine.params.SECRETKEY_B_BYTES];
        secureRandom.nextBytes(byArray2);
        System.arraycopy(byArray2, 0, byArray, 0, this.engine.params.SECRETKEY_A_BYTES);
        this.FormatPrivKey_B(byArray);
    }

    protected void Ladder3pt_dual(PointProj[] pointProjArray, long[] lArray, int n, PointProj pointProj, long[][] lArray2) {
        long l;
        int n2;
        PointProj pointProj2 = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj pointProj3 = new PointProj(this.engine.params.NWORDS_FIELD);
        int n3 = 0;
        int n4 = n == this.engine.params.ALICE ? this.engine.params.OALICE_BITS : this.engine.params.OBOB_BITS;
        this.engine.fpx.fp2copy(pointProjArray[1].X, pointProj2.X);
        this.engine.fpx.fp2copy(pointProjArray[1].Z, pointProj2.Z);
        this.engine.fpx.fp2copy(pointProjArray[2].X, pointProj3.X);
        this.engine.fpx.fp2copy(pointProjArray[2].Z, pointProj3.Z);
        this.engine.fpx.fp2copy(pointProjArray[0].X, pointProj.X);
        this.engine.fpx.fp2copy(pointProjArray[0].Z, pointProj.Z);
        for (int i = 0; i < n4; ++i) {
            int n5 = (int)(lArray[i >>> 6] >>> (i & 0x3F) & 1L);
            n2 = n5 ^ n3;
            n3 = n5;
            l = 0L - (long)n2;
            this.engine.isogeny.swap_points(pointProj, pointProj3, l);
            this.engine.isogeny.xDBLADD(pointProj2, pointProj3, pointProj.X, lArray2);
            this.engine.fpx.fp2mul_mont(pointProj3.X, pointProj.Z, pointProj3.X);
        }
        n2 = 0 ^ n3;
        l = 0L - (long)n2;
        this.engine.isogeny.swap_points(pointProj, pointProj3, l);
    }

    protected void Elligator2(long[][] lArray, int[] nArray, int n, long[][] lArray2, byte[] byArray, int n2, int n3) {
        long[] lArray3 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray4 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray5 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray6 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray7 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray8 = new long[this.engine.params.NWORDS_FIELD];
        long[][] lArray9 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray10 = new long[2][this.engine.params.NWORDS_FIELD];
        int n4 = 0;
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, lArray3);
        this.engine.fpx.fp2add(lArray, lArray, lArray9);
        this.engine.fpx.fpsubPRIME(lArray9[0], lArray3, lArray9[0]);
        this.engine.fpx.fp2add(lArray9, lArray9, lArray9);
        n4 = nArray[n];
        this.engine.fpx.fp2mul_mont(lArray9, this.engine.params.v_3_torsion[n4], lArray2);
        this.engine.fpx.fp2neg(lArray2);
        if (n3 == 0) {
            int n5;
            this.engine.fpx.fp2add(lArray9, lArray2, lArray10);
            this.engine.fpx.fp2mul_mont(lArray10, lArray2, lArray10);
            this.engine.fpx.fpaddPRIME(lArray10[0], lArray3, lArray10[0]);
            this.engine.fpx.fp2mul_mont(lArray2, lArray10, lArray10);
            this.engine.fpx.fpsqr_mont(lArray10[0], lArray4);
            this.engine.fpx.fpsqr_mont(lArray10[1], lArray5);
            this.engine.fpx.fpaddPRIME(lArray4, lArray5, lArray6);
            this.engine.fpx.fpcopy(lArray6, 0, lArray7);
            for (n5 = 0; n5 < this.engine.params.OALICE_BITS - 2; ++n5) {
                this.engine.fpx.fpsqr_mont(lArray7, lArray7);
            }
            for (n5 = 0; n5 < this.engine.params.OBOB_EXPON; ++n5) {
                this.engine.fpx.fpsqr_mont(lArray7, lArray8);
                this.engine.fpx.fpmul_mont(lArray7, lArray8, lArray7);
            }
            this.engine.fpx.fpsqr_mont(lArray7, lArray8);
            this.engine.fpx.fpcorrectionPRIME(lArray8);
            this.engine.fpx.fpcorrectionPRIME(lArray6);
            if (!Fpx.subarrayEquals(lArray8, lArray6, this.engine.params.NWORDS_FIELD)) {
                this.engine.fpx.fp2neg(lArray2);
                this.engine.fpx.fp2sub(lArray2, lArray9, lArray2);
                if (n3 == 0) {
                    byArray[n2] = 1;
                }
            }
        } else if (byArray[n2] == 1) {
            this.engine.fpx.fp2neg(lArray2);
            this.engine.fpx.fp2sub(lArray2, lArray9, lArray2);
        }
    }

    protected void make_positive(long[][] lArray) {
        int n = this.engine.params.NWORDS_FIELD;
        long[] lArray2 = new long[this.engine.params.NWORDS_FIELD];
        this.engine.fpx.from_fp2mont(lArray, lArray);
        if (!Fpx.subarrayEquals(lArray[0], lArray2, n)) {
            if ((lArray[0][0] & 1L) == 1L) {
                this.engine.fpx.fp2neg(lArray);
            }
        } else if ((lArray[1][0] & 1L) == 1L) {
            this.engine.fpx.fp2neg(lArray);
        }
        this.engine.fpx.to_fp2mont(lArray, lArray);
    }

    protected void BiQuad_affine(long[][] lArray, long[][] lArray2, long[][] lArray3, PointProj pointProj) {
        long[][] lArray4 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray5 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray6 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray7 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray8 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray9 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fp2add(lArray, lArray, lArray4);
        this.engine.fpx.fp2add(lArray4, lArray4, lArray4);
        this.engine.fpx.fp2sub(lArray2, lArray3, lArray5);
        this.engine.fpx.fp2sqr_mont(lArray5, lArray5);
        this.engine.fpx.fp2mul_mont(lArray2, lArray3, lArray7);
        this.engine.fpx.fpsubPRIME(lArray7[0], this.engine.params.Montgomery_one, lArray7[0]);
        this.engine.fpx.fp2sqr_mont(lArray7, lArray7);
        this.engine.fpx.fpsubPRIME(lArray2[0], this.engine.params.Montgomery_one, lArray6[0]);
        this.engine.fpx.fpcopy(lArray2[1], 0, lArray6[1]);
        this.engine.fpx.fp2sqr_mont(lArray6, lArray6);
        this.engine.fpx.fp2mul_mont(lArray4, lArray2, lArray8);
        this.engine.fpx.fp2add(lArray6, lArray8, lArray6);
        this.engine.fpx.fp2mul_mont(lArray3, lArray6, lArray6);
        this.engine.fpx.fpsubPRIME(lArray3[0], this.engine.params.Montgomery_one, lArray8[0]);
        this.engine.fpx.fpcopy(lArray3[1], 0, lArray8[1]);
        this.engine.fpx.fp2sqr_mont(lArray8, lArray8);
        this.engine.fpx.fp2mul_mont(lArray4, lArray3, lArray9);
        this.engine.fpx.fp2add(lArray8, lArray9, lArray8);
        this.engine.fpx.fp2mul_mont(lArray2, lArray8, lArray8);
        this.engine.fpx.fp2add(lArray6, lArray8, lArray6);
        this.engine.fpx.fp2add(lArray6, lArray6, lArray6);
        this.engine.fpx.fp2sqr_mont(lArray6, lArray8);
        this.engine.fpx.fp2mul_mont(lArray5, lArray7, lArray9);
        this.engine.fpx.fp2add(lArray9, lArray9, lArray9);
        this.engine.fpx.fp2add(lArray9, lArray9, lArray9);
        this.engine.fpx.fp2sub(lArray8, lArray9, lArray8);
        this.engine.fpx.sqrt_Fp2(lArray8, lArray8);
        this.make_positive(lArray8);
        this.engine.fpx.fp2add(lArray6, lArray8, pointProj.X);
        this.engine.fpx.fp2add(lArray5, lArray5, pointProj.Z);
    }

    protected void get_4_isog_dual(PointProj pointProj, long[][] lArray, long[][] lArray2, long[][][] lArray3) {
        this.engine.fpx.fp2sub(pointProj.X, pointProj.Z, lArray3[1]);
        this.engine.fpx.fp2add(pointProj.X, pointProj.Z, lArray3[2]);
        this.engine.fpx.fp2sqr_mont(pointProj.Z, lArray3[4]);
        this.engine.fpx.fp2add(lArray3[4], lArray3[4], lArray3[0]);
        this.engine.fpx.fp2sqr_mont(lArray3[0], lArray2);
        this.engine.fpx.fp2add(lArray3[0], lArray3[0], lArray3[0]);
        this.engine.fpx.fp2sqr_mont(pointProj.X, lArray3[3]);
        this.engine.fpx.fp2add(lArray3[3], lArray3[3], lArray);
        this.engine.fpx.fp2sqr_mont(lArray, lArray);
    }

    protected void eval_dual_2_isog(long[][] lArray, long[][] lArray2, PointProj pointProj) {
        long[][] lArray3 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fp2add(pointProj.X, pointProj.Z, lArray3);
        this.engine.fpx.fp2sub(pointProj.X, pointProj.Z, pointProj.Z);
        this.engine.fpx.fp2sqr_mont(lArray3, lArray3);
        this.engine.fpx.fp2sqr_mont(pointProj.Z, pointProj.Z);
        this.engine.fpx.fp2sub(lArray3, pointProj.Z, pointProj.Z);
        this.engine.fpx.fp2mul_mont(lArray, pointProj.Z, pointProj.Z);
        this.engine.fpx.fp2mul_mont(lArray2, lArray3, pointProj.X);
    }

    protected void eval_final_dual_2_isog(PointProj pointProj) {
        long[][] lArray = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[] lArray3 = new long[this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fp2add(pointProj.X, pointProj.Z, lArray);
        this.engine.fpx.fp2mul_mont(pointProj.X, pointProj.Z, lArray2);
        this.engine.fpx.fp2sqr_mont(lArray, pointProj.X);
        this.engine.fpx.fpcopy(pointProj.X[0], 0, lArray3);
        this.engine.fpx.fpcopy(pointProj.X[1], 0, pointProj.X[0]);
        this.engine.fpx.fpcopy(lArray3, 0, pointProj.X[1]);
        this.engine.fpx.fpnegPRIME(pointProj.X[1]);
        this.engine.fpx.fp2add(lArray2, lArray2, pointProj.Z);
        this.engine.fpx.fp2add(pointProj.Z, pointProj.Z, pointProj.Z);
    }

    protected void eval_dual_4_isog_shared(long[][] lArray, long[][] lArray2, long[][] lArray3, long[][][] lArray4, int n) {
        this.engine.fpx.fp2sub(lArray2, lArray3, lArray4[0 + n]);
        this.engine.fpx.fp2add(lArray2, lArray3, lArray4[1 + n]);
        this.engine.fpx.fp2sqr_mont(lArray, lArray4[2 + n]);
        this.engine.fpx.fp2sub(lArray4[2 + n], lArray4[1 + n], lArray4[2 + n]);
    }

    protected void eval_dual_4_isog(long[][] lArray, long[][] lArray2, long[][][] lArray3, int n, PointProj pointProj) {
        long[][] lArray4 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray5 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray6 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray7 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fp2add(pointProj.X, pointProj.Z, lArray4);
        this.engine.fpx.fp2sub(pointProj.X, pointProj.Z, lArray5);
        this.engine.fpx.fp2sqr_mont(lArray4, lArray4);
        this.engine.fpx.fp2sqr_mont(lArray5, lArray5);
        this.engine.fpx.fp2sub(lArray4, lArray5, lArray6);
        this.engine.fpx.fp2sub(lArray2, lArray, lArray7);
        this.engine.fpx.fp2mul_mont(lArray6, lArray7, lArray7);
        this.engine.fpx.fp2mul_mont(lArray2, lArray4, lArray6);
        this.engine.fpx.fp2sub(lArray6, lArray7, lArray6);
        this.engine.fpx.fp2mul_mont(lArray6, lArray4, pointProj.X);
        this.engine.fpx.fp2mul_mont(lArray7, lArray5, pointProj.Z);
        this.engine.fpx.fp2mul_mont(lArray3[0 + n], pointProj.X, pointProj.X);
        this.engine.fpx.fp2mul_mont(lArray3[1 + n], pointProj.Z, lArray4);
        this.engine.fpx.fp2add(pointProj.X, lArray4, pointProj.X);
        this.engine.fpx.fp2mul_mont(lArray3[2 + n], pointProj.Z, pointProj.Z);
    }

    protected void eval_full_dual_4_isog(long[][][][] lArray, PointProj pointProj) {
        for (int i = 0; i < this.engine.params.MAX_Alice; ++i) {
            this.eval_dual_4_isog(lArray[this.engine.params.MAX_Alice - i][0], lArray[this.engine.params.MAX_Alice - i][1], lArray[this.engine.params.MAX_Alice - i - 1], 2, pointProj);
        }
        if (this.engine.params.OALICE_BITS % 2 == 1) {
            this.eval_dual_2_isog(lArray[this.engine.params.MAX_Alice][2], lArray[this.engine.params.MAX_Alice][3], pointProj);
        }
        this.eval_final_dual_2_isog(pointProj);
    }

    protected void TripleAndParabola_proj(PointProjFull pointProjFull, long[][] lArray, long[][] lArray2) {
        this.engine.fpx.fp2sqr_mont(pointProjFull.X, lArray2);
        this.engine.fpx.fp2add(lArray2, lArray2, lArray);
        this.engine.fpx.fp2add(lArray, lArray2, lArray);
        this.engine.fpx.fpaddPRIME(lArray[0], this.engine.params.Montgomery_one, lArray[0]);
        this.engine.fpx.fp2add(pointProjFull.Y, pointProjFull.Y, lArray2);
    }

    protected void Tate3_proj(PointProjFull pointProjFull, PointProjFull pointProjFull2, long[][] lArray, long[][] lArray2) {
        long[][] lArray3 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray4 = new long[2][this.engine.params.NWORDS_FIELD];
        this.TripleAndParabola_proj(pointProjFull, lArray4, lArray2);
        this.engine.fpx.fp2sub(pointProjFull2.X, pointProjFull.X, lArray);
        this.engine.fpx.fp2mul_mont(lArray4, lArray, lArray);
        this.engine.fpx.fp2sub(pointProjFull.Y, pointProjFull2.Y, lArray3);
        this.engine.fpx.fp2mul_mont(lArray2, lArray3, lArray3);
        this.engine.fpx.fp2add(lArray, lArray3, lArray);
    }

    protected void FinalExpo3(long[][] lArray, long[][] lArray2) {
        int n;
        long[][] lArray3 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fp2copy(lArray2, lArray3);
        this.engine.fpx.fpnegPRIME(lArray3[1]);
        this.engine.fpx.fp2mul_mont(lArray, lArray3, lArray3);
        this.engine.fpx.fp2inv_mont_bingcd(lArray3);
        this.engine.fpx.fpnegPRIME(lArray[1]);
        this.engine.fpx.fp2mul_mont(lArray, lArray2, lArray);
        this.engine.fpx.fp2mul_mont(lArray, lArray3, lArray);
        for (n = 0; n < this.engine.params.OALICE_BITS; ++n) {
            this.engine.fpx.fp2sqr_mont(lArray, lArray);
        }
        for (n = 0; n < this.engine.params.OBOB_EXPON - 1; ++n) {
            this.engine.fpx.cube_Fp2_cycl(lArray, this.engine.params.Montgomery_one);
        }
    }

    protected void FinalExpo3_2way(long[][][] lArray, long[][][] lArray2) {
        int n;
        long[][][] lArray3 = new long[2][2][this.engine.params.NWORDS_FIELD];
        long[][][] lArray4 = new long[2][2][this.engine.params.NWORDS_FIELD];
        for (n = 0; n < 2; ++n) {
            this.engine.fpx.fp2copy(lArray2[n], lArray3[n]);
            this.engine.fpx.fpnegPRIME(lArray3[n][1]);
            this.engine.fpx.fp2mul_mont(lArray[n], lArray3[n], lArray3[n]);
        }
        this.engine.fpx.mont_n_way_inv(lArray3, 2, lArray4);
        for (n = 0; n < 2; ++n) {
            int n2;
            this.engine.fpx.fpnegPRIME(lArray[n][1]);
            this.engine.fpx.fp2mul_mont(lArray[n], lArray2[n], lArray[n]);
            this.engine.fpx.fp2mul_mont(lArray[n], lArray4[n], lArray[n]);
            for (n2 = 0; n2 < this.engine.params.OALICE_BITS; ++n2) {
                this.engine.fpx.fp2sqr_mont(lArray[n], lArray[n]);
            }
            for (n2 = 0; n2 < this.engine.params.OBOB_EXPON - 1; ++n2) {
                this.engine.fpx.cube_Fp2_cycl(lArray[n], this.engine.params.Montgomery_one);
            }
        }
    }

    private boolean FirstPoint_dual(PointProj pointProj, PointProjFull pointProjFull, byte[] byArray) {
        PointProjFull pointProjFull2 = new PointProjFull(this.engine.params.NWORDS_FIELD);
        PointProjFull pointProjFull3 = new PointProjFull(this.engine.params.NWORDS_FIELD);
        long[][][] lArray = new long[2][2][this.engine.params.NWORDS_FIELD];
        long[][][] lArray2 = new long[2][2][this.engine.params.NWORDS_FIELD];
        long[] lArray3 = new long[this.engine.params.NWORDS_FIELD];
        int n = this.engine.params.NWORDS_FIELD;
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, 0 * this.engine.params.NWORDS_FIELD, pointProjFull2.X[0]);
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, 1 * this.engine.params.NWORDS_FIELD, pointProjFull2.X[1]);
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, 2 * this.engine.params.NWORDS_FIELD, pointProjFull2.Y[0]);
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, 3 * this.engine.params.NWORDS_FIELD, pointProjFull2.Y[1]);
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, 4 * this.engine.params.NWORDS_FIELD, pointProjFull3.X[0]);
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, 5 * this.engine.params.NWORDS_FIELD, pointProjFull3.X[1]);
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, 6 * this.engine.params.NWORDS_FIELD, pointProjFull3.Y[0]);
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, 7 * this.engine.params.NWORDS_FIELD, pointProjFull3.Y[1]);
        this.engine.isogeny.CompletePoint(pointProj, pointProjFull);
        this.Tate3_proj(pointProjFull2, pointProjFull, lArray[0], lArray2[0]);
        this.Tate3_proj(pointProjFull3, pointProjFull, lArray[1], lArray2[1]);
        this.FinalExpo3_2way(lArray, lArray2);
        this.engine.fpx.fp2correction(lArray[0]);
        this.engine.fpx.fp2correction(lArray[1]);
        int n2 = Fpx.subarrayEquals(lArray[0][1], lArray3, n) ? 0 : (Fpx.subarrayEquals(lArray[0][1], this.engine.params.g_R_S_im, n) ? 1 : 2);
        int n3 = Fpx.subarrayEquals(lArray[1][1], lArray3, n) ? 0 : (Fpx.subarrayEquals(lArray[1][1], this.engine.params.g_R_S_im, n) ? 1 : 2);
        if (n2 == 0 && n3 == 0) {
            return false;
        }
        byArray[0] = n2 == 0 ? 0 : (n3 == 0 ? 1 : (n2 + n3 == 3 ? 3 : 2));
        return true;
    }

    private boolean SecondPoint_dual(PointProj pointProj, PointProjFull pointProjFull, byte[] byArray) {
        PointProjFull pointProjFull2 = new PointProjFull(this.engine.params.NWORDS_FIELD);
        long[][] lArray = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[] lArray3 = new long[this.engine.params.NWORDS_FIELD];
        int n = this.engine.params.NWORDS_FIELD;
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, (4 * byArray[0] + 0) * this.engine.params.NWORDS_FIELD, pointProjFull2.X[0]);
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, (4 * byArray[0] + 1) * this.engine.params.NWORDS_FIELD, pointProjFull2.X[1]);
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, (4 * byArray[0] + 2) * this.engine.params.NWORDS_FIELD, pointProjFull2.Y[0]);
        this.engine.fpx.fpcopy(this.engine.params.B_gen_3_tors, (4 * byArray[0] + 3) * this.engine.params.NWORDS_FIELD, pointProjFull2.Y[1]);
        this.engine.isogeny.CompletePoint(pointProj, pointProjFull);
        this.Tate3_proj(pointProjFull2, pointProjFull, lArray, lArray2);
        this.FinalExpo3(lArray, lArray2);
        this.engine.fpx.fp2correction(lArray);
        return !Fpx.subarrayEquals(lArray[1], lArray3, n);
    }

    protected void FirstPoint3n(long[][] lArray, long[][][][] lArray2, long[][] lArray3, PointProjFull pointProjFull, int[] nArray, byte[] byArray, byte[] byArray2) {
        boolean bl = false;
        PointProj pointProj = new PointProj(this.engine.params.NWORDS_FIELD);
        long[] lArray4 = new long[this.engine.params.NWORDS_FIELD];
        nArray[0] = 0;
        while (!bl) {
            byArray2[0] = 0;
            this.Elligator2(lArray, nArray, 0, lArray3, byArray2, 0, 0);
            this.engine.fpx.fp2copy(lArray3, pointProj.X);
            this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, pointProj.Z[0]);
            this.engine.fpx.fpcopy(lArray4, 0, pointProj.Z[1]);
            this.eval_full_dual_4_isog(lArray2, pointProj);
            bl = this.FirstPoint_dual(pointProj, pointProjFull, byArray);
            nArray[0] = nArray[0] + 1;
        }
    }

    protected void SecondPoint3n(long[][] lArray, long[][][][] lArray2, long[][] lArray3, PointProjFull pointProjFull, int[] nArray, byte[] byArray, byte[] byArray2) {
        boolean bl = false;
        PointProj pointProj = new PointProj(this.engine.params.NWORDS_FIELD);
        long[] lArray4 = new long[this.engine.params.NWORDS_FIELD];
        while (!bl) {
            byArray2[0] = 0;
            this.Elligator2(lArray, nArray, 1, lArray3, byArray2, 0, 0);
            this.engine.fpx.fp2copy(lArray3, pointProj.X);
            this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, pointProj.Z[0]);
            this.engine.fpx.fpcopy(lArray4, 0, pointProj.Z[1]);
            this.eval_full_dual_4_isog(lArray2, pointProj);
            bl = this.SecondPoint_dual(pointProj, pointProjFull, byArray);
            nArray[1] = nArray[1] + 1;
        }
    }

    protected void makeDiff(PointProjFull pointProjFull, PointProjFull pointProjFull2, PointProj pointProj) {
        long[][] lArray = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray3 = new long[2][this.engine.params.NWORDS_FIELD];
        int n = this.engine.params.NWORDS_FIELD;
        this.engine.fpx.fp2sub(pointProjFull.X, pointProjFull2.X, lArray);
        this.engine.fpx.fp2sub(pointProjFull.Y, pointProjFull2.Y, lArray2);
        this.engine.fpx.fp2sqr_mont(lArray, lArray);
        this.engine.fpx.fp2sqr_mont(lArray2, lArray2);
        this.engine.fpx.fp2add(pointProjFull.X, pointProjFull2.X, lArray3);
        this.engine.fpx.fp2mul_mont(lArray, lArray3, lArray3);
        this.engine.fpx.fp2sub(lArray2, lArray3, lArray2);
        this.engine.fpx.fp2mul_mont(pointProj.Z, lArray2, lArray2);
        this.engine.fpx.fp2mul_mont(pointProj.X, lArray, lArray);
        this.engine.fpx.fp2correction(lArray);
        this.engine.fpx.fp2correction(lArray2);
        if (Fpx.subarrayEquals(lArray[0], lArray2[0], n) & Fpx.subarrayEquals(lArray[1], lArray2[1], n)) {
            this.engine.fpx.fp2neg(pointProjFull2.Y);
        }
    }

    protected void BuildOrdinary3nBasis_dual(long[][] lArray, long[][][][] lArray2, PointProjFull[] pointProjFullArray, int[] nArray, int[] nArray2, int n) {
        PointProj pointProj = new PointProj(this.engine.params.NWORDS_FIELD);
        long[][][] lArray3 = new long[2][2][this.engine.params.NWORDS_FIELD];
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[1];
        this.FirstPoint3n(lArray, lArray2, lArray3[0], pointProjFullArray[0], nArray, byArray, byArray2);
        nArray2[n] = byArray2[0];
        nArray[1] = nArray[0];
        this.SecondPoint3n(lArray, lArray2, lArray3[1], pointProjFullArray[1], nArray, byArray, byArray2);
        int n2 = n;
        nArray2[n2] = nArray2[n2] | byArray2[0] << 1;
        this.BiQuad_affine(lArray, lArray3[0], lArray3[1], pointProj);
        this.eval_full_dual_4_isog(lArray2, pointProj);
        this.makeDiff(pointProjFullArray[0], pointProjFullArray[1], pointProj);
    }

    protected void FullIsogeny_A_dual(byte[] byArray, long[][][][] lArray, long[][] lArray2, int n) {
        PointProj pointProj = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj[] pointProjArray = new PointProj[this.engine.params.MAX_INT_POINTS_ALICE];
        long[][] lArray3 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray4 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray5 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray6 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray7 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray8 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][][] lArray9 = new long[5][2][this.engine.params.NWORDS_FIELD];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[this.engine.params.MAX_INT_POINTS_ALICE];
        long[] lArray10 = new long[this.engine.params.NWORDS_ORDER];
        this.init_basis(this.engine.params.A_gen, lArray3, lArray4, lArray5);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, lArray6[0]);
        this.engine.fpx.fp2add(lArray6, lArray6, lArray6);
        this.engine.fpx.fp2add(lArray6, lArray6, lArray7);
        this.engine.fpx.fp2add(lArray6, lArray7, lArray8);
        this.engine.fpx.fp2add(lArray7, lArray7, lArray6);
        this.engine.fpx.decode_to_digits(byArray, this.engine.params.MSG_BYTES, lArray10, this.engine.params.SECRETKEY_A_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.isogeny.LADDER3PT(lArray3, lArray4, lArray5, lArray10, this.engine.params.ALICE, pointProj, lArray8);
        this.engine.fpx.fp2inv_mont(pointProj.Z);
        this.engine.fpx.fp2mul_mont(pointProj.X, pointProj.Z, pointProj.X);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, pointProj.Z[0]);
        this.engine.fpx.fpzero(pointProj.Z[1]);
        if (n == 1) {
            this.engine.fpx.fp2_encode(pointProj.X, byArray, this.engine.params.MSG_BYTES + this.engine.params.SECRETKEY_A_BYTES + this.engine.params.CRYPTO_PUBLICKEYBYTES);
        }
        if (this.engine.params.OALICE_BITS % 2 == 1) {
            PointProj pointProj2 = new PointProj(this.engine.params.NWORDS_FIELD);
            this.engine.isogeny.xDBLe(pointProj, pointProj2, lArray6, lArray7, this.engine.params.OALICE_BITS - 1);
            this.engine.isogeny.get_2_isog(pointProj2, lArray6, lArray7);
            this.engine.isogeny.eval_2_isog(pointProj, pointProj2);
            this.engine.fpx.fp2copy(pointProj2.X, lArray[this.engine.params.MAX_Alice][2]);
            this.engine.fpx.fp2copy(pointProj2.Z, lArray[this.engine.params.MAX_Alice][3]);
        }
        n2 = 0;
        for (int i = 1; i < this.engine.params.MAX_Alice; ++i) {
            while (n2 < this.engine.params.MAX_Alice - i) {
                pointProjArray[n3] = new PointProj(this.engine.params.NWORDS_FIELD);
                this.engine.fpx.fp2copy(pointProj.X, pointProjArray[n3].X);
                this.engine.fpx.fp2copy(pointProj.Z, pointProjArray[n3].Z);
                nArray[n3++] = n2;
                int n5 = this.engine.params.strat_Alice[n4++];
                this.engine.isogeny.xDBLe(pointProj, pointProj, lArray6, lArray7, 2 * n5);
                n2 += n5;
            }
            this.engine.fpx.fp2copy(lArray6, lArray[i - 1][0]);
            this.engine.fpx.fp2copy(lArray7, lArray[i - 1][1]);
            this.get_4_isog_dual(pointProj, lArray6, lArray7, lArray9);
            for (int j = 0; j < n3; ++j) {
                this.engine.isogeny.eval_4_isog(pointProjArray[j], lArray9);
            }
            this.eval_dual_4_isog_shared(lArray9[2], lArray9[3], lArray9[4], lArray[i - 1], 2);
            this.engine.fpx.fp2copy(pointProjArray[n3 - 1].X, pointProj.X);
            this.engine.fpx.fp2copy(pointProjArray[n3 - 1].Z, pointProj.Z);
            n2 = nArray[n3 - 1];
            --n3;
        }
        this.engine.fpx.fp2copy(lArray6, lArray[this.engine.params.MAX_Alice - 1][0]);
        this.engine.fpx.fp2copy(lArray7, lArray[this.engine.params.MAX_Alice - 1][1]);
        this.get_4_isog_dual(pointProj, lArray6, lArray7, lArray9);
        this.eval_dual_4_isog_shared(lArray9[2], lArray9[3], lArray9[4], lArray[this.engine.params.MAX_Alice - 1], 2);
        this.engine.fpx.fp2copy(lArray6, lArray[this.engine.params.MAX_Alice][0]);
        this.engine.fpx.fp2copy(lArray7, lArray[this.engine.params.MAX_Alice][1]);
        this.engine.fpx.fp2inv_mont_bingcd(lArray7);
        this.engine.fpx.fp2mul_mont(lArray6, lArray7, lArray2);
    }

    protected void Dlogs3_dual(long[][][] lArray, int[] nArray, long[] lArray2, long[] lArray3, long[] lArray4, long[] lArray5) {
        this.solve_dlog(lArray[0], nArray, lArray2, 3);
        this.solve_dlog(lArray[2], nArray, lArray3, 3);
        this.solve_dlog(lArray[1], nArray, lArray4, 3);
        this.solve_dlog(lArray[3], nArray, lArray5, 3);
        this.engine.fpx.mp_sub(this.engine.params.Bob_order, lArray3, lArray3, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.mp_sub(this.engine.params.Bob_order, lArray5, lArray5, this.engine.params.NWORDS_ORDER);
    }

    protected void BuildOrdinary3nBasis_Decomp_dual(long[][] lArray, PointProj[] pointProjArray, int[] nArray, int[] nArray2, int n) {
        byte[] byArray = new byte[]{(byte)(nArray2[n] & 1), (byte)(nArray2[n] >>> 1 & 1)};
        nArray[0] = nArray[0] - 1;
        this.Elligator2(lArray, nArray, 0, pointProjArray[0].X, byArray, 0, 1);
        nArray[1] = nArray[1] - 1;
        this.Elligator2(lArray, nArray, 1, pointProjArray[1].X, byArray, 1, 1);
        this.BiQuad_affine(lArray, pointProjArray[0].X, pointProjArray[1].X, pointProjArray[2]);
    }

    protected void PKADecompression_dual(byte[] byArray, byte[] byArray2, PointProj pointProj, long[][] lArray) {
        int[] nArray = new int[3];
        long[][] lArray2 = new long[2][this.engine.params.NWORDS_FIELD];
        PointProj[] pointProjArray = new PointProj[]{new PointProj(this.engine.params.NWORDS_FIELD), new PointProj(this.engine.params.NWORDS_FIELD), new PointProj(this.engine.params.NWORDS_FIELD)};
        long[] lArray3 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray4 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray5 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray6 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray7 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray8 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray9 = new long[this.engine.params.NWORDS_ORDER];
        this.engine.fpx.fp2_decode(byArray2, lArray, 3 * this.engine.params.ORDER_B_ENCODED_BYTES);
        lArray7[0] = 1L;
        this.engine.fpx.to_Montgomery_mod_order(lArray7, lArray7, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
        byte by = (byte)((byArray2[3 * this.engine.params.ORDER_B_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES] & 0xFF) >> 7);
        byte[] byArray3 = new byte[3];
        System.arraycopy(byArray2, 3 * this.engine.params.ORDER_B_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES, byArray3, 0, 3);
        nArray[0] = byArray3[0] & 0xFFFF;
        nArray[1] = byArray3[1] & 0xFFFF;
        nArray[2] = byArray3[2] & 0xFFFF;
        nArray[0] = nArray[0] & 0x7F;
        this.engine.fpx.fpaddPRIME(lArray[0], this.engine.params.Montgomery_one, lArray2[0]);
        this.engine.fpx.fpcopy(lArray[1], 0, lArray2[1]);
        this.engine.fpx.fpaddPRIME(lArray2[0], this.engine.params.Montgomery_one, lArray2[0]);
        this.engine.fpx.fp2div2(lArray2, lArray2);
        this.engine.fpx.fp2div2(lArray2, lArray2);
        this.BuildOrdinary3nBasis_Decomp_dual(lArray2, pointProjArray, nArray, nArray, 2);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, pointProjArray[0].Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, pointProjArray[1].Z[0]);
        this.engine.isogeny.swap_points(pointProjArray[0], pointProjArray[1], -((long)by));
        this.engine.fpx.decode_to_digits(byArray, 0, lArray9, this.engine.params.SECRETKEY_B_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.to_Montgomery_mod_order(lArray9, lArray3, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
        this.engine.fpx.decode_to_digits(byArray2, 0, lArray8, this.engine.params.ORDER_B_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.to_Montgomery_mod_order(lArray8, lArray4, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
        this.engine.fpx.decode_to_digits(byArray2, this.engine.params.ORDER_B_ENCODED_BYTES, lArray8, this.engine.params.ORDER_B_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.to_Montgomery_mod_order(lArray8, lArray5, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
        this.engine.fpx.decode_to_digits(byArray2, 2 * this.engine.params.ORDER_B_ENCODED_BYTES, lArray8, this.engine.params.ORDER_B_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.to_Montgomery_mod_order(lArray8, lArray6, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
        if (by == 0) {
            this.engine.fpx.Montgomery_multiply_mod_order(lArray3, lArray5, lArray5, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.mp_add(lArray5, lArray7, lArray5, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.Montgomery_inversion_mod_order_bingcd(lArray5, lArray5, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
            this.engine.fpx.Montgomery_multiply_mod_order(lArray3, lArray6, lArray6, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.mp_add(lArray4, lArray6, lArray6, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.Montgomery_multiply_mod_order(lArray5, lArray6, lArray5, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.from_Montgomery_mod_order(lArray5, lArray5, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.Ladder3pt_dual(pointProjArray, lArray5, this.engine.params.BOB, pointProj, lArray2);
        } else {
            this.engine.fpx.Montgomery_multiply_mod_order(lArray3, lArray6, lArray6, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.mp_add(lArray6, lArray7, lArray6, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.Montgomery_inversion_mod_order_bingcd(lArray6, lArray6, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
            this.engine.fpx.Montgomery_multiply_mod_order(lArray3, lArray5, lArray5, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.mp_add(lArray4, lArray5, lArray5, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.Montgomery_multiply_mod_order(lArray5, lArray6, lArray5, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.from_Montgomery_mod_order(lArray5, lArray5, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.Ladder3pt_dual(pointProjArray, lArray5, this.engine.params.BOB, pointProj, lArray2);
        }
        this.engine.isogeny.Double(pointProj, pointProj, lArray2, this.engine.params.OALICE_BITS);
    }

    protected void Compress_PKA_dual(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, long[][] lArray5, int[] nArray, byte[] byArray) {
        long[] lArray6 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray7 = new long[this.engine.params.NWORDS_ORDER];
        long[][] lArray8 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fp2add(lArray5, lArray5, lArray8);
        this.engine.fpx.fp2add(lArray8, lArray8, lArray8);
        this.engine.fpx.fpsubPRIME(lArray8[0], this.engine.params.Montgomery_one, lArray8[0]);
        this.engine.fpx.fpsubPRIME(lArray8[0], this.engine.params.Montgomery_one, lArray8[0]);
        int n = this.engine.fpx.mod3(lArray3);
        this.engine.fpx.to_Montgomery_mod_order(lArray2, lArray2, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
        this.engine.fpx.to_Montgomery_mod_order(lArray4, lArray4, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
        this.engine.fpx.to_Montgomery_mod_order(lArray, lArray, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
        this.engine.fpx.to_Montgomery_mod_order(lArray3, lArray3, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
        if (n != 0) {
            this.engine.fpx.Montgomery_inversion_mod_order_bingcd(lArray3, lArray7, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
            this.engine.fpx.Montgomery_neg(lArray, this.engine.params.Bob_order);
            this.engine.fpx.Montgomery_multiply_mod_order(lArray, lArray7, lArray6, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.from_Montgomery_mod_order(lArray6, lArray6, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.encode_to_bytes(lArray6, byArray, 0, this.engine.params.ORDER_B_ENCODED_BYTES);
            this.engine.fpx.Montgomery_neg(lArray4, this.engine.params.Bob_order);
            this.engine.fpx.Montgomery_multiply_mod_order(lArray4, lArray7, lArray6, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.from_Montgomery_mod_order(lArray6, lArray6, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.encode_to_bytes(lArray6, byArray, this.engine.params.ORDER_B_ENCODED_BYTES, this.engine.params.ORDER_B_ENCODED_BYTES);
            this.engine.fpx.Montgomery_multiply_mod_order(lArray2, lArray7, lArray6, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.from_Montgomery_mod_order(lArray6, lArray6, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.encode_to_bytes(lArray6, byArray, 2 * this.engine.params.ORDER_B_ENCODED_BYTES, this.engine.params.ORDER_B_ENCODED_BYTES);
            byArray[3 * this.engine.params.ORDER_B_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES] = 0;
        } else {
            this.engine.fpx.Montgomery_inversion_mod_order_bingcd(lArray, lArray7, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2, this.engine.params.Montgomery_RB1);
            this.engine.fpx.Montgomery_neg(lArray3, this.engine.params.Bob_order);
            this.engine.fpx.Montgomery_multiply_mod_order(lArray3, lArray7, lArray6, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.from_Montgomery_mod_order(lArray6, lArray6, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.encode_to_bytes(lArray6, byArray, 0, this.engine.params.ORDER_B_ENCODED_BYTES);
            this.engine.fpx.Montgomery_multiply_mod_order(lArray4, lArray7, lArray6, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.from_Montgomery_mod_order(lArray6, lArray6, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.encode_to_bytes(lArray6, byArray, this.engine.params.ORDER_B_ENCODED_BYTES, this.engine.params.ORDER_B_ENCODED_BYTES);
            this.engine.fpx.Montgomery_neg(lArray2, this.engine.params.Bob_order);
            this.engine.fpx.Montgomery_multiply_mod_order(lArray2, lArray7, lArray6, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.from_Montgomery_mod_order(lArray6, lArray6, this.engine.params.Bob_order, this.engine.params.Montgomery_RB2);
            this.engine.fpx.encode_to_bytes(lArray6, byArray, 2 * this.engine.params.ORDER_B_ENCODED_BYTES, this.engine.params.ORDER_B_ENCODED_BYTES);
            byArray[3 * this.engine.params.ORDER_B_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES] = -128;
        }
        this.engine.fpx.fp2_encode(lArray8, byArray, 3 * this.engine.params.ORDER_B_ENCODED_BYTES);
        int n2 = 3 * this.engine.params.ORDER_B_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES;
        byArray[n2] = (byte)(byArray[n2] | (byte)nArray[0]);
        byArray[3 * this.engine.params.ORDER_B_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES + 1] = (byte)nArray[1];
        byArray[3 * this.engine.params.ORDER_B_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES + 2] = (byte)nArray[2];
    }

    protected int EphemeralKeyGeneration_A_extended(byte[] byArray, byte[] byArray2) {
        int[] nArray = new int[3];
        int[] nArray2 = new int[this.engine.params.DLEN_3];
        long[][] lArray = new long[2][this.engine.params.NWORDS_FIELD];
        long[][][][] lArray2 = new long[this.engine.params.MAX_Alice + 1][5][2][this.engine.params.NWORDS_FIELD];
        long[][][] lArray3 = new long[4][2][this.engine.params.NWORDS_FIELD];
        long[] lArray4 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray5 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray6 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray7 = new long[this.engine.params.NWORDS_ORDER];
        PointProjFull[] pointProjFullArray = new PointProjFull[]{new PointProjFull(this.engine.params.NWORDS_FIELD), new PointProjFull(this.engine.params.NWORDS_FIELD)};
        this.FullIsogeny_A_dual(byArray, lArray2, lArray, 1);
        this.BuildOrdinary3nBasis_dual(lArray, lArray2, pointProjFullArray, nArray, nArray, 2);
        this.Tate3_pairings(pointProjFullArray, lArray3);
        this.Dlogs3_dual(lArray3, nArray2, lArray5, lArray4, lArray7, lArray6);
        this.Compress_PKA_dual(lArray5, lArray4, lArray7, lArray6, lArray, nArray, byArray2);
        return 0;
    }

    private int EphemeralKeyGeneration_A(byte[] byArray, byte[] byArray2) {
        int[] nArray = new int[3];
        int[] nArray2 = new int[this.engine.params.DLEN_3];
        long[] lArray = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray2 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray3 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray4 = new long[this.engine.params.NWORDS_ORDER];
        long[][] lArray5 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][][] lArray6 = new long[4][2][this.engine.params.NWORDS_FIELD];
        long[][][][] lArray7 = new long[this.engine.params.MAX_Alice + 1][5][2][this.engine.params.NWORDS_FIELD];
        PointProjFull[] pointProjFullArray = new PointProjFull[2];
        this.FullIsogeny_A_dual(byArray, lArray7, lArray5, 0);
        this.BuildOrdinary3nBasis_dual(lArray5, lArray7, pointProjFullArray, nArray, nArray, 2);
        this.Tate3_pairings(pointProjFullArray, lArray6);
        this.Dlogs3_dual(lArray6, nArray2, lArray2, lArray, lArray4, lArray3);
        this.Compress_PKA_dual(lArray2, lArray, lArray4, lArray3, lArray5, nArray, byArray2);
        return 0;
    }

    int EphemeralSecretAgreement_B(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[this.engine.params.MAX_INT_POINTS_BOB];
        long[][] lArray = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray2 = new long[2][this.engine.params.NWORDS_FIELD];
        PointProj pointProj = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj[] pointProjArray = new PointProj[this.engine.params.MAX_INT_POINTS_BOB];
        long[][] lArray3 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray4 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][][] lArray5 = new long[3][2][this.engine.params.NWORDS_FIELD];
        long[][] lArray6 = new long[2][this.engine.params.NWORDS_FIELD];
        this.PKADecompression_dual(byArray, byArray2, pointProj, lArray6);
        this.engine.fpx.fp2copy(lArray6, lArray4);
        this.engine.fpx.fpaddPRIME(this.engine.params.Montgomery_one, this.engine.params.Montgomery_one, lArray2[0]);
        this.engine.fpx.fp2add(lArray4, lArray2, lArray);
        this.engine.fpx.fp2sub(lArray4, lArray2, lArray2);
        n2 = 0;
        for (int i = 1; i < this.engine.params.MAX_Bob; ++i) {
            while (n2 < this.engine.params.MAX_Bob - i) {
                pointProjArray[n3] = new PointProj(this.engine.params.NWORDS_FIELD);
                this.engine.fpx.fp2copy(pointProj.X, pointProjArray[n3].X);
                this.engine.fpx.fp2copy(pointProj.Z, pointProjArray[n3].Z);
                nArray[n3++] = n2;
                int n4 = this.engine.params.strat_Bob[n++];
                this.engine.isogeny.xTPLe(pointProj, pointProj, lArray2, lArray, n4);
                n2 += n4;
            }
            this.engine.isogeny.get_3_isog(pointProj, lArray2, lArray, lArray5);
            for (int j = 0; j < n3; ++j) {
                this.engine.isogeny.eval_3_isog(pointProjArray[j], lArray5);
            }
            this.engine.fpx.fp2copy(pointProjArray[n3 - 1].X, pointProj.X);
            this.engine.fpx.fp2copy(pointProjArray[n3 - 1].Z, pointProj.Z);
            n2 = nArray[n3 - 1];
            --n3;
        }
        this.engine.isogeny.get_3_isog(pointProj, lArray2, lArray, lArray5);
        this.engine.fpx.fp2add(lArray, lArray2, lArray4);
        this.engine.fpx.fp2add(lArray4, lArray4, lArray4);
        this.engine.fpx.fp2sub(lArray, lArray2, lArray);
        this.engine.isogeny.j_inv(lArray4, lArray, lArray3);
        this.engine.fpx.fp2_encode(lArray3, byArray3, 0);
        return 0;
    }

    protected void BuildEntangledXonly(long[][] lArray, PointProj[] pointProjArray, byte[] byArray, byte[] byArray2) {
        long[][] lArray2;
        long[] lArray3 = new long[this.engine.params.NWORDS_FIELD];
        long[][] lArray4 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray5 = new long[2][this.engine.params.NWORDS_FIELD];
        int n = 0;
        if (this.engine.fpx.is_sqr_fp2(lArray, lArray3)) {
            lArray2 = this.engine.params.table_v_qnr;
            byArray[0] = 1;
        } else {
            lArray2 = this.engine.params.table_v_qr;
            byArray[0] = 0;
        }
        byArray2[0] = 0;
        do {
            this.engine.fpx.fp2mul_mont(lArray, lArray2, n, pointProjArray[0].X);
            n += 2;
            this.engine.fpx.fp2neg(pointProjArray[0].X);
            this.engine.fpx.fp2add(pointProjArray[0].X, lArray, lArray5);
            this.engine.fpx.fp2mul_mont(pointProjArray[0].X, lArray5, lArray5);
            this.engine.fpx.fpaddPRIME(lArray5[0], this.engine.params.Montgomery_one, lArray5[0]);
            this.engine.fpx.fp2mul_mont(pointProjArray[0].X, lArray5, lArray5);
            byArray2[0] = (byte)(byArray2[0] + 1);
        } while (!this.engine.fpx.is_sqr_fp2(lArray5, lArray3));
        byArray2[0] = (byte)(byArray2[0] - 1);
        if (byArray[0] == 1) {
            this.engine.fpx.fpcopy(this.engine.params.table_r_qnr[byArray2[0]], 0, lArray4[0]);
        } else {
            this.engine.fpx.fpcopy(this.engine.params.table_r_qr[byArray2[0]], 0, lArray4[0]);
        }
        this.engine.fpx.fp2add(pointProjArray[0].X, lArray, pointProjArray[1].X);
        this.engine.fpx.fp2neg(pointProjArray[1].X);
        this.engine.fpx.fp2sub(pointProjArray[0].X, pointProjArray[1].X, pointProjArray[2].Z);
        this.engine.fpx.fp2sqr_mont(pointProjArray[2].Z, pointProjArray[2].Z);
        this.engine.fpx.fpcopy(lArray4[0], 0, lArray4[1]);
        this.engine.fpx.fpaddPRIME(this.engine.params.Montgomery_one, lArray4[0], lArray4[0]);
        this.engine.fpx.fp2sqr_mont(lArray4, lArray4);
        this.engine.fpx.fp2mul_mont(lArray5, lArray4, pointProjArray[2].X);
    }

    protected void RecoverY(long[][] lArray, PointProj[] pointProjArray, PointProjFull[] pointProjFullArray) {
        long[][] lArray2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray3 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray4 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray5 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray6 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fp2mul_mont(pointProjArray[2].X, pointProjArray[1].Z, lArray2);
        this.engine.fpx.fp2mul_mont(pointProjArray[1].X, pointProjArray[2].Z, lArray3);
        this.engine.fpx.fp2mul_mont(pointProjArray[1].X, pointProjArray[2].X, lArray4);
        this.engine.fpx.fp2mul_mont(pointProjArray[1].Z, pointProjArray[2].Z, lArray5);
        this.engine.fpx.fp2sqr_mont(pointProjArray[1].X, lArray6);
        this.engine.fpx.fp2sqr_mont(pointProjArray[1].Z, pointProjFullArray[1].X);
        this.engine.fpx.fp2sub(lArray4, lArray5, pointProjFullArray[1].Y);
        this.engine.fpx.fp2mul_mont(pointProjArray[1].X, pointProjFullArray[1].Y, pointProjFullArray[1].Y);
        this.engine.fpx.fp2add(lArray6, pointProjFullArray[1].X, lArray6);
        this.engine.fpx.fp2mul_mont(pointProjArray[2].Z, lArray6, lArray6);
        this.engine.fpx.fp2mul_mont(lArray, lArray3, pointProjFullArray[1].X);
        this.engine.fpx.fp2sub(lArray2, lArray3, pointProjFullArray[1].Z);
        this.engine.fpx.fp2mul_mont(pointProjFullArray[0].X, pointProjFullArray[1].Z, lArray2);
        this.engine.fpx.fp2add(lArray4, pointProjFullArray[1].X, lArray3);
        this.engine.fpx.fp2add(lArray3, lArray3, lArray3);
        this.engine.fpx.fp2sub(lArray2, lArray3, lArray2);
        this.engine.fpx.fp2mul_mont(pointProjArray[1].Z, lArray2, lArray2);
        this.engine.fpx.fp2sub(lArray2, lArray6, lArray2);
        this.engine.fpx.fp2mul_mont(pointProjFullArray[0].X, lArray2, lArray2);
        this.engine.fpx.fp2add(lArray2, pointProjFullArray[1].Y, pointProjFullArray[1].Y);
        this.engine.fpx.fp2mul_mont(pointProjFullArray[0].Y, lArray5, lArray2);
        this.engine.fpx.fp2mul_mont(pointProjArray[1].X, lArray2, pointProjFullArray[1].X);
        this.engine.fpx.fp2add(pointProjFullArray[1].X, pointProjFullArray[1].X, pointProjFullArray[1].X);
        this.engine.fpx.fp2mul_mont(pointProjArray[1].Z, lArray2, pointProjFullArray[1].Z);
        this.engine.fpx.fp2add(pointProjFullArray[1].Z, pointProjFullArray[1].Z, pointProjFullArray[1].Z);
        this.engine.fpx.fp2inv_mont_bingcd(pointProjFullArray[1].Z);
        this.engine.fpx.fp2mul_mont(pointProjFullArray[1].X, pointProjFullArray[1].Z, pointProjFullArray[1].X);
        this.engine.fpx.fp2mul_mont(pointProjFullArray[1].Y, pointProjFullArray[1].Z, pointProjFullArray[1].Y);
    }

    protected void BuildOrdinary2nBasis_dual(long[][] lArray, long[][][][] lArray2, PointProjFull[] pointProjFullArray, byte[] byArray, byte[] byArray2) {
        long[] lArray3 = new long[this.engine.params.NWORDS_FIELD];
        long[][] lArray4 = new long[2][this.engine.params.NWORDS_FIELD];
        PointProj[] pointProjArray = new PointProj[]{new PointProj(this.engine.params.NWORDS_FIELD), new PointProj(this.engine.params.NWORDS_FIELD), new PointProj(this.engine.params.NWORDS_FIELD)};
        this.BuildEntangledXonly(lArray, pointProjArray, byArray, byArray2);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, pointProjArray[0].Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, pointProjArray[1].Z[0]);
        for (int i = 0; i < this.engine.params.MAX_Bob; ++i) {
            this.engine.isogeny.eval_3_isog(pointProjArray[0], lArray2[this.engine.params.MAX_Bob - 1 - i]);
            this.engine.isogeny.eval_3_isog(pointProjArray[1], lArray2[this.engine.params.MAX_Bob - 1 - i]);
            this.engine.isogeny.eval_3_isog(pointProjArray[2], lArray2[this.engine.params.MAX_Bob - 1 - i]);
        }
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, lArray4[0]);
        this.engine.fpx.fpaddPRIME(lArray4[0], lArray4[0], lArray3);
        this.engine.fpx.fpaddPRIME(lArray3, lArray3, lArray4[0]);
        this.engine.fpx.fpaddPRIME(lArray4[0], lArray3, lArray4[0]);
        this.engine.isogeny.CompleteMPoint(lArray4, pointProjArray[0], pointProjFullArray[0]);
        this.RecoverY(lArray4, pointProjArray, pointProjFullArray);
    }

    protected void FullIsogeny_B_dual(byte[] byArray, long[][][][] lArray, long[][] lArray2) {
        PointProj pointProj = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj pointProj2 = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj[] pointProjArray = new PointProj[this.engine.params.MAX_INT_POINTS_BOB];
        long[][] lArray3 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray4 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray5 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray6 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray7 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][][] lArray8 = new long[3][2][this.engine.params.NWORDS_FIELD];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[this.engine.params.MAX_INT_POINTS_BOB];
        long[] lArray9 = new long[this.engine.params.NWORDS_ORDER];
        this.init_basis(this.engine.params.B_gen, lArray3, lArray4, lArray5);
        this.engine.fpx.fpcopy(this.engine.params.XQB3, 0, pointProj2.X[0]);
        this.engine.fpx.fpcopy(this.engine.params.XQB3, this.engine.params.NWORDS_FIELD, pointProj2.X[1]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, pointProj2.Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, lArray6[0]);
        this.engine.fpx.fp2add(lArray6, lArray6, lArray6);
        this.engine.fpx.fp2add(lArray6, lArray6, lArray7);
        this.engine.fpx.fp2add(lArray6, lArray7, lArray2);
        this.engine.fpx.fp2add(lArray7, lArray7, lArray6);
        this.engine.fpx.decode_to_digits(byArray, 0, lArray9, this.engine.params.SECRETKEY_B_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.isogeny.LADDER3PT(lArray3, lArray4, lArray5, lArray9, this.engine.params.BOB, pointProj, lArray2);
        n = 0;
        for (int i = 1; i < this.engine.params.MAX_Bob; ++i) {
            while (n < this.engine.params.MAX_Bob - i) {
                pointProjArray[n2] = new PointProj(this.engine.params.NWORDS_FIELD);
                this.engine.fpx.fp2copy(pointProj.X, pointProjArray[n2].X);
                this.engine.fpx.fp2copy(pointProj.Z, pointProjArray[n2].Z);
                nArray[n2++] = n;
                int n4 = this.engine.params.strat_Bob[n3++];
                this.engine.isogeny.xTPLe(pointProj, pointProj, lArray7, lArray6, n4);
                n += n4;
            }
            this.engine.isogeny.get_3_isog(pointProj, lArray7, lArray6, lArray8);
            for (int j = 0; j < n2; ++j) {
                this.engine.isogeny.eval_3_isog(pointProjArray[j], lArray8);
            }
            this.engine.isogeny.eval_3_isog(pointProj2, lArray8);
            this.engine.fpx.fp2sub(pointProj2.X, pointProj2.Z, lArray[i - 1][0]);
            this.engine.fpx.fp2add(pointProj2.X, pointProj2.Z, lArray[i - 1][1]);
            this.engine.fpx.fp2copy(pointProjArray[n2 - 1].X, pointProj.X);
            this.engine.fpx.fp2copy(pointProjArray[n2 - 1].Z, pointProj.Z);
            n = nArray[n2 - 1];
            --n2;
        }
        this.engine.isogeny.get_3_isog(pointProj, lArray7, lArray6, lArray8);
        this.engine.isogeny.eval_3_isog(pointProj2, lArray8);
        this.engine.fpx.fp2sub(pointProj2.X, pointProj2.Z, lArray[this.engine.params.MAX_Bob - 1][0]);
        this.engine.fpx.fp2add(pointProj2.X, pointProj2.Z, lArray[this.engine.params.MAX_Bob - 1][1]);
        this.engine.fpx.fp2add(lArray6, lArray7, lArray2);
        this.engine.fpx.fp2sub(lArray6, lArray7, lArray6);
        this.engine.fpx.fp2inv_mont_bingcd(lArray6);
        this.engine.fpx.fp2mul_mont(lArray6, lArray2, lArray2);
        this.engine.fpx.fp2add(lArray2, lArray2, lArray2);
    }

    protected void Dlogs2_dual(long[][][] lArray, int[] nArray, long[] lArray2, long[] lArray3, long[] lArray4, long[] lArray5) {
        this.solve_dlog(lArray[0], nArray, lArray2, 2);
        this.solve_dlog(lArray[2], nArray, lArray3, 2);
        this.solve_dlog(lArray[1], nArray, lArray4, 2);
        this.solve_dlog(lArray[3], nArray, lArray5, 2);
        this.engine.fpx.mp_sub(this.engine.params.Alice_order, lArray3, lArray3, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.mp_sub(this.engine.params.Alice_order, lArray5, lArray5, this.engine.params.NWORDS_ORDER);
    }

    protected void BuildEntangledXonly_Decomp(long[][] lArray, PointProj[] pointProjArray, int n, int n2) {
        long[][] lArray2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray3 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray4 = n == 1 ? this.engine.params.table_v_qnr : this.engine.params.table_v_qr;
        if (n2 >= this.engine.params.TABLE_V_LEN / 2) {
            n2 = 0;
        }
        this.engine.fpx.fp2mul_mont(lArray, lArray4, n2 * 2, pointProjArray[0].X);
        this.engine.fpx.fp2neg(pointProjArray[0].X);
        this.engine.fpx.fp2add(pointProjArray[0].X, lArray, lArray3);
        this.engine.fpx.fp2mul_mont(pointProjArray[0].X, lArray3, lArray3);
        this.engine.fpx.fpaddPRIME(lArray3[0], this.engine.params.Montgomery_one, lArray3[0]);
        this.engine.fpx.fp2mul_mont(pointProjArray[0].X, lArray3, lArray3);
        if (n == 1) {
            this.engine.fpx.fpcopy(this.engine.params.table_r_qnr[n2], 0, lArray2[0]);
        } else {
            this.engine.fpx.fpcopy(this.engine.params.table_r_qr[n2], 0, lArray2[0]);
        }
        this.engine.fpx.fp2add(pointProjArray[0].X, lArray, pointProjArray[1].X);
        this.engine.fpx.fp2neg(pointProjArray[1].X);
        this.engine.fpx.fp2sub(pointProjArray[0].X, pointProjArray[1].X, pointProjArray[2].Z);
        this.engine.fpx.fp2sqr_mont(pointProjArray[2].Z, pointProjArray[2].Z);
        this.engine.fpx.fpcopy(lArray2[0], 0, lArray2[1]);
        this.engine.fpx.fpaddPRIME(this.engine.params.Montgomery_one, lArray2[0], lArray2[0]);
        this.engine.fpx.fp2sqr_mont(lArray2, lArray2);
        this.engine.fpx.fp2mul_mont(lArray3, lArray2, pointProjArray[2].X);
    }

    protected void PKBDecompression_extended(byte[] byArray, int n, byte[] byArray2, PointProj pointProj, long[][] lArray, byte[] byArray3, int n2) {
        long l = -1L;
        long[][] lArray2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray3 = new long[2][this.engine.params.NWORDS_FIELD];
        long[] lArray4 = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] lArray5 = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] lArray6 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray7 = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] lArray8 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray9 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray10 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray11 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray12 = new long[this.engine.params.NWORDS_ORDER];
        PointProj[] pointProjArray = new PointProj[]{new PointProj(this.engine.params.NWORDS_FIELD), new PointProj(this.engine.params.NWORDS_FIELD), new PointProj(this.engine.params.NWORDS_FIELD)};
        l >>>= this.engine.params.MAXBITS_ORDER - this.engine.params.OALICE_BITS;
        this.engine.fpx.fp2_decode(byArray2, lArray, 4 * this.engine.params.ORDER_A_ENCODED_BYTES);
        int n3 = byArray2[4 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES] & 1;
        byte by = byArray2[4 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES + 1];
        this.BuildEntangledXonly_Decomp(lArray, pointProjArray, n3, by);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, pointProjArray[0].Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, pointProjArray[1].Z[0]);
        this.engine.fpx.fpaddPRIME(lArray[0], this.engine.params.Montgomery_one, lArray2[0]);
        this.engine.fpx.fpcopy(lArray[1], 0, lArray2[1]);
        this.engine.fpx.fpaddPRIME(lArray2[0], this.engine.params.Montgomery_one, lArray2[0]);
        this.engine.fpx.fp2div2(lArray2, lArray2);
        this.engine.fpx.fp2div2(lArray2, lArray2);
        this.engine.fpx.decode_to_digits(byArray, n, lArray8, this.engine.params.SECRETKEY_A_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.decode_to_digits(byArray2, 0, lArray9, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.decode_to_digits(byArray2, this.engine.params.ORDER_A_ENCODED_BYTES, lArray11, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.decode_to_digits(byArray2, 2 * this.engine.params.ORDER_A_ENCODED_BYTES, lArray10, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.decode_to_digits(byArray2, 3 * this.engine.params.ORDER_A_ENCODED_BYTES, lArray12, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
        if ((lArray9[0] & 1L) == 1L) {
            this.engine.fpx.multiply(lArray8, lArray12, lArray4, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.mp_add(lArray4, lArray11, lArray4, this.engine.params.NWORDS_ORDER);
            int n4 = this.engine.params.NWORDS_ORDER - 1;
            lArray4[n4] = lArray4[n4] & l;
            this.engine.fpx.multiply(lArray8, lArray10, lArray5, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.mp_add(lArray5, lArray9, lArray5, this.engine.params.NWORDS_ORDER);
            int n5 = this.engine.params.NWORDS_ORDER - 1;
            lArray5[n5] = lArray5[n5] & l;
            this.engine.fpx.inv_mod_orderA(lArray5, lArray6);
            this.engine.fpx.multiply(lArray4, lArray6, lArray7, this.engine.params.NWORDS_ORDER);
            int n6 = this.engine.params.NWORDS_ORDER - 1;
            lArray7[n6] = lArray7[n6] & l;
            this.Ladder3pt_dual(pointProjArray, lArray7, this.engine.params.ALICE, pointProj, lArray2);
        } else {
            this.engine.fpx.multiply(lArray8, lArray10, lArray4, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.mp_add(lArray4, lArray9, lArray4, this.engine.params.NWORDS_ORDER);
            int n7 = this.engine.params.NWORDS_ORDER - 1;
            lArray4[n7] = lArray4[n7] & l;
            this.engine.fpx.multiply(lArray8, lArray12, lArray5, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.mp_add(lArray5, lArray11, lArray5, this.engine.params.NWORDS_ORDER);
            int n8 = this.engine.params.NWORDS_ORDER - 1;
            lArray5[n8] = lArray5[n8] & l;
            this.engine.fpx.inv_mod_orderA(lArray5, lArray6);
            this.engine.fpx.multiply(lArray6, lArray4, lArray7, this.engine.params.NWORDS_ORDER);
            int n9 = this.engine.params.NWORDS_ORDER - 1;
            lArray7[n9] = lArray7[n9] & l;
            this.engine.isogeny.swap_points(pointProjArray[0], pointProjArray[1], -1L);
            this.Ladder3pt_dual(pointProjArray, lArray7, this.engine.params.ALICE, pointProj, lArray2);
        }
        this.engine.fpx.fp2div2(lArray, lArray3);
        this.engine.isogeny.xTPLe_fast(pointProj, pointProj, lArray3, this.engine.params.OBOB_EXPON);
        this.engine.fpx.fp2_encode(pointProj.X, byArray3, n2);
        this.engine.fpx.fp2_encode(pointProj.Z, byArray3, n2 + this.engine.params.FP2_ENCODED_BYTES);
        this.engine.fpx.encode_to_bytes(lArray6, byArray3, n2 + 2 * this.engine.params.FP2_ENCODED_BYTES, this.engine.params.ORDER_A_ENCODED_BYTES);
    }

    protected void Compress_PKB_dual_extended(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, long[][] lArray5, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        long l = -1L;
        long[] lArray6 = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] lArray7 = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] lArray8 = new long[2 * this.engine.params.NWORDS_ORDER];
        l >>>= this.engine.params.MAXBITS_ORDER - this.engine.params.OALICE_BITS;
        this.engine.fpx.multiply(lArray2, lArray3, lArray6, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.multiply(lArray4, lArray, lArray7, this.engine.params.NWORDS_ORDER);
        this.engine.fpx.Montgomery_neg(lArray7, this.engine.params.Alice_order);
        this.engine.fpx.mp_add(lArray6, lArray7, lArray7, this.engine.params.NWORDS_ORDER);
        int n = this.engine.params.NWORDS_ORDER - 1;
        lArray7[n] = lArray7[n] & l;
        this.engine.fpx.inv_mod_orderA(lArray7, lArray8);
        this.engine.fpx.multiply(lArray3, lArray8, lArray6, this.engine.params.NWORDS_ORDER);
        int n2 = this.engine.params.NWORDS_ORDER - 1;
        lArray6[n2] = lArray6[n2] & l;
        this.engine.fpx.encode_to_bytes(lArray6, byArray3, 0, this.engine.params.ORDER_A_ENCODED_BYTES);
        this.engine.fpx.Montgomery_neg(lArray, this.engine.params.Alice_order);
        this.engine.fpx.multiply(lArray, lArray8, lArray6, this.engine.params.NWORDS_ORDER);
        int n3 = this.engine.params.NWORDS_ORDER - 1;
        lArray6[n3] = lArray6[n3] & l;
        this.engine.fpx.encode_to_bytes(lArray6, byArray3, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.ORDER_A_ENCODED_BYTES);
        this.engine.fpx.Montgomery_neg(lArray4, this.engine.params.Alice_order);
        this.engine.fpx.multiply(lArray4, lArray8, lArray6, this.engine.params.NWORDS_ORDER);
        int n4 = this.engine.params.NWORDS_ORDER - 1;
        lArray6[n4] = lArray6[n4] & l;
        this.engine.fpx.encode_to_bytes(lArray6, byArray3, 2 * this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.ORDER_A_ENCODED_BYTES);
        this.engine.fpx.multiply(lArray2, lArray8, lArray6, this.engine.params.NWORDS_ORDER);
        int n5 = this.engine.params.NWORDS_ORDER - 1;
        lArray6[n5] = lArray6[n5] & l;
        this.engine.fpx.encode_to_bytes(lArray6, byArray3, 3 * this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.ORDER_A_ENCODED_BYTES);
        this.engine.fpx.fp2_encode(lArray5, byArray3, 4 * this.engine.params.ORDER_A_ENCODED_BYTES);
        byArray3[4 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES] = byArray[0];
        byArray3[4 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES + 1] = byArray2[0];
    }

    protected void PKBDecompression(byte[] byArray, int n, byte[] byArray2, PointProj pointProj, long[][] lArray) {
        long l = -1L;
        long[][] lArray2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[] lArray3 = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] lArray4 = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] lArray5 = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] lArray6 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray7 = new long[this.engine.params.NWORDS_ORDER];
        PointProj[] pointProjArray = new PointProj[3];
        l >>>= this.engine.params.MAXBITS_ORDER - this.engine.params.OALICE_BITS;
        lArray5[0] = 1L;
        this.engine.fpx.fp2_decode(byArray2, lArray, 3 * this.engine.params.ORDER_A_ENCODED_BYTES);
        int n2 = byArray2[3 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES] >>> 7;
        int n3 = byArray2[3 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES] & 1;
        byte by = byArray2[3 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES + 1];
        this.BuildEntangledXonly_Decomp(lArray, pointProjArray, n3, by);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, pointProjArray[0].Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, pointProjArray[1].Z[0]);
        this.engine.fpx.fpaddPRIME(lArray[0], this.engine.params.Montgomery_one, lArray2[0]);
        this.engine.fpx.fpcopy(lArray[1], 0, lArray2[1]);
        this.engine.fpx.fpaddPRIME(lArray2[0], this.engine.params.Montgomery_one, lArray2[0]);
        this.engine.fpx.fp2div2(lArray2, lArray2);
        this.engine.fpx.fp2div2(lArray2, lArray2);
        this.engine.fpx.decode_to_digits(byArray, n, lArray6, this.engine.params.SECRETKEY_A_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.isogeny.swap_points(pointProjArray[0], pointProjArray[1], 0L - (long)n2);
        if (n2 == 0) {
            this.engine.fpx.decode_to_digits(byArray2, this.engine.params.ORDER_A_ENCODED_BYTES, lArray7, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.multiply(lArray6, lArray7, lArray3, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.mp_add(lArray3, lArray5, lArray3, this.engine.params.NWORDS_ORDER);
            int n4 = this.engine.params.NWORDS_ORDER - 1;
            lArray3[n4] = lArray3[n4] & l;
            this.engine.fpx.inv_mod_orderA(lArray3, lArray4);
            this.engine.fpx.decode_to_digits(byArray2, 2 * this.engine.params.ORDER_A_ENCODED_BYTES, lArray7, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.multiply(lArray6, lArray7, lArray3, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.decode_to_digits(byArray2, 0, lArray7, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.mp_add(lArray7, lArray3, lArray3, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.multiply(lArray3, lArray4, lArray5, this.engine.params.NWORDS_ORDER);
            int n5 = this.engine.params.NWORDS_ORDER - 1;
            lArray5[n5] = lArray5[n5] & l;
            this.Ladder3pt_dual(pointProjArray, lArray5, this.engine.params.ALICE, pointProj, lArray2);
        } else {
            this.engine.fpx.decode_to_digits(byArray2, 2 * this.engine.params.ORDER_A_ENCODED_BYTES, lArray7, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.multiply(lArray6, lArray7, lArray3, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.mp_add(lArray3, lArray5, lArray3, this.engine.params.NWORDS_ORDER);
            int n6 = this.engine.params.NWORDS_ORDER - 1;
            lArray3[n6] = lArray3[n6] & l;
            this.engine.fpx.inv_mod_orderA(lArray3, lArray4);
            this.engine.fpx.decode_to_digits(byArray2, this.engine.params.ORDER_A_ENCODED_BYTES, lArray7, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.multiply(lArray6, lArray7, lArray3, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.decode_to_digits(byArray2, 0, lArray7, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.mp_add(lArray7, lArray3, lArray3, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.multiply(lArray3, lArray4, lArray5, this.engine.params.NWORDS_ORDER);
            int n7 = this.engine.params.NWORDS_ORDER - 1;
            lArray5[n7] = lArray5[n7] & l;
            this.Ladder3pt_dual(pointProjArray, lArray5, this.engine.params.ALICE, pointProj, lArray2);
        }
        this.engine.fpx.fp2div2(lArray, lArray2);
        this.engine.isogeny.xTPLe_fast(pointProj, pointProj, lArray2, this.engine.params.OBOB_EXPON);
    }

    protected void Compress_PKB_dual(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, long[][] lArray5, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        long[] lArray6 = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] lArray7 = new long[this.engine.params.NWORDS_ORDER];
        if ((lArray3[0] & 1L) == 1L) {
            this.engine.fpx.inv_mod_orderA(lArray3, lArray7);
            this.engine.fpx.Montgomery_neg(lArray, this.engine.params.Alice_order);
            this.engine.fpx.multiply(lArray, lArray7, lArray6, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.encode_to_bytes(lArray6, byArray3, 0, this.engine.params.ORDER_A_ENCODED_BYTES);
            int n = this.engine.params.ORDER_A_ENCODED_BYTES - 1;
            byArray3[n] = (byte)(byArray3[n] & this.engine.params.MASK_ALICE);
            this.engine.fpx.Montgomery_neg(lArray4, this.engine.params.Alice_order);
            this.engine.fpx.multiply(lArray4, lArray7, lArray6, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.encode_to_bytes(lArray6, byArray3, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.ORDER_A_ENCODED_BYTES);
            int n2 = 2 * this.engine.params.ORDER_A_ENCODED_BYTES - 1;
            byArray3[n2] = (byte)(byArray3[n2] & this.engine.params.MASK_ALICE);
            this.engine.fpx.multiply(lArray2, lArray7, lArray6, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.encode_to_bytes(lArray6, byArray3, 2 * this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.ORDER_A_ENCODED_BYTES);
            int n3 = 3 * this.engine.params.ORDER_A_ENCODED_BYTES - 1;
            byArray3[n3] = (byte)(byArray3[n3] & this.engine.params.MASK_ALICE);
            byArray3[3 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES] = 0;
        } else {
            this.engine.fpx.inv_mod_orderA(lArray, lArray7);
            this.engine.fpx.Montgomery_neg(lArray3, this.engine.params.Alice_order);
            this.engine.fpx.multiply(lArray3, lArray7, lArray6, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.encode_to_bytes(lArray6, byArray3, 0, this.engine.params.ORDER_A_ENCODED_BYTES);
            int n = this.engine.params.ORDER_A_ENCODED_BYTES - 1;
            byArray3[n] = (byte)(byArray3[n] & this.engine.params.MASK_ALICE);
            this.engine.fpx.multiply(lArray4, lArray7, lArray6, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.encode_to_bytes(lArray6, byArray3, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.ORDER_A_ENCODED_BYTES);
            int n4 = 2 * this.engine.params.ORDER_A_ENCODED_BYTES - 1;
            byArray3[n4] = (byte)(byArray3[n4] & this.engine.params.MASK_ALICE);
            this.engine.fpx.Montgomery_neg(lArray2, this.engine.params.Alice_order);
            this.engine.fpx.multiply(lArray2, lArray7, lArray6, this.engine.params.NWORDS_ORDER);
            this.engine.fpx.encode_to_bytes(lArray6, byArray3, 2 * this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.ORDER_A_ENCODED_BYTES);
            int n5 = 3 * this.engine.params.ORDER_A_ENCODED_BYTES - 1;
            byArray3[n5] = (byte)(byArray3[n5] & this.engine.params.MASK_ALICE);
            byArray3[3 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES] = -128;
        }
        this.engine.fpx.fp2_encode(lArray5, byArray3, 3 * this.engine.params.ORDER_A_ENCODED_BYTES);
        int n = 3 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES;
        byArray3[n] = (byte)(byArray3[n] | byArray[0]);
        byArray3[3 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES + 1] = byArray2[0];
        byArray3[3 * this.engine.params.ORDER_A_ENCODED_BYTES + this.engine.params.FP2_ENCODED_BYTES + 2] = 0;
    }

    protected int EphemeralKeyGeneration_B_extended(byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3 = new byte[1];
        byte[] byArray4 = new byte[1];
        int[] nArray = new int[this.engine.params.DLEN_2];
        long[] lArray = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray2 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray3 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray4 = new long[this.engine.params.NWORDS_ORDER];
        long[][][][] lArray5 = new long[this.engine.params.MAX_Bob][2][2][this.engine.params.NWORDS_FIELD];
        long[][][] lArray6 = new long[4][2][this.engine.params.NWORDS_FIELD];
        long[][] lArray7 = new long[2][this.engine.params.NWORDS_FIELD];
        PointProjFull[] pointProjFullArray = new PointProjFull[]{new PointProjFull(this.engine.params.NWORDS_FIELD), new PointProjFull(this.engine.params.NWORDS_FIELD)};
        PointProj pointProj = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj pointProj2 = new PointProj(this.engine.params.NWORDS_FIELD);
        this.FullIsogeny_B_dual(byArray, lArray5, lArray7);
        this.BuildOrdinary2nBasis_dual(lArray7, lArray5, pointProjFullArray, byArray3, byArray4);
        this.engine.fpx.fpaddPRIME(this.engine.params.Montgomery_one, pointProjFullArray[0].X[0], pointProjFullArray[0].X[0]);
        this.engine.fpx.fpaddPRIME(this.engine.params.Montgomery_one, pointProjFullArray[0].X[0], pointProjFullArray[0].X[0]);
        this.engine.fpx.fpaddPRIME(this.engine.params.Montgomery_one, pointProjFullArray[1].X[0], pointProjFullArray[1].X[0]);
        this.engine.fpx.fpaddPRIME(this.engine.params.Montgomery_one, pointProjFullArray[1].X[0], pointProjFullArray[1].X[0]);
        this.engine.fpx.fpcopy(this.engine.params.A_basis_zero, 0 * this.engine.params.NWORDS_FIELD, pointProj.X[0]);
        this.engine.fpx.fpcopy(this.engine.params.A_basis_zero, 1 * this.engine.params.NWORDS_FIELD, pointProj.X[1]);
        this.engine.fpx.fpcopy(this.engine.params.A_basis_zero, 2 * this.engine.params.NWORDS_FIELD, pointProj.Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.A_basis_zero, 3 * this.engine.params.NWORDS_FIELD, pointProj.Z[1]);
        this.engine.fpx.fpcopy(this.engine.params.A_basis_zero, 4 * this.engine.params.NWORDS_FIELD, pointProj2.X[0]);
        this.engine.fpx.fpcopy(this.engine.params.A_basis_zero, 5 * this.engine.params.NWORDS_FIELD, pointProj2.X[1]);
        this.engine.fpx.fpcopy(this.engine.params.A_basis_zero, 6 * this.engine.params.NWORDS_FIELD, pointProj2.Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.A_basis_zero, 7 * this.engine.params.NWORDS_FIELD, pointProj2.Z[1]);
        this.Tate2_pairings(pointProj, pointProj2, pointProjFullArray, lArray6);
        this.engine.fpx.fp2correction(lArray6[0]);
        this.engine.fpx.fp2correction(lArray6[1]);
        this.engine.fpx.fp2correction(lArray6[2]);
        this.engine.fpx.fp2correction(lArray6[3]);
        this.Dlogs2_dual(lArray6, nArray, lArray2, lArray, lArray4, lArray3);
        if (n == 1) {
            this.Compress_PKB_dual_extended(lArray2, lArray, lArray4, lArray3, lArray7, byArray3, byArray4, byArray2);
        } else {
            this.Compress_PKB_dual(lArray2, lArray, lArray4, lArray3, lArray7, byArray3, byArray4, byArray2);
        }
        return 0;
    }

    protected int EphemeralKeyGeneration_B(byte[] byArray, byte[] byArray2) {
        return this.EphemeralKeyGeneration_B_extended(byArray, byArray2, 0);
    }

    protected int EphemeralSecretAgreement_A_extended(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[this.engine.params.MAX_INT_POINTS_ALICE];
        long[][] lArray = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray2 = new long[2][this.engine.params.NWORDS_FIELD];
        PointProj pointProj = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj[] pointProjArray = new PointProj[this.engine.params.MAX_INT_POINTS_ALICE];
        long[][] lArray3 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray4 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray5 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][][] lArray6 = new long[5][2][this.engine.params.NWORDS_FIELD];
        if (n2 == 1) {
            this.PKBDecompression_extended(byArray, n, byArray2, pointProj, lArray5, byArray3, this.engine.params.FP2_ENCODED_BYTES);
        } else {
            this.PKBDecompression(byArray, n, byArray2, pointProj, lArray5);
        }
        this.engine.fpx.fp2copy(lArray5, lArray4);
        this.engine.fpx.fpaddPRIME(this.engine.params.Montgomery_one, this.engine.params.Montgomery_one, lArray2[0]);
        this.engine.fpx.fp2add(lArray4, lArray2, lArray);
        this.engine.fpx.fpaddPRIME(lArray2[0], lArray2[0], lArray2[0]);
        if (this.engine.params.OALICE_BITS % 2 == 1) {
            PointProj pointProj2 = new PointProj(this.engine.params.NWORDS_FIELD);
            this.engine.isogeny.xDBLe(pointProj, pointProj2, lArray, lArray2, this.engine.params.OALICE_BITS - 1);
            this.engine.isogeny.get_2_isog(pointProj2, lArray, lArray2);
            this.engine.isogeny.eval_2_isog(pointProj, pointProj2);
        }
        n4 = 0;
        for (int i = 1; i < this.engine.params.MAX_Alice; ++i) {
            while (n4 < this.engine.params.MAX_Alice - i) {
                pointProjArray[n5] = new PointProj(this.engine.params.NWORDS_FIELD);
                this.engine.fpx.fp2copy(pointProj.X, pointProjArray[n5].X);
                this.engine.fpx.fp2copy(pointProj.Z, pointProjArray[n5].Z);
                nArray[n5++] = n4;
                int n6 = this.engine.params.strat_Alice[n3++];
                this.engine.isogeny.xDBLe(pointProj, pointProj, lArray, lArray2, 2 * n6);
                n4 += n6;
            }
            this.engine.isogeny.get_4_isog(pointProj, lArray, lArray2, lArray6);
            for (int j = 0; j < n5; ++j) {
                this.engine.isogeny.eval_4_isog(pointProjArray[j], lArray6);
            }
            this.engine.fpx.fp2copy(pointProjArray[n5 - 1].X, pointProj.X);
            this.engine.fpx.fp2copy(pointProjArray[n5 - 1].Z, pointProj.Z);
            n4 = nArray[n5 - 1];
            --n5;
        }
        this.engine.isogeny.get_4_isog(pointProj, lArray, lArray2, lArray6);
        this.engine.fpx.fp2add(lArray, lArray, lArray);
        this.engine.fpx.fp2sub(lArray, lArray2, lArray);
        this.engine.fpx.fp2add(lArray, lArray, lArray);
        this.engine.isogeny.j_inv(lArray, lArray2, lArray3);
        this.engine.fpx.fp2_encode(lArray3, byArray3, 0);
        return 0;
    }

    int EphemeralSecretAgreement_A(byte[] byArray, int n, byte[] byArray2, byte[] byArray3) {
        return this.EphemeralSecretAgreement_A_extended(byArray, n, byArray2, byArray3, 0);
    }

    protected byte validate_ciphertext(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, byte[] byArray4, int n2) {
        PointProj[] pointProjArray = new PointProj[3];
        PointProj[] pointProjArray2 = new PointProj[this.engine.params.MAX_INT_POINTS_BOB];
        pointProjArray[0] = new PointProj(this.engine.params.NWORDS_FIELD);
        pointProjArray[1] = new PointProj(this.engine.params.NWORDS_FIELD);
        pointProjArray[2] = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj pointProj = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj pointProj2 = new PointProj(this.engine.params.NWORDS_FIELD);
        long[][] lArray = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray3 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray4 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray5 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray6 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray7 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray8 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray9 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][][] lArray10 = new long[3][2][this.engine.params.NWORDS_FIELD];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[this.engine.params.MAX_INT_POINTS_BOB];
        long[] lArray11 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray12 = new long[this.engine.params.NWORDS_ORDER];
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, lArray9[0]);
        this.init_basis(this.engine.params.B_gen, lArray, lArray2, lArray3);
        this.engine.fpx.fp2_decode(byArray3, pointProjArray[0].X, n);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, pointProjArray[0].Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, lArray4[0]);
        this.engine.fpx.fp2add(lArray4, lArray4, lArray4);
        this.engine.fpx.fp2add(lArray4, lArray4, lArray5);
        this.engine.fpx.fp2add(lArray4, lArray5, lArray6);
        this.engine.fpx.fp2add(lArray5, lArray5, lArray4);
        this.engine.fpx.decode_to_digits(byArray, 0, lArray12, this.engine.params.SECRETKEY_B_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.isogeny.LADDER3PT(lArray, lArray2, lArray3, lArray12, this.engine.params.BOB, pointProj, lArray6);
        n3 = 0;
        for (int i = 1; i < this.engine.params.MAX_Bob; ++i) {
            while (n3 < this.engine.params.MAX_Bob - i) {
                pointProjArray2[n4] = new PointProj(this.engine.params.NWORDS_FIELD);
                this.engine.fpx.fp2copy(pointProj.X, pointProjArray2[n4].X);
                this.engine.fpx.fp2copy(pointProj.Z, pointProjArray2[n4].Z);
                nArray[n4++] = n3;
                int n6 = this.engine.params.strat_Bob[n5++];
                this.engine.isogeny.xTPLe(pointProj, pointProj, lArray5, lArray4, n6);
                n3 += n6;
            }
            this.engine.isogeny.get_3_isog(pointProj, lArray5, lArray4, lArray10);
            for (int j = 0; j < n4; ++j) {
                this.engine.isogeny.eval_3_isog(pointProjArray2[j], lArray10);
            }
            this.engine.isogeny.eval_3_isog(pointProjArray[0], lArray10);
            this.engine.fpx.fp2copy(pointProjArray2[n4 - 1].X, pointProj.X);
            this.engine.fpx.fp2copy(pointProjArray2[n4 - 1].Z, pointProj.Z);
            n3 = nArray[n4 - 1];
            --n4;
        }
        this.engine.isogeny.get_3_isog(pointProj, lArray5, lArray4, lArray10);
        this.engine.isogeny.eval_3_isog(pointProjArray[0], lArray10);
        this.engine.fpx.fp2_decode(byArray2, lArray6, 4 * this.engine.params.ORDER_A_ENCODED_BYTES);
        this.engine.fpx.fp2_decode(byArray4, pointProj2.X, n2);
        this.engine.fpx.fp2_decode(byArray4, pointProj2.Z, n2 + this.engine.params.FP2_ENCODED_BYTES);
        this.engine.fpx.decode_to_digits(byArray4, n2 + 2 * this.engine.params.FP2_ENCODED_BYTES, lArray11, this.engine.params.ORDER_A_ENCODED_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.isogeny.Ladder(pointProjArray[0], lArray11, lArray6, this.engine.params.OALICE_BITS, pointProj);
        this.engine.fpx.fp2mul_mont(pointProj.X, pointProj2.Z, lArray7);
        this.engine.fpx.fp2mul_mont(pointProj.Z, pointProj2.X, lArray8);
        return this.engine.fpx.cmp_f2elm(lArray7, lArray8);
    }

    void solve_dlog(long[][] lArray, int[] nArray, long[] lArray2, int n) {
        if (n == 2) {
            if (this.engine.params.OALICE_BITS % this.engine.params.W_2 == 0) {
                this.Traverse_w_div_e_fullsigned(lArray, 0, 0, this.engine.params.PLEN_2 - 1, this.engine.params.ph2_path, this.engine.params.ph2_T, nArray, this.engine.params.DLEN_2, this.engine.params.ELL2_W, this.engine.params.W_2);
            } else {
                this.Traverse_w_notdiv_e_fullsigned(lArray, 0, 0, this.engine.params.PLEN_2 - 1, this.engine.params.ph2_path, this.engine.params.ph2_T1, this.engine.params.ph2_T2, nArray, this.engine.params.DLEN_2, n, this.engine.params.ELL2_W, this.engine.params.ELL2_EMODW, this.engine.params.W_2, this.engine.params.OALICE_BITS);
            }
            this.from_base(nArray, lArray2, this.engine.params.DLEN_2, this.engine.params.ELL2_W);
        } else if (n == 3) {
            if (this.engine.params.OBOB_EXPON % this.engine.params.W_3 == 0) {
                this.Traverse_w_div_e_fullsigned(lArray, 0, 0, this.engine.params.PLEN_3 - 1, this.engine.params.ph3_path, this.engine.params.ph3_T, nArray, this.engine.params.DLEN_3, this.engine.params.ELL3_W, this.engine.params.W_3);
            } else {
                this.Traverse_w_notdiv_e_fullsigned(lArray, 0, 0, this.engine.params.PLEN_3 - 1, this.engine.params.ph3_path, this.engine.params.ph3_T1, this.engine.params.ph3_T2, nArray, this.engine.params.DLEN_3, n, this.engine.params.ELL3_W, this.engine.params.ELL3_EMODW, this.engine.params.W_3, this.engine.params.OBOB_EXPON);
            }
            this.from_base(nArray, lArray2, this.engine.params.DLEN_3, this.engine.params.ELL3_W);
        }
    }

    private void from_base(int[] nArray, long[] lArray, int n, int n2) {
        long[] lArray2 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray3 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray4 = new long[this.engine.params.NWORDS_ORDER];
        lArray2[0] = n2;
        if (nArray[n - 1] < 0) {
            lArray3[0] = (long)(-nArray[n - 1]) * lArray2[0];
            if ((n2 & 1) == 0) {
                this.engine.fpx.Montgomery_neg(lArray3, this.engine.params.Alice_order);
                this.engine.fpx.copy_words(lArray3, lArray, this.engine.params.NWORDS_ORDER);
            } else {
                this.engine.fpx.mp_sub(this.engine.params.Bob_order, lArray3, lArray, this.engine.params.NWORDS_ORDER);
            }
        } else {
            lArray[0] = (long)nArray[n - 1] * lArray2[0];
        }
        for (int i = n - 2; i >= 1; --i) {
            int n3 = n2;
            Arrays.fill(lArray3, 0L);
            if (nArray[i] < 0) {
                lArray3[0] = -nArray[i];
                if ((n2 & 1) == 0) {
                    this.engine.fpx.Montgomery_neg(lArray3, this.engine.params.Alice_order);
                } else {
                    this.engine.fpx.mp_sub(this.engine.params.Bob_order, lArray3, lArray3, this.engine.params.NWORDS_ORDER);
                }
            } else {
                lArray3[0] = nArray[i];
            }
            this.engine.fpx.mp_add(lArray, lArray3, lArray, this.engine.params.NWORDS_ORDER);
            if ((n2 & 1) != 0 && !this.engine.fpx.is_orderelm_lt(lArray, this.engine.params.Bob_order)) {
                this.engine.fpx.mp_sub(lArray, this.engine.params.Bob_order, lArray, this.engine.params.NWORDS_ORDER);
            }
            if ((n2 & 1) == 0) {
                while (n3 > 1) {
                    this.engine.fpx.mp_add(lArray, lArray, lArray, this.engine.params.NWORDS_ORDER);
                    n3 /= 2;
                }
                continue;
            }
            while (n3 > 1) {
                Arrays.fill(lArray4, 0L);
                this.engine.fpx.mp_add(lArray, lArray, lArray4, this.engine.params.NWORDS_ORDER);
                if (!this.engine.fpx.is_orderelm_lt(lArray4, this.engine.params.Bob_order)) {
                    this.engine.fpx.mp_sub(lArray4, this.engine.params.Bob_order, lArray4, this.engine.params.NWORDS_ORDER);
                }
                this.engine.fpx.mp_add(lArray, lArray4, lArray, this.engine.params.NWORDS_ORDER);
                if (!this.engine.fpx.is_orderelm_lt(lArray, this.engine.params.Bob_order)) {
                    this.engine.fpx.mp_sub(lArray, this.engine.params.Bob_order, lArray, this.engine.params.NWORDS_ORDER);
                }
                n3 /= 3;
            }
        }
        Arrays.fill(lArray3, 0L);
        if (nArray[0] < 0) {
            lArray3[0] = -nArray[0];
            if ((n2 & 1) == 0) {
                this.engine.fpx.Montgomery_neg(lArray3, this.engine.params.Alice_order);
            } else {
                this.engine.fpx.mp_sub(this.engine.params.Bob_order, lArray3, lArray3, this.engine.params.NWORDS_ORDER);
            }
        } else {
            lArray3[0] = nArray[0];
        }
        this.engine.fpx.mp_add(lArray, lArray3, lArray, this.engine.params.NWORDS_ORDER);
        if ((n2 & 1) != 0 && !this.engine.fpx.is_orderelm_lt(lArray, this.engine.params.Bob_order)) {
            this.engine.fpx.mp_sub(lArray, this.engine.params.Bob_order, lArray, this.engine.params.NWORDS_ORDER);
        }
    }

    void Traverse_w_notdiv_e_fullsigned(long[][] lArray, int n, int n2, int n3, int[] nArray, long[] lArray2, long[] lArray3, int[] nArray2, int n4, int n5, int n6, int n7, int n8, int n9) {
        long[][] lArray4 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray5 = new long[2][this.engine.params.NWORDS_FIELD];
        if (n3 > 1) {
            int n10;
            int n11 = nArray[n3];
            this.engine.fpx.fp2copy(lArray, lArray4);
            int n12 = n > 0 ? n8 * (n3 - n11) : n9 % n8 + n8 * (n3 - n11 - 1);
            for (n10 = 0; n10 < n12; ++n10) {
                if ((n5 & 1) == 0) {
                    this.engine.fpx.sqr_Fp2_cycl(lArray4, this.engine.params.Montgomery_one);
                    continue;
                }
                this.engine.fpx.cube_Fp2_cycl(lArray4, this.engine.params.Montgomery_one);
            }
            this.Traverse_w_notdiv_e_fullsigned(lArray4, n + (n3 - n11), n2, n11, nArray, lArray2, lArray3, nArray2, n4, n5, n6, n7, n8, n9);
            this.engine.fpx.fp2copy(lArray, lArray4);
            for (n10 = n2; n10 < n2 + n11; ++n10) {
                if (nArray2[n10] == 0) continue;
                if (n > 0) {
                    if (nArray2[n10] < 0) {
                        this.engine.fpx.fp2copy(lArray3, this.engine.params.NWORDS_FIELD * (2 * (n + n10) * (n6 / 2) + 2 * (-nArray2[n10] - 1)), lArray5);
                        this.engine.fpx.fpnegPRIME(lArray5[1]);
                        this.engine.fpx.fp2mul_mont(lArray4, lArray5, lArray4);
                        continue;
                    }
                    this.engine.fpx.fp2mul_mont(lArray4, lArray3, this.engine.params.NWORDS_FIELD * (2 * ((n + n10) * (n6 / 2) + (nArray2[n10] - 1))), lArray4);
                    continue;
                }
                if (nArray2[n10] < 0) {
                    this.engine.fpx.fp2copy(lArray2, this.engine.params.NWORDS_FIELD * (2 * ((n + n10) * (n6 / 2) + (-nArray2[n10] - 1))), lArray5);
                    this.engine.fpx.fpnegPRIME(lArray5[1]);
                    this.engine.fpx.fp2mul_mont(lArray4, lArray5, lArray4);
                    continue;
                }
                this.engine.fpx.fp2mul_mont(lArray4, lArray2, this.engine.params.NWORDS_FIELD * (2 * ((n + n10) * (n6 / 2) + (nArray2[n10] - 1))), lArray4);
            }
            this.Traverse_w_notdiv_e_fullsigned(lArray4, n, n2 + n11, n3 - n11, nArray, lArray2, lArray3, nArray2, n4, n5, n6, n7, n8, n9);
        } else {
            this.engine.fpx.fp2copy(lArray, lArray4);
            this.engine.fpx.fp2correction(lArray4);
            if (this.engine.fpx.is_felm_zero(lArray4[1]) && Fpx.subarrayEquals(lArray4[0], this.engine.params.Montgomery_one, this.engine.params.NWORDS_FIELD)) {
                nArray2[n2] = 0;
            } else if (n != 0 || n2 != n4 - 1) {
                for (int i = 1; i <= n6 / 2; ++i) {
                    if (Fpx.subarrayEquals(lArray4, lArray3, this.engine.params.NWORDS_FIELD * (2 * (n6 / 2) * (n4 - 1) + 2 * (i - 1)), 2 * this.engine.params.NWORDS_FIELD)) {
                        nArray2[n2] = -i;
                    } else {
                        this.engine.fpx.fp2copy(lArray3, this.engine.params.NWORDS_FIELD * (2 * (n6 / 2 * (n4 - 1) + (i - 1))), lArray5);
                        this.engine.fpx.fpnegPRIME(lArray5[1]);
                        this.engine.fpx.fpcorrectionPRIME(lArray5[1]);
                        if (!Fpx.subarrayEquals(lArray4, lArray5, 2 * this.engine.params.NWORDS_FIELD)) continue;
                        nArray2[n2] = i;
                    }
                    break;
                }
            } else {
                for (int i = 1; i <= n7 / 2; ++i) {
                    if (Fpx.subarrayEquals(lArray4, lArray2, this.engine.params.NWORDS_FIELD * (2 * (n6 / 2) * (n4 - 1) + 2 * (i - 1)), 2 * this.engine.params.NWORDS_FIELD)) {
                        nArray2[n2] = -i;
                    } else {
                        this.engine.fpx.fp2copy(lArray2, this.engine.params.NWORDS_FIELD * (2 * (n6 / 2 * (n4 - 1) + (i - 1))), lArray5);
                        this.engine.fpx.fpnegPRIME(lArray5[1]);
                        this.engine.fpx.fpcorrectionPRIME(lArray5[1]);
                        if (!Fpx.subarrayEquals(lArray4, lArray5, 2 * this.engine.params.NWORDS_FIELD)) continue;
                        nArray2[n2] = i;
                    }
                    break;
                }
            }
        }
    }

    void Traverse_w_div_e_fullsigned(long[][] lArray, int n, int n2, int n3, int[] nArray, long[] lArray2, int[] nArray2, int n4, int n5, int n6) {
        long[][] lArray3 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray4 = new long[2][this.engine.params.NWORDS_FIELD];
        if (n3 > 1) {
            int n7;
            int n8 = nArray[n3];
            this.engine.fpx.fp2copy(lArray, lArray3);
            for (n7 = 0; n7 < n3 - n8; ++n7) {
                int n9;
                if ((n5 & 1) == 0) {
                    for (n9 = 0; n9 < n6; ++n9) {
                        this.engine.fpx.sqr_Fp2_cycl(lArray3, this.engine.params.Montgomery_one);
                    }
                    continue;
                }
                for (n9 = 0; n9 < n6; ++n9) {
                    this.engine.fpx.cube_Fp2_cycl(lArray3, this.engine.params.Montgomery_one);
                }
            }
            this.Traverse_w_div_e_fullsigned(lArray3, n + (n3 - n8), n2, n8, nArray, lArray2, nArray2, n4, n5, n6);
            this.engine.fpx.fp2copy(lArray, lArray3);
            for (n7 = n2; n7 < n2 + n8; ++n7) {
                if (nArray2[n7] == 0) continue;
                if (nArray2[n7] < 0) {
                    this.engine.fpx.fp2copy(lArray2, this.engine.params.NWORDS_FIELD * (2 * ((n + n7) * (n5 / 2) + (-nArray2[n7] - 1))), lArray4);
                    this.engine.fpx.fpnegPRIME(lArray4[1]);
                    this.engine.fpx.fp2mul_mont(lArray3, lArray4, lArray3);
                    continue;
                }
                this.engine.fpx.fp2mul_mont(lArray3, lArray2, this.engine.params.NWORDS_FIELD * (2 * ((n + n7) * (n5 / 2) + (nArray2[n7] - 1))), lArray3);
            }
            this.Traverse_w_div_e_fullsigned(lArray3, n, n2 + n8, n3 - n8, nArray, lArray2, nArray2, n4, n5, n6);
        } else {
            this.engine.fpx.fp2copy(lArray, lArray3);
            this.engine.fpx.fp2correction(lArray3);
            if (this.engine.fpx.is_felm_zero(lArray3[1]) && Fpx.subarrayEquals(lArray3[0], this.engine.params.Montgomery_one, this.engine.params.NWORDS_FIELD)) {
                nArray2[n2] = 0;
            } else {
                for (int i = 1; i <= n5 / 2; ++i) {
                    if (Fpx.subarrayEquals(lArray3, lArray2, this.engine.params.NWORDS_FIELD * (2 * ((n4 - 1) * (n5 / 2) + (i - 1))), 2 * this.engine.params.NWORDS_FIELD)) {
                        nArray2[n2] = -i;
                        break;
                    }
                    this.engine.fpx.fp2copy(lArray2, this.engine.params.NWORDS_FIELD * (2 * ((n4 - 1) * (n5 / 2) + (i - 1))), lArray4);
                    this.engine.fpx.fpnegPRIME(lArray4[1]);
                    this.engine.fpx.fpcorrectionPRIME(lArray4[1]);
                    if (!Fpx.subarrayEquals(lArray3, lArray4, 2 * this.engine.params.NWORDS_FIELD)) continue;
                    nArray2[n2] = i;
                    break;
                }
            }
        }
    }

    private void Tate3_pairings(PointProjFull[] pointProjFullArray, long[][][] lArray) {
        int n;
        long[] lArray2 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray3 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray4 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray5 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray6 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray7 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray8 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray9 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray10 = new long[this.engine.params.NWORDS_FIELD];
        long[][][] lArray11 = new long[2][2][this.engine.params.NWORDS_FIELD];
        long[][][] lArray12 = new long[4][2][this.engine.params.NWORDS_FIELD];
        long[][] lArray13 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray14 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray15 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray16 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray17 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray18 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray19 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray20 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray21 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray22 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, lArray13[0]);
        for (n = 0; n < 2; ++n) {
            this.engine.fpx.fp2copy(lArray13, lArray[n]);
            this.engine.fpx.fp2copy(lArray13, lArray[n + 2]);
            this.engine.fpx.fp2sqr_mont(pointProjFullArray[n].X, lArray11[n]);
        }
        for (n = 0; n < this.engine.params.OBOB_EXPON - 1; ++n) {
            System.arraycopy(this.engine.params.T_tate3, this.engine.params.NWORDS_FIELD * (6 * n + 0), lArray4, 0, this.engine.params.NWORDS_FIELD);
            System.arraycopy(this.engine.params.T_tate3, this.engine.params.NWORDS_FIELD * (6 * n + 1), lArray5, 0, this.engine.params.NWORDS_FIELD);
            System.arraycopy(this.engine.params.T_tate3, this.engine.params.NWORDS_FIELD * (6 * n + 2), lArray6, 0, this.engine.params.NWORDS_FIELD);
            System.arraycopy(this.engine.params.T_tate3, this.engine.params.NWORDS_FIELD * (6 * n + 3), lArray7, 0, this.engine.params.NWORDS_FIELD);
            System.arraycopy(this.engine.params.T_tate3, this.engine.params.NWORDS_FIELD * (6 * n + 4), lArray9, 0, this.engine.params.NWORDS_FIELD);
            System.arraycopy(this.engine.params.T_tate3, this.engine.params.NWORDS_FIELD * (6 * n + 5), lArray10, 0, this.engine.params.NWORDS_FIELD);
            for (int i = 0; i < 2; ++i) {
                this.engine.fpx.fpmul_mont(pointProjFullArray[i].X[0], lArray4, lArray14[0]);
                this.engine.fpx.fpmul_mont(pointProjFullArray[i].X[1], lArray4, lArray14[1]);
                this.engine.fpx.fpmul_mont(pointProjFullArray[i].X[0], lArray5, lArray16[0]);
                this.engine.fpx.fpmul_mont(pointProjFullArray[i].X[1], lArray5, lArray16[1]);
                this.engine.fpx.fpaddPRIME(lArray11[i][0], lArray9, lArray18[0]);
                this.engine.fpx.fpcopy(lArray11[i][1], 0, lArray18[1]);
                this.engine.fpx.fpmul_mont(pointProjFullArray[i].X[0], lArray10, lArray19[0]);
                this.engine.fpx.fpmul_mont(pointProjFullArray[i].X[1], lArray10, lArray19[1]);
                this.engine.fpx.fp2sub(lArray14, pointProjFullArray[i].Y, lArray15);
                this.engine.fpx.fpaddPRIME(lArray15[0], lArray6, lArray15[0]);
                this.engine.fpx.fp2sub(lArray16, pointProjFullArray[i].Y, lArray17);
                this.engine.fpx.fpaddPRIME(lArray17[0], lArray7, lArray17[0]);
                this.engine.fpx.fp2mul_mont(lArray15, lArray17, lArray20);
                this.engine.fpx.fp2sub(lArray18, lArray19, lArray21);
                this.engine.fpx.fp2_conj(lArray21, lArray21);
                this.engine.fpx.fp2mul_mont(lArray20, lArray21, lArray20);
                this.engine.fpx.fp2sqr_mont(lArray[i], lArray22);
                this.engine.fpx.fp2mul_mont(lArray[i], lArray22, lArray[i]);
                this.engine.fpx.fp2mul_mont(lArray[i], lArray20, lArray[i]);
                this.engine.fpx.fpsubPRIME(lArray14[1], pointProjFullArray[i].Y[0], lArray15[0]);
                this.engine.fpx.fpaddPRIME(lArray14[0], pointProjFullArray[i].Y[1], lArray15[1]);
                this.engine.fpx.fpnegPRIME(lArray15[1]);
                this.engine.fpx.fpaddPRIME(lArray15[1], lArray6, lArray15[1]);
                this.engine.fpx.fpsubPRIME(lArray16[1], pointProjFullArray[i].Y[0], lArray17[0]);
                this.engine.fpx.fpaddPRIME(lArray16[0], pointProjFullArray[i].Y[1], lArray17[1]);
                this.engine.fpx.fpnegPRIME(lArray17[1]);
                this.engine.fpx.fpaddPRIME(lArray17[1], lArray7, lArray17[1]);
                this.engine.fpx.fp2mul_mont(lArray15, lArray17, lArray20);
                this.engine.fpx.fp2add(lArray18, lArray19, lArray21);
                this.engine.fpx.fp2_conj(lArray21, lArray21);
                this.engine.fpx.fp2mul_mont(lArray20, lArray21, lArray20);
                this.engine.fpx.fp2sqr_mont(lArray[i + 2], lArray22);
                this.engine.fpx.fp2mul_mont(lArray[i + 2], lArray22, lArray[i + 2]);
                this.engine.fpx.fp2mul_mont(lArray[i + 2], lArray20, lArray[i + 2]);
            }
        }
        for (n = 0; n < 2; ++n) {
            System.arraycopy(this.engine.params.T_tate3, this.engine.params.NWORDS_FIELD * (6 * (this.engine.params.OBOB_EXPON - 1) + 0), lArray2, 0, this.engine.params.NWORDS_FIELD);
            System.arraycopy(this.engine.params.T_tate3, this.engine.params.NWORDS_FIELD * (6 * (this.engine.params.OBOB_EXPON - 1) + 1), lArray3, 0, this.engine.params.NWORDS_FIELD);
            System.arraycopy(this.engine.params.T_tate3, this.engine.params.NWORDS_FIELD * (6 * (this.engine.params.OBOB_EXPON - 1) + 2), lArray4, 0, this.engine.params.NWORDS_FIELD);
            System.arraycopy(this.engine.params.T_tate3, this.engine.params.NWORDS_FIELD * (6 * (this.engine.params.OBOB_EXPON - 1) + 3), lArray8, 0, this.engine.params.NWORDS_FIELD);
            this.engine.fpx.fpsubPRIME(pointProjFullArray[n].X[0], lArray2, lArray14[0]);
            this.engine.fpx.fpcopy(pointProjFullArray[n].X[1], 0, lArray14[1]);
            this.engine.fpx.fpmul_mont(lArray4, lArray14[0], lArray15[0]);
            this.engine.fpx.fpmul_mont(lArray4, lArray14[1], lArray15[1]);
            this.engine.fpx.fp2sub(lArray15, pointProjFullArray[n].Y, lArray16);
            this.engine.fpx.fpaddPRIME(lArray16[0], lArray3, lArray16[0]);
            this.engine.fpx.fp2mul_mont(lArray14, lArray16, lArray20);
            this.engine.fpx.fpsubPRIME(pointProjFullArray[n].X[0], lArray8, lArray21[0]);
            this.engine.fpx.fpcopy(pointProjFullArray[n].X[1], 0, lArray21[1]);
            this.engine.fpx.fpnegPRIME(lArray21[1]);
            this.engine.fpx.fp2mul_mont(lArray20, lArray21, lArray20);
            this.engine.fpx.fp2sqr_mont(lArray[n], lArray22);
            this.engine.fpx.fp2mul_mont(lArray[n], lArray22, lArray[n]);
            this.engine.fpx.fp2mul_mont(lArray[n], lArray20, lArray[n]);
            this.engine.fpx.fpaddPRIME(pointProjFullArray[n].X[0], lArray2, lArray14[0]);
            this.engine.fpx.fpmul_mont(lArray4, lArray14[0], lArray15[0]);
            this.engine.fpx.fpsubPRIME(pointProjFullArray[n].Y[0], lArray15[1], lArray16[0]);
            this.engine.fpx.fpaddPRIME(pointProjFullArray[n].Y[1], lArray15[0], lArray16[1]);
            this.engine.fpx.fpsubPRIME(lArray16[1], lArray3, lArray16[1]);
            this.engine.fpx.fp2mul_mont(lArray14, lArray16, lArray20);
            this.engine.fpx.fpaddPRIME(pointProjFullArray[n].X[0], lArray8, lArray21[0]);
            this.engine.fpx.fp2mul_mont(lArray20, lArray21, lArray20);
            this.engine.fpx.fp2sqr_mont(lArray[n + 2], lArray22);
            this.engine.fpx.fp2mul_mont(lArray[n + 2], lArray22, lArray[n + 2]);
            this.engine.fpx.fp2mul_mont(lArray[n + 2], lArray20, lArray[n + 2]);
        }
        this.engine.fpx.mont_n_way_inv(lArray, 4, lArray12);
        for (n = 0; n < 4; ++n) {
            this.final_exponentiation_3_torsion(lArray[n], lArray12[n], lArray[n]);
        }
    }

    private void final_exponentiation_3_torsion(long[][] lArray, long[][] lArray2, long[][] lArray3) {
        long[] lArray4 = new long[this.engine.params.NWORDS_FIELD];
        long[][] lArray5 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, lArray4);
        this.engine.fpx.fp2_conj(lArray, lArray5);
        this.engine.fpx.fp2mul_mont(lArray5, lArray2, lArray5);
        for (int i = 0; i < this.engine.params.OALICE_BITS; ++i) {
            this.engine.fpx.sqr_Fp2_cycl(lArray5, lArray4);
        }
        this.engine.fpx.fp2copy(lArray5, lArray3);
    }

    private void Tate2_pairings(PointProj pointProj, PointProj pointProj2, PointProjFull[] pointProjFullArray, long[][][] lArray) {
        int n;
        int n2;
        long[] lArray2;
        int n3;
        long[][][] lArray3 = new long[4][2][this.engine.params.NWORDS_FIELD];
        long[][] lArray4 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray5 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray6 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray7 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray8 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray9 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, lArray4[0]);
        for (n3 = 0; n3 < 2; ++n3) {
            this.engine.fpx.fp2copy(lArray4, lArray[n3]);
            this.engine.fpx.fp2copy(lArray4, lArray[n3 + 2]);
        }
        long[][] lArray10 = pointProj.X;
        long[][] lArray11 = pointProj.Z;
        int n4 = 0;
        int n5 = 1;
        long[] lArray12 = this.engine.params.T_tate2_firststep_P;
        long[] lArray13 = this.engine.params.T_tate2_firststep_P;
        this.engine.fpx.fpcopy(this.engine.params.T_tate2_firststep_P, 2 * this.engine.params.NWORDS_FIELD, lArray5[0]);
        this.engine.fpx.fpcopy(this.engine.params.T_tate2_firststep_P, 3 * this.engine.params.NWORDS_FIELD, lArray5[1]);
        for (n3 = 0; n3 < 2; ++n3) {
            this.engine.fpx.fp2sub(pointProjFullArray[n3].X, lArray10, lArray6);
            this.engine.fpx.fp2sub(pointProjFullArray[n3].Y, lArray11, lArray7);
            this.engine.fpx.fp2mul_mont(lArray5, lArray6, lArray6);
            this.engine.fpx.fp2sub(lArray6, lArray7, lArray8);
            this.engine.fpx.fpsubPRIME(pointProjFullArray[n3].X[0], this.engine.params.T_tate2_firststep_P, n4, lArray9[0]);
            this.engine.fpx.fpcopy(pointProjFullArray[n3].X[1], 0, lArray9[1]);
            this.engine.fpx.fpnegPRIME(lArray9[1]);
            this.engine.fpx.fp2mul_mont(lArray8, lArray9, lArray8);
            this.engine.fpx.fp2sqr_mont(lArray[n3], lArray[n3]);
            this.engine.fpx.fp2mul_mont(lArray[n3], lArray8, lArray[n3]);
        }
        int n6 = 0;
        int n7 = 1 * this.engine.params.NWORDS_FIELD;
        long[] lArray14 = lArray12;
        long[] lArray15 = lArray13;
        for (n3 = 0; n3 < this.engine.params.OALICE_BITS - 2; ++n3) {
            lArray12 = this.engine.params.T_tate2_P;
            lArray13 = this.engine.params.T_tate2_P;
            lArray2 = this.engine.params.T_tate2_P;
            n4 = this.engine.params.NWORDS_FIELD * (3 * n3 + 0);
            n5 = this.engine.params.NWORDS_FIELD * (3 * n3 + 1);
            n2 = this.engine.params.NWORDS_FIELD * (3 * n3 + 2);
            for (n = 0; n < 2; ++n) {
                this.engine.fpx.fpsubPRIME(lArray14, n6, pointProjFullArray[n].X[0], lArray6[1]);
                this.engine.fpx.fpmul_mont(lArray2, n2, lArray6[1], lArray6[1]);
                this.engine.fpx.fpmul_mont(lArray2, n2, pointProjFullArray[n].X[1], lArray6[0]);
                this.engine.fpx.fpsubPRIME(pointProjFullArray[n].Y[1], lArray15, n7, lArray7[1]);
                this.engine.fpx.fpsubPRIME(lArray6[1], lArray7[1], lArray8[1]);
                this.engine.fpx.fpsubPRIME(lArray6[0], pointProjFullArray[n].Y[0], lArray8[0]);
                this.engine.fpx.fpsubPRIME(pointProjFullArray[n].X[0], lArray12, n4, lArray9[0]);
                this.engine.fpx.fpcopy(pointProjFullArray[n].X[1], 0, lArray9[1]);
                this.engine.fpx.fpnegPRIME(lArray9[1]);
                this.engine.fpx.fp2mul_mont(lArray8, lArray9, lArray8);
                this.engine.fpx.fp2sqr_mont(lArray[n], lArray[n]);
                this.engine.fpx.fp2mul_mont(lArray[n], lArray8, lArray[n]);
            }
            lArray14 = lArray12;
            lArray15 = lArray13;
            n7 = n5;
            n6 = n4;
        }
        for (n3 = 0; n3 < 2; ++n3) {
            this.engine.fpx.fpsubPRIME(pointProjFullArray[n3].X[0], lArray14, n6, lArray8[0]);
            this.engine.fpx.fpcopy(pointProjFullArray[n3].X[1], 0, lArray8[1]);
            this.engine.fpx.fp2sqr_mont(lArray[n3], lArray[n3]);
            this.engine.fpx.fp2mul_mont(lArray[n3], lArray8, lArray[n3]);
        }
        lArray10 = pointProj2.X;
        lArray11 = pointProj2.Z;
        lArray12 = this.engine.params.T_tate2_firststep_Q;
        lArray13 = this.engine.params.T_tate2_firststep_Q;
        n4 = 0;
        n5 = 1 * this.engine.params.NWORDS_FIELD;
        this.engine.fpx.fpcopy(this.engine.params.T_tate2_firststep_Q, 2 * this.engine.params.NWORDS_FIELD, lArray5[0]);
        this.engine.fpx.fpcopy(this.engine.params.T_tate2_firststep_Q, 3 * this.engine.params.NWORDS_FIELD, lArray5[1]);
        for (n3 = 0; n3 < 2; ++n3) {
            this.engine.fpx.fp2sub(pointProjFullArray[n3].X, lArray10, lArray6);
            this.engine.fpx.fp2sub(pointProjFullArray[n3].Y, lArray11, lArray7);
            this.engine.fpx.fp2mul_mont(lArray5, lArray6, lArray6);
            this.engine.fpx.fp2sub(lArray6, lArray7, lArray8);
            this.engine.fpx.fpsubPRIME(pointProjFullArray[n3].X[0], lArray12, n4, lArray9[0]);
            this.engine.fpx.fpcopy(pointProjFullArray[n3].X[1], 0, lArray9[1]);
            this.engine.fpx.fpnegPRIME(lArray9[1]);
            this.engine.fpx.fp2mul_mont(lArray8, lArray9, lArray8);
            this.engine.fpx.fp2sqr_mont(lArray[n3 + 2], lArray[n3 + 2]);
            this.engine.fpx.fp2mul_mont(lArray[n3 + 2], lArray8, lArray[n3 + 2]);
        }
        lArray14 = lArray12;
        lArray15 = lArray13;
        n7 = n5;
        n6 = n4;
        for (n3 = 0; n3 < this.engine.params.OALICE_BITS - 2; ++n3) {
            lArray12 = this.engine.params.T_tate2_Q;
            lArray13 = this.engine.params.T_tate2_Q;
            lArray2 = this.engine.params.T_tate2_Q;
            n4 = this.engine.params.NWORDS_FIELD * (3 * n3 + 0);
            n5 = this.engine.params.NWORDS_FIELD * (3 * n3 + 1);
            n2 = this.engine.params.NWORDS_FIELD * (3 * n3 + 2);
            for (n = 0; n < 2; ++n) {
                this.engine.fpx.fpsubPRIME(pointProjFullArray[n].X[0], lArray14, n6, lArray6[0]);
                this.engine.fpx.fpmul_mont(lArray2, n2, lArray6[0], lArray6[0]);
                this.engine.fpx.fpmul_mont(lArray2, n2, pointProjFullArray[n].X[1], lArray6[1]);
                this.engine.fpx.fpsubPRIME(pointProjFullArray[n].Y[0], lArray15, n7, lArray7[0]);
                this.engine.fpx.fpsubPRIME(lArray6[0], lArray7[0], lArray8[0]);
                this.engine.fpx.fpsubPRIME(lArray6[1], pointProjFullArray[n].Y[1], lArray8[1]);
                this.engine.fpx.fpsubPRIME(pointProjFullArray[n].X[0], lArray12, n4, lArray9[0]);
                this.engine.fpx.fpcopy(pointProjFullArray[n].X[1], 0, lArray9[1]);
                this.engine.fpx.fpnegPRIME(lArray9[1]);
                this.engine.fpx.fp2mul_mont(lArray8, lArray9, lArray8);
                this.engine.fpx.fp2sqr_mont(lArray[n + 2], lArray[n + 2]);
                this.engine.fpx.fp2mul_mont(lArray[n + 2], lArray8, lArray[n + 2]);
            }
            lArray14 = lArray12;
            lArray15 = lArray13;
            n7 = n5;
            n6 = n4;
        }
        for (n3 = 0; n3 < 2; ++n3) {
            this.engine.fpx.fpsubPRIME(pointProjFullArray[n3].X[0], lArray14, n6, lArray8[0]);
            this.engine.fpx.fpcopy(pointProjFullArray[n3].X[1], 0, lArray8[1]);
            this.engine.fpx.fp2sqr_mont(lArray[n3 + 2], lArray[n3 + 2]);
            this.engine.fpx.fp2mul_mont(lArray[n3 + 2], lArray8, lArray[n3 + 2]);
        }
        this.engine.fpx.mont_n_way_inv(lArray, 4, lArray3);
        for (n3 = 0; n3 < 4; ++n3) {
            this.final_exponentiation_2_torsion(lArray[n3], lArray3[n3], lArray[n3]);
        }
    }

    private void final_exponentiation_2_torsion(long[][] lArray, long[][] lArray2, long[][] lArray3) {
        long[] lArray4 = new long[this.engine.params.NWORDS_FIELD];
        long[][] lArray5 = new long[2][this.engine.params.NWORDS_FIELD];
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, lArray4);
        this.engine.fpx.fp2_conj(lArray, lArray5);
        this.engine.fpx.fp2mul_mont(lArray5, lArray2, lArray5);
        for (int i = 0; i < this.engine.params.OBOB_EXPON; ++i) {
            this.engine.fpx.cube_Fp2_cycl(lArray5, lArray4);
        }
        this.engine.fpx.fp2copy(lArray5, lArray3);
    }
}

