/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.CryptoServiceProperties;
import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.SavableDigestXof;
import org.bouncycastle.crypto.digests.Utils;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.dispose.NativeDisposer;
import org.bouncycastle.util.dispose.NativeReference;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SHAKENativeDigest
implements SavableDigestXof {
    private final CryptoServicePurpose purpose;
    protected DigestRefWrapper nativeRef = null;
    private int bitLen;

    public SHAKENativeDigest(CryptoServicePurpose purpose) {
        this(128, purpose);
    }

    public SHAKENativeDigest(int bitLen, CryptoServicePurpose purpose) {
        if (!CryptoServicesRegistrar.hasEnabledService("SHA3")) {
            throw new IllegalStateException("no native SHAKE support");
        }
        this.purpose = purpose;
        this.bitLen = bitLen;
        this.nativeRef = new DigestRefWrapper(SHAKENativeDigest.makeNative(bitLen));
        this.reset();
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
    }

    public SHAKENativeDigest(int bitLen) {
        this(bitLen, CryptoServicePurpose.ANY);
    }

    public SHAKENativeDigest() {
        this(CryptoServicePurpose.ANY);
    }

    public SHAKENativeDigest(SHAKENativeDigest src) {
        this(CryptoServicePurpose.ANY);
        byte[] state = src.getEncodedState();
        SHAKENativeDigest.restoreFullState(this.nativeRef.getReference(), state, 0);
    }

    public SHAKENativeDigest(byte[] encoded, CryptoServicePurpose purpose) {
        this(purpose);
        SHAKENativeDigest.restoreFullState(this.nativeRef.getReference(), encoded, 0);
    }

    public SHAKENativeDigest(byte[] encoded) {
        this();
        SHAKENativeDigest.restoreFullState(this.nativeRef.getReference(), encoded, 0);
    }

    SHAKENativeDigest restoreState(byte[] state, int offset) {
        SHAKENativeDigest.restoreFullState(this.nativeRef.getReference(), state, offset);
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return "SHAKE" + this.bitLen;
    }

    @Override
    public int getDigestSize() {
        return SHAKENativeDigest.getDigestSize(this.nativeRef.getReference());
    }

    @Override
    public void update(byte in) {
        SHAKENativeDigest.update(this.nativeRef.getReference(), in);
    }

    @Override
    public void update(byte[] input, int inOff, int len) {
        SHAKENativeDigest.update(this.nativeRef.getReference(), input, inOff, len);
    }

    @Override
    public int doFinal(byte[] output, int outOff) {
        int i = SHAKENativeDigest.doFinal(this.nativeRef.getReference(), output, outOff);
        return i;
    }

    @Override
    public int doFinal(byte[] out, int outOff, int outLen) {
        int i = SHAKENativeDigest.doFinal(this.nativeRef.getReference(), out, outOff, outLen);
        return i;
    }

    @Override
    public int doOutput(byte[] out, int outOff, int outLen) {
        return SHAKENativeDigest.doOutput(this.nativeRef.getReference(), out, outOff, outLen);
    }

    @Override
    public void reset() {
        SHAKENativeDigest.reset(this.nativeRef.getReference());
    }

    @Override
    public int getByteLength() {
        return SHAKENativeDigest.getByteLength(this.nativeRef.getReference());
    }

    @Override
    public Memoable copy() {
        return new SHAKENativeDigest(this);
    }

    @Override
    public void reset(Memoable other) {
        SHAKENativeDigest dig = (SHAKENativeDigest)other;
        SHAKENativeDigest.restoreFullState(this.nativeRef.getReference(), dig.getEncodedState(), 0);
    }

    @Override
    public byte[] getEncodedState() {
        int l = SHAKENativeDigest.encodeFullState(this.nativeRef.getReference(), null, 0);
        byte[] state = new byte[l];
        SHAKENativeDigest.encodeFullState(this.nativeRef.getReference(), state, 0);
        return state;
    }

    void restoreFullState(byte[] encoded, int offset) {
        SHAKENativeDigest.restoreFullState(this.nativeRef.getReference(), encoded, offset);
    }

    public String toString() {
        return "SHAKE[Native]()";
    }

    static native long makeNative(int var0);

    static native void destroy(long var0);

    static native int getDigestSize(long var0);

    static native void update(long var0, byte var2);

    static native void update(long var0, byte[] var2, int var3, int var4);

    static native int doFinal(long var0, byte[] var2, int var3, int var4);

    static native int doFinal(long var0, byte[] var2, int var3);

    static native int doOutput(long var0, byte[] var2, int var3, int var4);

    static native void reset(long var0);

    static native int getByteLength(long var0);

    static native int encodeFullState(long var0, byte[] var2, int var3);

    static native void restoreFullState(long var0, byte[] var2, int var3);

    protected CryptoServiceProperties cryptoServiceProperties() {
        return Utils.getDefaultProperties(this, this.bitLen, this.purpose);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected static class DigestRefWrapper
    extends NativeReference {
        public DigestRefWrapper(long reference) {
            super(reference, "SHAKE");
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Disposer
    extends NativeDisposer {
        Disposer(long ref) {
            super(ref);
        }

        @Override
        protected void dispose(long reference) {
            SHAKENativeDigest.destroy(reference);
        }
    }
}

