/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PacketCipherException;
import org.bouncycastle.crypto.modes.AESCTRModePacketCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;

public class AESNativeCTRPacketCipher
implements AESCTRModePacketCipher {
    @Override
    public int getOutputSize(boolean encryption, CipherParameters parameters, int len) {
        this.checkParameters(parameters);
        return AESNativeCTRPacketCipher.getOutputSize(len);
    }

    @Override
    public int processPacket(boolean encryption, CipherParameters parameters, byte[] input, int inOff, int len, byte[] output, int outOff) throws PacketCipherException {
        int result;
        KeyParameter keyParameter;
        byte[] iv;
        if (parameters instanceof ParametersWithIV) {
            ParametersWithIV ivParam = (ParametersWithIV)parameters;
            iv = Arrays.clone(ivParam.getIV());
            keyParameter = (KeyParameter)ivParam.getParameters();
            if (keyParameter == null) {
                throw PacketCipherException.from(new IllegalStateException("CTR/SIC cipher unitialized."));
            }
        } else {
            throw new IllegalArgumentException("CTR/SIC mode requires ParametersWithIV");
        }
        byte[] key = keyParameter.getKey();
        try {
            result = AESNativeCTRPacketCipher.processPacket(encryption, key, iv, input, inOff, len, output, outOff, output.length - outOff);
        }
        catch (Exception e) {
            throw PacketCipherException.from(e);
        }
        return result;
    }

    static native int getOutputSize(int var0);

    static native int processPacket(boolean var0, byte[] var1, byte[] var2, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8);

    public String toString() {
        return "CTR-PS[Native](AES[Native])";
    }
}

