/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.PacketCipherException;
import org.bouncycastle.crypto.engines.AESNativeCBCPacketCipher;
import org.bouncycastle.crypto.engines.AESPacketCipher;
import org.bouncycastle.crypto.modes.AESCBCModePacketCipher;
import org.bouncycastle.crypto.modes.PacketCipherChecks;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Bytes;

public class AESCBCPacketCipher
implements AESCBCModePacketCipher {
    public static AESCBCModePacketCipher newInstance() {
        if (CryptoServicesRegistrar.hasEnabledService("AES/CBC-PC")) {
            return new AESNativeCBCPacketCipher();
        }
        return new AESCBCPacketCipher();
    }

    @Override
    public int getOutputSize(boolean encryption, CipherParameters parameters, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("input len is negative");
        }
        if (len % 16 != 0) {
            throw new IllegalArgumentException("input len not multiple of block size");
        }
        if (parameters instanceof ParametersWithIV) {
            if (((ParametersWithIV)parameters).getIV().length != 16) {
                throw new IllegalArgumentException("iv must be only 16 bytes");
            }
            parameters = ((ParametersWithIV)parameters).getParameters();
        }
        if (parameters instanceof KeyParameter) {
            PacketCipherChecks.checkKeyLenIllegalArgumentException(((KeyParameter)parameters).getKeyLength());
        }
        return len;
    }

    @Override
    public int processPacket(boolean encryption, CipherParameters parameters, byte[] input, int inOff, int len, byte[] output, int outOff) throws PacketCipherException {
        byte[] ivOwned;
        PacketCipherChecks.checkBoundsInputAndOutputWithBlockSize_16(input, inOff, len, output, outOff);
        if (len == 0) {
            return len;
        }
        int blockCount = len / 16;
        if (parameters instanceof ParametersWithIV) {
            ParametersWithIV ivParam = (ParametersWithIV)parameters;
            ivOwned = Arrays.clone(ivParam.getIV());
            if (ivOwned.length != 16) {
                throw PacketCipherException.from(new IllegalArgumentException("iv must be only 16 bytes"));
            }
            parameters = ((ParametersWithIV)parameters).getParameters();
        } else {
            ivOwned = new byte[16];
        }
        if (!(parameters instanceof KeyParameter)) {
            throw PacketCipherException.from(new IllegalArgumentException("invalid parameter type"));
        }
        KeyParameter kp = (KeyParameter)parameters;
        PacketCipherChecks.checkKeyLength(kp.getKeyLength());
        byte[] keyOwned = Arrays.clone(kp.getKey());
        byte[] s = AESPacketCipher.createS(encryption);
        int[][] workingKey = AESPacketCipher.generateWorkingKey(encryption, keyOwned);
        byte[] cbcV = Arrays.clone(ivOwned);
        byte[] cbcNextV = new byte[16];
        for (int i = 0; i < blockCount; ++i) {
            if (encryption) {
                Bytes.xorTo(16, input, inOff, cbcV, 0);
                AESPacketCipher.processBlock(encryption, workingKey, s, cbcV, 0, output, outOff);
                System.arraycopy(output, outOff, cbcV, 0, cbcV.length);
            } else {
                System.arraycopy(input, inOff, cbcNextV, 0, 16);
                AESPacketCipher.processBlock(encryption, workingKey, s, input, inOff, output, outOff);
                Bytes.xorTo(16, cbcV, 0, output, outOff);
                byte[] tmp = cbcV;
                cbcV = cbcNextV;
                cbcNextV = tmp;
            }
            outOff += 16;
            inOff += 16;
        }
        Arrays.clear(keyOwned);
        Arrays.clear(ivOwned);
        Arrays.clear(cbcNextV);
        Arrays.fill(cbcV, (byte)0);
        Arrays.clear(workingKey);
        Arrays.clear(s);
        return blockCount * 16;
    }

    public String toString() {
        return "CBC-PS[Java](AES[Java])";
    }
}

