/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PacketCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public interface AESCFBModePacketCipher
extends PacketCipher {
    default public void checkCFBParameter(CipherParameters parameters) {
        if (parameters instanceof ParametersWithIV) {
            KeyParameter param = (KeyParameter)((ParametersWithIV)parameters).getParameters();
            if (param == null) {
                throw new IllegalArgumentException("CFB cipher unitialized");
            }
            int keyLen = param.getKeyLength();
            if (keyLen < 16 || keyLen > 32 || (keyLen & 7) != 0) {
                throw new IllegalArgumentException("key must be only 16, 24 or 32 bytes long");
            }
        } else {
            throw new IllegalArgumentException("CFB cipher unitialized");
        }
    }
}

