/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PacketCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;

public interface AESGCMSIVModePacketCipher
extends PacketCipher {
    public static final int NONCELEN = 12;

    default public void checkParameters(CipherParameters parameters) {
        KeyParameter myKey;
        byte[] myNonce;
        if (parameters instanceof AEADParameters) {
            AEADParameters myAEAD = (AEADParameters)parameters;
            myNonce = myAEAD.getNonce();
            myKey = myAEAD.getKey();
        } else if (parameters instanceof ParametersWithIV) {
            ParametersWithIV myParms = (ParametersWithIV)parameters;
            myNonce = Arrays.clone(myParms.getIV());
            myKey = (KeyParameter)myParms.getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to GCM-SIV");
        }
        if (myNonce == null || myNonce.length != 12) {
            throw new IllegalArgumentException("invalid nonce");
        }
        if (myKey == null || myKey.getKeyLength() != 16 && myKey.getKeyLength() != 32) {
            throw new IllegalArgumentException("key must be only 16, 24 or 32 bytes long");
        }
    }
}

