/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class FipsUtils {
    private static final Set<String> FIPS_SUPPORTED_CIPHERSUITES = FipsUtils.createFipsSupportedCipherSuites();

    FipsUtils() {
    }

    private static Set<String> createFipsSupportedCipherSuites() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("TLS_RSA_WITH_3DES_EDE_CBC_SHA");
        hashSet.add("TLS_RSA_WITH_AES_128_CBC_SHA");
        hashSet.add("TLS_RSA_WITH_AES_256_CBC_SHA");
        hashSet.add("TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA");
        hashSet.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA");
        hashSet.add("TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA");
        hashSet.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA");
        hashSet.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA");
        hashSet.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA");
        hashSet.add("TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA");
        hashSet.add("TLS_DHE_DSS_WITH_AES_128_CBC_SHA");
        hashSet.add("TLS_DHE_DSS_WITH_AES_256_CBC_SHA");
        hashSet.add("TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA");
        hashSet.add("TLS_DH_DSS_WITH_AES_128_CBC_SHA");
        hashSet.add("TLS_DH_DSS_WITH_AES_256_CBC_SHA");
        hashSet.add("TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA");
        hashSet.add("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA");
        hashSet.add("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA");
        hashSet.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256");
        hashSet.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256");
        hashSet.add("TLS_RSA_WITH_AES_128_CBC_SHA256");
        hashSet.add("TLS_RSA_WITH_AES_256_CBC_SHA256");
        hashSet.add("TLS_RSA_WITH_AES_128_CCM");
        hashSet.add("TLS_RSA_WITH_AES_256_CCM");
        hashSet.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384");
        hashSet.add("TLS_DHE_DSS_WITH_AES_128_CBC_SHA256");
        hashSet.add("TLS_DHE_DSS_WITH_AES_256_CBC_SHA256");
        hashSet.add("TLS_DH_DSS_WITH_AES_128_CBC_SHA256");
        hashSet.add("TLS_DH_DSS_WITH_AES_256_CBC_SHA256");
        hashSet.add("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256");
        hashSet.add("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384");
        return Collections.unmodifiableSet(hashSet);
    }

    static int getFipsMaximumCurveBits() {
        return 384;
    }

    static boolean isFipsCipherSuite(String string) {
        return string != null && FIPS_SUPPORTED_CIPHERSUITES.contains(string);
    }

    static boolean isFipsCurve(int n) {
        switch (n) {
            case 23: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    static void removeNonFipsCipherSuites(Collection<String> collection) {
        collection.retainAll(FIPS_SUPPORTED_CIPHERSUITES);
    }
}

