/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvExtendedSSLSession;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.tls.SessionID;
import org.bouncycastle.tls.TlsSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvSSLSessionContext
implements SSLSessionContext {
    static final boolean hasExtendedSSLSession;
    protected final Map<SessionID, ProvSSLSession> sessionMap = Collections.synchronizedMap(new HashMap());
    protected final ProvSSLContextSpi sslContext;
    protected int sessionCacheSize = 0;
    protected int sessionTimeout = 0;

    ProvSSLSessionContext(ProvSSLContextSpi provSSLContextSpi) {
        this.sslContext = provSSLContextSpi;
    }

    ProvSSLContextSpi getSSLContext() {
        return this.sslContext;
    }

    SSLSession reportSession(TlsSession tlsSession) {
        ProvSSLSession provSSLSession = new ProvSSLSession(this, tlsSession);
        if (hasExtendedSSLSession) {
            return new ProvExtendedSSLSession(provSSLSession);
        }
        return provSSLSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<byte[]> getIds() {
        Map<SessionID, ProvSSLSession> map = this.sessionMap;
        synchronized (map) {
            Set<SessionID> set = this.sessionMap.keySet();
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>(set.size());
            for (SessionID sessionID : set) {
                arrayList.add(sessionID.getBytes());
            }
            return Collections.enumeration(arrayList);
        }
    }

    @Override
    public SSLSession getSession(byte[] byArray) {
        SessionID sessionID = new SessionID(byArray);
        ProvSSLSession provSSLSession = this.sessionMap.get(sessionID);
        return provSSLSession;
    }

    @Override
    public synchronized int getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    @Override
    public synchronized int getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    public synchronized void setSessionCacheSize(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("'size' cannot be < 0");
        }
        this.sessionCacheSize = n;
    }

    @Override
    public synchronized void setSessionTimeout(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("'seconds' cannot be < 0");
        }
        this.sessionTimeout = n;
    }

    static {
        Class clazz = null;
        try {
            clazz = JsseUtils.loadClass(ProvSSLSessionContext.class, "javax.net.ssl.ExtendedSSLSession");
        }
        catch (Exception exception) {
            clazz = null;
        }
        hasExtendedSSLSession = clazz != null;
    }
}

