/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.tls.TlsDHConfigVerifier;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.DHGroup;
import org.bouncycastle.tls.crypto.DHStandardGroups;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.util.BigIntegers;

public class TlsDHUtils {
    public static boolean containsDHECipherSuites(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (!TlsDHUtils.isDHECipherSuite(nArray[i])) continue;
            return true;
        }
        return false;
    }

    public static DHGroup getDHGroup(TlsDHConfig tlsDHConfig) {
        int n = tlsDHConfig.getNamedGroup();
        if (n >= 0) {
            return TlsDHUtils.getNamedDHGroup(n);
        }
        return tlsDHConfig.getExplicitGroup();
    }

    public static DHGroup getNamedDHGroup(int n) {
        switch (n) {
            case 256: {
                return DHStandardGroups.rfc7919_ffdhe2048;
            }
            case 257: {
                return DHStandardGroups.rfc7919_ffdhe3072;
            }
            case 258: {
                return DHStandardGroups.rfc7919_ffdhe4096;
            }
            case 259: {
                return DHStandardGroups.rfc7919_ffdhe6144;
            }
            case 260: {
                return DHStandardGroups.rfc7919_ffdhe8192;
            }
        }
        return null;
    }

    public static boolean isDHECipherSuite(int n) {
        switch (TlsUtils.getKeyExchangeAlgorithm(n)) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public static TlsDHConfig readDHConfig(InputStream inputStream) throws IOException {
        BigInteger bigInteger = TlsDHUtils.readDHParameter(inputStream);
        BigInteger bigInteger2 = TlsDHUtils.readDHParameter(inputStream);
        return new TlsDHConfig(new DHGroup(bigInteger, null, bigInteger2, 0));
    }

    public static TlsDHConfig receiveDHConfig(TlsDHConfigVerifier tlsDHConfigVerifier, InputStream inputStream) throws IOException {
        TlsDHConfig tlsDHConfig = TlsDHUtils.readDHConfig(inputStream);
        if (!tlsDHConfigVerifier.accept(tlsDHConfig)) {
            throw new TlsFatalAlert(71);
        }
        return tlsDHConfig;
    }

    public static BigInteger readDHParameter(InputStream inputStream) throws IOException {
        return new BigInteger(1, TlsUtils.readOpaque16(inputStream));
    }

    public static void writeDHConfig(TlsDHConfig tlsDHConfig, OutputStream outputStream) throws IOException {
        if (tlsDHConfig.getNamedGroup() >= 0) {
            throw new TlsFatalAlert(80);
        }
        DHGroup dHGroup = tlsDHConfig.getExplicitGroup();
        TlsDHUtils.writeDHParameter(dHGroup.getP(), outputStream);
        TlsDHUtils.writeDHParameter(dHGroup.getG(), outputStream);
    }

    public static void writeDHParameter(BigInteger bigInteger, OutputStream outputStream) throws IOException {
        TlsUtils.writeOpaque16(BigIntegers.asUnsignedByteArray((BigInteger)bigInteger), outputStream);
    }
}

