/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsKeyExchange;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DigestInputBuffer;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.ServerSRPParams;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsSRPConfigVerifier;
import org.bouncycastle.tls.TlsSRPLoginParameters;
import org.bouncycastle.tls.TlsSRPUtils;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsSRP6Client;
import org.bouncycastle.tls.crypto.TlsSRP6Server;
import org.bouncycastle.tls.crypto.TlsSRPConfig;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.io.TeeInputStream;

public class TlsSRPKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsSRPConfigVerifier srpConfigVerifier;
    protected byte[] identity;
    protected byte[] password;
    protected TlsSRPConfig srpConfig = null;
    protected TlsSRP6Client srpClient = null;
    protected TlsSRP6Server srpServer = null;
    protected BigInteger srpPeerCredentials = null;
    protected BigInteger srpVerifier = null;
    protected byte[] srpSalt = null;
    protected TlsCredentialedSigner serverCredentials = null;
    protected TlsVerifier verifier = null;

    private static int checkKeyExchange(int n) {
        switch (n) {
            case 21: 
            case 22: 
            case 23: {
                return n;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsSRPKeyExchange(int n, Vector vector, TlsSRPConfigVerifier tlsSRPConfigVerifier, byte[] byArray, byte[] byArray2) {
        super(TlsSRPKeyExchange.checkKeyExchange(n), vector);
        this.srpConfigVerifier = tlsSRPConfigVerifier;
        this.identity = byArray;
        this.password = byArray2;
    }

    public TlsSRPKeyExchange(int n, Vector vector, byte[] byArray, TlsSRPLoginParameters tlsSRPLoginParameters) {
        super(TlsSRPKeyExchange.checkKeyExchange(n), vector);
        this.identity = byArray;
        this.srpConfig = tlsSRPLoginParameters.getConfig();
        this.srpVerifier = tlsSRPLoginParameters.getVerifier();
        this.srpSalt = tlsSRPLoginParameters.getSalt();
    }

    public void skipServerCredentials() throws IOException {
        if (this.keyExchange != 21) {
            throw new TlsFatalAlert(80);
        }
    }

    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (this.keyExchange == 21) {
            throw new TlsFatalAlert(80);
        }
        if (!(tlsCredentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
        this.serverCredentials = (TlsCredentialedSigner)tlsCredentials;
    }

    public void processServerCertificate(Certificate certificate) throws IOException {
        if (this.keyExchange == 21) {
            throw new TlsFatalAlert(80);
        }
        if (certificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        this.checkServerCertSigAlg(certificate);
        this.verifier = certificate.getCertificateAt(0).createVerifier(TlsUtils.getSignatureAlgorithm(this.keyExchange));
    }

    public boolean requiresServerKeyExchange() {
        return true;
    }

    public byte[] generateServerKeyExchange() throws IOException {
        this.srpServer = this.context.getCrypto().createSRP6Server(this.srpConfig, this.srpVerifier);
        BigInteger bigInteger = this.srpServer.generateServerCredentials();
        BigInteger[] bigIntegerArray = this.srpConfig.getExplicitNG();
        ServerSRPParams serverSRPParams = new ServerSRPParams(bigIntegerArray[0], bigIntegerArray[1], this.srpSalt, bigInteger);
        DigestInputBuffer digestInputBuffer = new DigestInputBuffer();
        serverSRPParams.encode(digestInputBuffer);
        if (this.serverCredentials != null) {
            DigitallySigned digitallySigned = TlsUtils.generateServerKeyExchangeSignature(this.context, this.serverCredentials, digestInputBuffer);
            digitallySigned.encode(digestInputBuffer);
        }
        return digestInputBuffer.toByteArray();
    }

    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        DigestInputBuffer digestInputBuffer = null;
        InputStream inputStream2 = inputStream;
        if (this.keyExchange != 21) {
            digestInputBuffer = new DigestInputBuffer();
            inputStream2 = new TeeInputStream(inputStream, (OutputStream)digestInputBuffer);
        }
        ServerSRPParams serverSRPParams = ServerSRPParams.parse(inputStream2);
        if (digestInputBuffer != null) {
            DigitallySigned digitallySigned = this.parseSignature(inputStream);
            TlsUtils.verifyServerKeyExchangeSignature(this.context, this.verifier, digestInputBuffer, digitallySigned);
        }
        this.srpConfig = new TlsSRPConfig();
        this.srpConfig.setExplicitNG(new BigInteger[]{serverSRPParams.getN(), serverSRPParams.getG()});
        if (!this.srpConfigVerifier.accept(this.srpConfig)) {
            throw new TlsFatalAlert(71);
        }
        this.srpSalt = serverSRPParams.getS();
        this.srpPeerCredentials = TlsSRPKeyExchange.validatePublicValue(serverSRPParams.getN(), serverSRPParams.getB());
        this.srpClient = this.context.getCrypto().createSRP6Client(this.srpConfig);
    }

    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        throw new TlsFatalAlert(10);
    }

    public void processClientCredentials(TlsCredentials tlsCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void generateClientKeyExchange(OutputStream outputStream) throws IOException {
        BigInteger bigInteger = this.srpClient.generateClientCredentials(this.srpSalt, this.identity, this.password);
        TlsSRPUtils.writeSRPParameter(bigInteger, outputStream);
        this.context.getSecurityParameters().srpIdentity = Arrays.clone((byte[])this.identity);
    }

    public void processClientKeyExchange(InputStream inputStream) throws IOException {
        this.srpPeerCredentials = TlsSRPKeyExchange.validatePublicValue(this.srpConfig.getExplicitNG()[0], TlsSRPUtils.readSRPParameter(inputStream));
        this.context.getSecurityParameters().srpIdentity = Arrays.clone((byte[])this.identity);
    }

    public TlsSecret generatePreMasterSecret() throws IOException {
        BigInteger bigInteger = this.srpServer != null ? this.srpServer.calculateSecret(this.srpPeerCredentials) : this.srpClient.calculateSecret(this.srpPeerCredentials);
        return this.context.getCrypto().createSecret(BigIntegers.asUnsignedByteArray((BigInteger)bigInteger));
    }

    public static BigInteger validatePublicValue(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
        if ((bigInteger2 = bigInteger2.mod(bigInteger)).equals(BigInteger.ZERO)) {
            throw new TlsFatalAlert(47);
        }
        return bigInteger2;
    }
}

