/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.impl.TlsSuiteMac;
import org.bouncycastle.util.Arrays;

class TlsSuiteHMac
implements TlsSuiteMac {
    protected TlsCryptoParameters cryptoParams;
    protected byte[] secret;
    protected TlsHMAC mac;
    protected int digestBlockSize;
    protected int digestOverhead;
    protected int macLength;

    public TlsSuiteHMac(TlsCryptoParameters tlsCryptoParameters, TlsHMAC tlsHMAC) {
        this.cryptoParams = tlsCryptoParameters;
        this.digestBlockSize = tlsHMAC.getInternalBlockSize();
        this.digestOverhead = this.digestBlockSize / 8;
        this.mac = tlsHMAC;
    }

    public void setKey(byte[] byArray) throws IOException {
        this.secret = Arrays.clone((byte[])byArray);
        this.mac.setKey(this.secret);
        this.macLength = this.mac.getMacLength();
        if (this.cryptoParams.getSecurityParameters().isTruncatedHMac()) {
            this.macLength = Math.min(this.macLength, 10);
        }
    }

    public byte[] getMACSecret() {
        return this.secret;
    }

    public int getSize() {
        return this.macLength;
    }

    public byte[] calculateMac(long l, short s, byte[] byArray, int n, int n2) {
        ProtocolVersion protocolVersion = this.cryptoParams.getServerVersion();
        byte[] byArray2 = new byte[13];
        TlsUtils.writeUint64(l, byArray2, 0);
        TlsUtils.writeUint8(s, byArray2, 8);
        TlsUtils.writeVersion(protocolVersion, byArray2, 9);
        TlsUtils.writeUint16(n2, byArray2, byArray2.length - 2);
        this.mac.update(byArray2, 0, byArray2.length);
        this.mac.update(byArray, n, n2);
        return this.truncate(this.mac.calculateMAC());
    }

    public byte[] calculateMacConstantTime(long l, short s, byte[] byArray, int n, int n2, int n3, byte[] byArray2) {
        byte[] byArray3 = this.calculateMac(l, s, byArray, n, n2);
        int n4 = 13;
        int n5 = this.getDigestBlockCount(n4 + n3) - this.getDigestBlockCount(n4 + n2);
        while (--n5 >= 0) {
            this.mac.update(byArray2, 0, this.digestBlockSize);
        }
        this.mac.update(byArray2, 0, 1);
        this.mac.reset();
        return byArray3;
    }

    protected int getDigestBlockCount(int n) {
        return (n + this.digestOverhead) / this.digestBlockSize;
    }

    protected byte[] truncate(byte[] byArray) {
        if (byArray.length <= this.macLength) {
            return byArray;
        }
        return Arrays.copyOf((byte[])byArray, (int)this.macLength);
    }
}

