/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import javax.crypto.KeyAgreement;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsECDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsECDH;

public class JceTlsECDomain
implements TlsECDomain {
    protected JcaTlsCrypto crypto;
    protected TlsECConfig ecConfig;
    protected ECGenParameterSpec ecGenSpec;
    protected ECParameterSpec ecParameterSpec;
    protected ECCurve ecCurve;

    public JceTlsECDomain(JcaTlsCrypto jcaTlsCrypto, TlsECConfig tlsECConfig) {
        this.crypto = jcaTlsCrypto;
        this.ecConfig = tlsECConfig;
        this.init(tlsECConfig.getNamedGroup());
    }

    public byte[] calculateECDHAgreement(ECPublicKey eCPublicKey, ECPrivateKey eCPrivateKey) throws GeneralSecurityException {
        KeyAgreement keyAgreement = this.crypto.getHelper().createKeyAgreement("ECDH");
        keyAgreement.init(eCPrivateKey);
        keyAgreement.doPhase(eCPublicKey, true);
        return keyAgreement.generateSecret("TlsPremasterSecret").getEncoded();
    }

    public TlsAgreement createECDH() {
        return new JceTlsECDH(this);
    }

    public org.bouncycastle.math.ec.ECPoint decodePoint(byte[] byArray) throws IOException {
        return this.ecCurve.decodePoint(byArray);
    }

    public ECPublicKey decodePublicKey(byte[] byArray) throws IOException {
        try {
            KeyFactory keyFactory = this.crypto.getHelper().createKeyFactory("EC");
            org.bouncycastle.math.ec.ECPoint eCPoint = this.decodePoint(byArray);
            ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(new ECPoint(eCPoint.getAffineXCoord().toBigInteger(), eCPoint.getAffineYCoord().toBigInteger()), this.ecParameterSpec);
            return (ECPublicKey)keyFactory.generatePublic(eCPublicKeySpec);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(47, (Throwable)exception);
        }
    }

    public byte[] encodePoint(org.bouncycastle.math.ec.ECPoint eCPoint) throws IOException {
        return eCPoint.getEncoded(this.ecConfig.getPointCompression());
    }

    public byte[] encodePublicKey(ECPublicKey eCPublicKey) throws IOException {
        ECPoint eCPoint = eCPublicKey.getW();
        return this.encodePoint(this.ecCurve.createPoint(eCPoint.getAffineX(), eCPoint.getAffineY()));
    }

    public KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = this.crypto.getHelper().createKeyPairGenerator("EC");
            keyPairGenerator.initialize(this.ecGenSpec, this.crypto.getSecureRandom());
            return keyPairGenerator.generateKeyPair();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException("unable to create key pair: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    public JcaTlsCrypto getCrypto() {
        return this.crypto;
    }

    private void init(int n) {
        this.ecCurve = null;
        this.ecGenSpec = null;
        this.ecParameterSpec = null;
        if (!NamedGroup.refersToASpecificCurve(n)) {
            return;
        }
        String string = NamedGroup.getName(n);
        if (string == null) {
            return;
        }
        try {
            AlgorithmParameters algorithmParameters = this.crypto.getHelper().createAlgorithmParameters("EC");
            this.ecGenSpec = new ECGenParameterSpec(string);
            try {
                algorithmParameters.init(this.ecGenSpec);
                ECParameterSpec eCParameterSpec = algorithmParameters.getParameterSpec(ECParameterSpec.class);
                this.ecCurve = JceTlsECDomain.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getOrder(), eCParameterSpec.getCofactor());
                this.ecParameterSpec = eCParameterSpec;
            }
            catch (Exception exception) {
                KeyPairGenerator keyPairGenerator = this.crypto.getHelper().createKeyPairGenerator("EC");
                keyPairGenerator.initialize(this.ecGenSpec, this.crypto.getSecureRandom());
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                ECParameterSpec eCParameterSpec = ((ECPrivateKey)keyPair.getPrivate()).getParams();
                this.ecCurve = JceTlsECDomain.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getOrder(), eCParameterSpec.getCofactor());
                this.ecParameterSpec = eCParameterSpec;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException("unable to create key pair: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    private static ECCurve convertCurve(EllipticCurve ellipticCurve, BigInteger bigInteger, int n) {
        ECField eCField = ellipticCurve.getField();
        BigInteger bigInteger2 = ellipticCurve.getA();
        BigInteger bigInteger3 = ellipticCurve.getB();
        if (eCField instanceof ECFieldFp) {
            ECCurve.Fp fp = new ECCurve.Fp(((ECFieldFp)eCField).getP(), bigInteger2, bigInteger3, bigInteger, BigInteger.valueOf(n));
            return fp;
        }
        ECFieldF2m eCFieldF2m = (ECFieldF2m)eCField;
        int n2 = eCFieldF2m.getM();
        int[] nArray = JceTlsECDomain.convertMidTerms(eCFieldF2m.getMidTermsOfReductionPolynomial());
        return new ECCurve.F2m(n2, nArray[0], nArray[1], nArray[2], bigInteger2, bigInteger3, bigInteger, BigInteger.valueOf(n));
    }

    private static int[] convertMidTerms(int[] nArray) {
        int[] nArray2 = new int[3];
        if (nArray.length == 1) {
            nArray2[0] = nArray[0];
        } else {
            if (nArray.length != 3) {
                throw new IllegalArgumentException("Only Trinomials and pentanomials supported");
            }
            if (nArray[0] < nArray[1] && nArray[0] < nArray[2]) {
                nArray2[0] = nArray[0];
                if (nArray[1] < nArray[2]) {
                    nArray2[1] = nArray[1];
                    nArray2[2] = nArray[2];
                } else {
                    nArray2[1] = nArray[2];
                    nArray2[2] = nArray[1];
                }
            } else if (nArray[1] < nArray[2]) {
                nArray2[0] = nArray[1];
                if (nArray[0] < nArray[2]) {
                    nArray2[1] = nArray[0];
                    nArray2[2] = nArray[2];
                } else {
                    nArray2[1] = nArray[2];
                    nArray2[2] = nArray[0];
                }
            } else {
                nArray2[0] = nArray[2];
                if (nArray[0] < nArray[1]) {
                    nArray2[1] = nArray[0];
                    nArray2[2] = nArray[1];
                } else {
                    nArray2[1] = nArray[1];
                    nArray2[2] = nArray[0];
                }
            }
        }
        return nArray2;
    }
}

