/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.reflect.Constructor;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.auth.x500.X500Principal;
import javax.security.cert.X509Certificate;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.SessionBindingListenerAdapter;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvSSLSessionImpl
implements ProvSSLSession {
    static final Constructor<? extends SSLSession> extendedSessionConstructor;
    protected static final ProvSSLSessionImpl NULL_SESSION;
    protected final Map<String, Object> valueMap = Collections.synchronizedMap(new HashMap());
    protected final ProvSSLSessionContext sslSessionContext;
    protected final TlsSession tlsSession;
    protected final String peerHost;
    protected final int peerPort;
    protected final SessionParameters sessionParameters;
    protected final SSLSession exportSession;
    protected final long creationTime;
    protected long lastAccessedTime;

    static SSLSession makeExportSession(ProvSSLSession provSSLSession) {
        if (extendedSessionConstructor != null) {
            try {
                return extendedSessionConstructor.newInstance(provSSLSession);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return provSSLSession;
    }

    ProvSSLSessionImpl(ProvSSLSessionContext provSSLSessionContext, TlsSession tlsSession, String string, int n) {
        this.sslSessionContext = provSSLSessionContext;
        this.tlsSession = tlsSession;
        this.peerHost = string;
        this.peerPort = n;
        this.sessionParameters = tlsSession == null ? null : tlsSession.exportSessionParameters();
        this.exportSession = ProvSSLSessionImpl.makeExportSession(this);
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
    }

    SSLSession getExportSession() {
        return this.exportSession;
    }

    TlsSession getTlsSession() {
        return this.tlsSession;
    }

    synchronized void accessedAt(long l) {
        this.lastAccessedTime = Math.max(this.lastAccessedTime, l);
    }

    @Override
    public int getApplicationBufferSize() {
        return 16384;
    }

    @Override
    public String getCipherSuite() {
        return this.sessionParameters == null ? null : this.sslSessionContext.getSSLContext().getCipherSuiteString(this.sessionParameters.getCipherSuite());
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public byte[] getId() {
        return this.tlsSession == null ? null : Arrays.clone((byte[])this.tlsSession.getSessionID());
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    @Override
    public Certificate[] getLocalCertificates() {
        Certificate[] certificateArray;
        if (this.sessionParameters != null && (certificateArray = JsseUtils.getX509CertificateChain(this.sslSessionContext.getCrypto(), this.sessionParameters.getLocalCertificate())) != null && certificateArray.length > 0) {
            return certificateArray;
        }
        return null;
    }

    @Override
    public Principal getLocalPrincipal() {
        return this.sessionParameters == null ? null : JsseUtils.getSubject(this.sslSessionContext.getCrypto(), this.sessionParameters.getLocalCertificate());
    }

    @Override
    public String[] getLocalSupportedSignatureAlgorithms() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPacketBufferSize() {
        return 18437;
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        Certificate[] certificateArray = this.getPeerCertificates();
        try {
            X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
            for (int i = 0; i < certificateArray.length; ++i) {
                x509CertificateArray[i] = X509Certificate.getInstance(certificateArray[i].getEncoded());
            }
            return x509CertificateArray;
        }
        catch (Exception exception) {
            throw new SSLPeerUnverifiedException(exception.getMessage());
        }
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        Certificate[] certificateArray;
        if (this.sessionParameters != null && (certificateArray = JsseUtils.getX509CertificateChain(this.sslSessionContext.getCrypto(), this.sessionParameters.getPeerCertificate())) != null && certificateArray.length > 0) {
            return certificateArray;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    @Override
    public String getPeerHost() {
        return this.peerHost;
    }

    @Override
    public int getPeerPort() {
        return this.peerPort;
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        X500Principal x500Principal;
        if (this.sessionParameters != null && (x500Principal = JsseUtils.getSubject(this.sslSessionContext.getCrypto(), this.sessionParameters.getPeerCertificate())) != null) {
            return x500Principal;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    @Override
    public String[] getPeerSupportedSignatureAlgorithms() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getProtocol() {
        return this.sessionParameters == null ? null : this.sslSessionContext.getSSLContext().getProtocolString(this.sessionParameters.getNegotiatedVersion());
    }

    @Override
    public List<BCSNIServerName> getRequestedServerNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SSLSessionContext getSessionContext() {
        return this.sslSessionContext;
    }

    @Override
    public Object getValue(String string) {
        return this.valueMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getValueNames() {
        Map<String, Object> map = this.valueMap;
        synchronized (map) {
            return this.valueMap.keySet().toArray(new String[this.valueMap.size()]);
        }
    }

    @Override
    public void invalidate() {
        if (this.tlsSession != null) {
            this.tlsSession.invalidate();
        }
    }

    @Override
    public boolean isValid() {
        return this.tlsSession != null && this.tlsSession.isResumable();
    }

    @Override
    public void putValue(String string, Object object) {
        this.notifyUnbound(string, this.valueMap.put(string, object));
        this.notifyBound(string, object);
    }

    @Override
    public void removeValue(String string) {
        this.notifyUnbound(string, this.valueMap.remove(string));
    }

    protected void notifyBound(String string, Object object) {
        if (object instanceof SSLSessionBindingListener) {
            new SessionBindingListenerAdapter((SSLSessionBindingListener)object).valueBound(new SSLSessionBindingEvent(this, string));
        }
    }

    protected void notifyUnbound(String string, Object object) {
        if (object instanceof SSLSessionBindingListener) {
            new SessionBindingListenerAdapter((SSLSessionBindingListener)object).valueUnbound(new SSLSessionBindingEvent(this, string));
        }
    }

    static {
        Constructor constructor = null;
        try {
            if (null != JsseUtils.loadClass(ProvSSLSessionImpl.class, "javax.net.ssl.ExtendedSSLSession")) {
                String string = null != JsseUtils.loadClass(ProvSSLSessionImpl.class, "javax.net.ssl.SNIHostName") ? "org.bouncycastle.jsse.provider.ProvExtendedSSLSession_8" : "org.bouncycastle.jsse.provider.ProvExtendedSSLSession_7";
                Class clazz = JsseUtils.loadClass(ProvSSLSessionContext.class, string);
                constructor = JsseUtils.getDeclaredConstructor(clazz, ProvSSLSession.class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        extendedSessionConstructor = constructor;
        NULL_SESSION = new ProvSSLSessionImpl(null, null, null, -1);
    }
}

