/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsPeer;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.CertificateStatusRequest;
import org.bouncycastle.tls.DefaultTlsKeyExchangeFactory;
import org.bouncycastle.tls.MaxFragmentLength;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsCompression;
import org.bouncycastle.tls.TlsECCUtils;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsKeyExchangeFactory;
import org.bouncycastle.tls.TlsNullCompression;
import org.bouncycastle.tls.TlsServer;
import org.bouncycastle.tls.TlsServerContext;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.DHGroup;
import org.bouncycastle.tls.crypto.DHStandardGroups;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.util.Arrays;

public abstract class AbstractTlsServer
extends AbstractTlsPeer
implements TlsServer {
    protected TlsKeyExchangeFactory keyExchangeFactory;
    protected TlsServerContext context;
    protected ProtocolVersion clientVersion;
    protected int[] offeredCipherSuites;
    protected short[] offeredCompressionMethods;
    protected Hashtable clientExtensions;
    protected boolean encryptThenMACOffered;
    protected short maxFragmentLengthOffered;
    protected boolean truncatedHMacOffered;
    protected Vector supportedSignatureAlgorithms;
    protected int[] clientSupportedGroups;
    protected short[] clientECPointFormats;
    protected short[] serverECPointFormats;
    protected CertificateStatusRequest certificateStatusRequest;
    protected ProtocolVersion serverVersion;
    protected int selectedCipherSuite;
    protected short selectedCompressionMethod;
    protected Hashtable serverExtensions;

    public AbstractTlsServer(TlsCrypto tlsCrypto) {
        this(tlsCrypto, new DefaultTlsKeyExchangeFactory());
    }

    public AbstractTlsServer(TlsCrypto tlsCrypto, TlsKeyExchangeFactory tlsKeyExchangeFactory) {
        super(tlsCrypto);
        this.keyExchangeFactory = tlsKeyExchangeFactory;
    }

    protected boolean allowEncryptThenMAC() {
        return true;
    }

    protected boolean allowTruncatedHMac() {
        return false;
    }

    protected Hashtable checkServerExtensions() {
        this.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.serverExtensions);
        return this.serverExtensions;
    }

    protected abstract int[] getCipherSuites();

    protected short[] getCompressionMethods() {
        return new short[]{0};
    }

    protected DHGroup getDHParameters() {
        return DHStandardGroups.rfc7919_ffdhe2048;
    }

    protected ProtocolVersion getMaximumVersion() {
        return ProtocolVersion.TLSv12;
    }

    protected ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.TLSv10;
    }

    protected int getMaximumNegotiableCurveBits() {
        if (this.clientSupportedGroups == null) {
            return NamedGroup.getMaximumCurveBits();
        }
        int n = 0;
        for (int i = 0; i < this.clientSupportedGroups.length; ++i) {
            n = Math.max(n, NamedGroup.getCurveBits(this.clientSupportedGroups[i]));
        }
        return n;
    }

    protected boolean isSelectableCipherSuite(int n, int n2, Vector vector) {
        return Arrays.contains((int[])this.offeredCipherSuites, (int)n) && TlsUtils.isValidCipherSuiteForVersion(n, this.serverVersion) && n2 >= TlsECCUtils.getMinimumCurveBits(n) && TlsUtils.isValidCipherSuiteForSignatureAlgorithms(n, vector);
    }

    protected boolean selectCipherSuite(int n) throws IOException {
        this.selectedCipherSuite = n;
        return true;
    }

    protected int selectCurve(int n) {
        if (this.clientSupportedGroups == null) {
            return this.selectDefaultCurve(n);
        }
        for (int i = 0; i < this.clientSupportedGroups.length; ++i) {
            int n2 = this.clientSupportedGroups[i];
            if (NamedGroup.getCurveBits(n2) < n) continue;
            return n2;
        }
        return -1;
    }

    protected int selectDefaultCurve(int n) {
        return n <= 256 ? 23 : (n <= 384 ? 24 : (n <= 521 ? 25 : -1));
    }

    protected TlsDHConfig selectDHConfig() {
        return new TlsDHConfig(this.getDHParameters());
    }

    protected TlsECConfig selectECConfig() throws IOException {
        int n = TlsECCUtils.getMinimumCurveBits(this.selectedCipherSuite);
        int n2 = this.selectCurve(n);
        if (n2 < 0) {
            throw new TlsFatalAlert(80);
        }
        boolean bl = TlsECCUtils.isCompressionPreferred(this.clientECPointFormats, n2);
        TlsECConfig tlsECConfig = new TlsECConfig();
        tlsECConfig.setNamedGroup(n2);
        tlsECConfig.setPointCompression(bl);
        return tlsECConfig;
    }

    public void init(TlsServerContext tlsServerContext) {
        this.context = tlsServerContext;
    }

    public TlsSession getSessionToResume(byte[] byArray) {
        return null;
    }

    public void notifyClientVersion(ProtocolVersion protocolVersion) throws IOException {
        this.clientVersion = protocolVersion;
    }

    public void notifyFallback(boolean bl) throws IOException {
        if (bl && this.getMaximumVersion().isLaterVersionOf(this.clientVersion)) {
            throw new TlsFatalAlert(86);
        }
    }

    public void notifyOfferedCipherSuites(int[] nArray) throws IOException {
        this.offeredCipherSuites = nArray;
    }

    public void notifyOfferedCompressionMethods(short[] sArray) throws IOException {
        this.offeredCompressionMethods = sArray;
    }

    public void processClientExtensions(Hashtable hashtable) throws IOException {
        this.clientExtensions = hashtable;
        if (hashtable != null) {
            this.encryptThenMACOffered = TlsExtensionsUtils.hasEncryptThenMACExtension(hashtable);
            this.maxFragmentLengthOffered = TlsExtensionsUtils.getMaxFragmentLengthExtension(hashtable);
            if (this.maxFragmentLengthOffered >= 0 && !MaxFragmentLength.isValid(this.maxFragmentLengthOffered)) {
                throw new TlsFatalAlert(47);
            }
            this.truncatedHMacOffered = TlsExtensionsUtils.hasTruncatedHMacExtension(hashtable);
            this.supportedSignatureAlgorithms = TlsUtils.getSignatureAlgorithmsExtension(hashtable);
            if (this.supportedSignatureAlgorithms != null && !TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.clientVersion)) {
                throw new TlsFatalAlert(47);
            }
            this.clientSupportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(hashtable);
            this.clientECPointFormats = TlsECCUtils.getSupportedPointFormatsExtension(hashtable);
            this.certificateStatusRequest = TlsExtensionsUtils.getStatusRequestExtension(hashtable);
        }
    }

    public ProtocolVersion getServerVersion() throws IOException {
        if (this.getMinimumVersion().isEqualOrEarlierVersionOf(this.clientVersion)) {
            ProtocolVersion protocolVersion = this.getMaximumVersion();
            if (this.clientVersion.isEqualOrEarlierVersionOf(protocolVersion)) {
                this.serverVersion = this.clientVersion;
                return this.serverVersion;
            }
            if (this.clientVersion.isLaterVersionOf(protocolVersion)) {
                this.serverVersion = protocolVersion;
                return this.serverVersion;
            }
        }
        throw new TlsFatalAlert(70);
    }

    public int getSelectedCipherSuite() throws IOException {
        Vector vector = TlsUtils.getUsableSignatureAlgorithms(this.supportedSignatureAlgorithms);
        int n = this.getMaximumNegotiableCurveBits();
        int[] nArray = this.getCipherSuites();
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (!this.isSelectableCipherSuite(n2, n, vector) || !this.selectCipherSuite(n2)) continue;
            return n2;
        }
        throw new TlsFatalAlert(40);
    }

    public short getSelectedCompressionMethod() throws IOException {
        short[] sArray = this.getCompressionMethods();
        for (int i = 0; i < sArray.length; ++i) {
            if (!Arrays.contains((short[])this.offeredCompressionMethods, (short)sArray[i])) continue;
            this.selectedCompressionMethod = sArray[i];
            return this.selectedCompressionMethod;
        }
        throw new TlsFatalAlert(40);
    }

    public Hashtable getServerExtensions() throws IOException {
        if (this.encryptThenMACOffered && this.allowEncryptThenMAC() && TlsUtils.isBlockCipherSuite(this.selectedCipherSuite)) {
            TlsExtensionsUtils.addEncryptThenMACExtension(this.checkServerExtensions());
        }
        if (this.maxFragmentLengthOffered >= 0 && MaxFragmentLength.isValid(this.maxFragmentLengthOffered)) {
            TlsExtensionsUtils.addMaxFragmentLengthExtension(this.checkServerExtensions(), this.maxFragmentLengthOffered);
        }
        if (this.truncatedHMacOffered && this.allowTruncatedHMac()) {
            TlsExtensionsUtils.addTruncatedHMacExtension(this.checkServerExtensions());
        }
        if (this.clientECPointFormats != null && TlsECCUtils.isECCipherSuite(this.selectedCipherSuite)) {
            this.serverECPointFormats = new short[]{0, 1, 2};
            TlsECCUtils.addSupportedPointFormatsExtension(this.checkServerExtensions(), this.serverECPointFormats);
        }
        if (this.certificateStatusRequest != null) {
            this.checkServerExtensions().put(TlsExtensionsUtils.EXT_status_request, TlsExtensionsUtils.createEmptyExtensionData());
        }
        return this.serverExtensions;
    }

    public Vector getServerSupplementalData() throws IOException {
        return null;
    }

    public CertificateStatus getCertificateStatus() throws IOException {
        return null;
    }

    public CertificateRequest getCertificateRequest() throws IOException {
        return null;
    }

    public void processClientSupplementalData(Vector vector) throws IOException {
        if (vector != null) {
            throw new TlsFatalAlert(10);
        }
    }

    public void notifyClientCertificate(Certificate certificate) throws IOException {
        throw new TlsFatalAlert(80);
    }

    public TlsCompression getCompression() throws IOException {
        switch (this.selectedCompressionMethod) {
            case 0: {
                return new TlsNullCompression();
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsCipher getCipher() throws IOException {
        int n = TlsUtils.getEncryptionAlgorithm(this.selectedCipherSuite);
        int n2 = TlsUtils.getMACAlgorithm(this.selectedCipherSuite);
        if (n < 0 || n2 < 0) {
            throw new TlsFatalAlert(80);
        }
        return this.context.getSecurityParameters().getMasterSecret().createCipher(new TlsCryptoParameters(this.context), n, n2);
    }

    public NewSessionTicket getNewSessionTicket() throws IOException {
        return new NewSessionTicket(0L, TlsUtils.EMPTY_BYTES);
    }
}

