/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.SignatureAlgorithm;
import org.bouncycastle.tls.TlsUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SignatureAndHashAlgorithm {
    public static final SignatureAndHashAlgorithm ed25519 = new SignatureAndHashAlgorithm(8, 7);
    public static final SignatureAndHashAlgorithm ed448 = new SignatureAndHashAlgorithm(8, 8);
    public static final SignatureAndHashAlgorithm rsa_pss_rsae_sha256 = new SignatureAndHashAlgorithm(8, 4);
    public static final SignatureAndHashAlgorithm rsa_pss_rsae_sha384 = new SignatureAndHashAlgorithm(8, 5);
    public static final SignatureAndHashAlgorithm rsa_pss_rsae_sha512 = new SignatureAndHashAlgorithm(8, 6);
    public static final SignatureAndHashAlgorithm rsa_pss_pss_sha256 = new SignatureAndHashAlgorithm(8, 9);
    public static final SignatureAndHashAlgorithm rsa_pss_pss_sha384 = new SignatureAndHashAlgorithm(8, 10);
    public static final SignatureAndHashAlgorithm rsa_pss_pss_sha512 = new SignatureAndHashAlgorithm(8, 11);
    protected final short hash;
    protected final short signature;

    public static SignatureAndHashAlgorithm getInstance(short hashAlgorithm, short signatureAlgorithm) {
        switch (hashAlgorithm) {
            case 8: {
                return SignatureAndHashAlgorithm.getInstanceIntrinsic(signatureAlgorithm);
            }
        }
        return new SignatureAndHashAlgorithm(hashAlgorithm, signatureAlgorithm);
    }

    public static SignatureAndHashAlgorithm getInstanceIntrinsic(short signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case 7: {
                return ed25519;
            }
            case 8: {
                return ed448;
            }
            case 4: {
                return rsa_pss_rsae_sha256;
            }
            case 5: {
                return rsa_pss_rsae_sha384;
            }
            case 6: {
                return rsa_pss_rsae_sha512;
            }
            case 9: {
                return rsa_pss_pss_sha256;
            }
            case 10: {
                return rsa_pss_pss_sha384;
            }
            case 11: {
                return rsa_pss_pss_sha512;
            }
        }
        return new SignatureAndHashAlgorithm(8, signatureAlgorithm);
    }

    public SignatureAndHashAlgorithm(short hash, short signature) {
        if ((hash & 0xFF) != hash) {
            throw new IllegalArgumentException("'hash' should be a uint8");
        }
        if ((signature & 0xFF) != signature) {
            throw new IllegalArgumentException("'signature' should be a uint8");
        }
        this.hash = hash;
        this.signature = signature;
    }

    public short getHash() {
        return this.hash;
    }

    public short getSignature() {
        return this.signature;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint8(this.getHash(), output);
        TlsUtils.writeUint8(this.getSignature(), output);
    }

    public static SignatureAndHashAlgorithm parse(InputStream input) throws IOException {
        short hash = TlsUtils.readUint8(input);
        short signature = TlsUtils.readUint8(input);
        return SignatureAndHashAlgorithm.getInstance(hash, signature);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SignatureAndHashAlgorithm)) {
            return false;
        }
        SignatureAndHashAlgorithm other = (SignatureAndHashAlgorithm)obj;
        return other.getHash() == this.getHash() && other.getSignature() == this.getSignature();
    }

    public int hashCode() {
        return this.getHash() << 16 | this.getSignature();
    }

    public String toString() {
        return "{" + HashAlgorithm.getText(this.hash) + "," + SignatureAlgorithm.getText(this.signature) + "}";
    }
}

