/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto;

import java.io.IOException;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsSecret;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class TlsCryptoUtils {
    private static final byte[] TLS13_PREFIX = new byte[]{116, 108, 115, 49, 51, 32};

    public static TlsSecret hkdfExpandLabel(TlsSecret secret, short hashAlgorithm, String label, byte[] context, int length) throws IOException {
        int labelLength = label.length();
        if (labelLength < 1) {
            throw new TlsFatalAlert(80);
        }
        int contextLength = context.length;
        int expandedLabelLength = TLS13_PREFIX.length + labelLength;
        byte[] hkdfLabel = new byte[2 + (1 + expandedLabelLength) + (1 + contextLength)];
        TlsUtils.checkUint16(length);
        TlsUtils.writeUint16(length, hkdfLabel, 0);
        TlsUtils.checkUint8(expandedLabelLength);
        TlsUtils.writeUint8(expandedLabelLength, hkdfLabel, 2);
        System.arraycopy(TLS13_PREFIX, 0, hkdfLabel, 3, TLS13_PREFIX.length);
        int labelPos = 2 + (1 + TLS13_PREFIX.length);
        for (int i = 0; i < labelLength; ++i) {
            char c = label.charAt(i);
            hkdfLabel[labelPos + i] = (byte)c;
        }
        TlsUtils.writeOpaque8(context, hkdfLabel, 2 + (1 + expandedLabelLength));
        return secret.hkdfExpand(hashAlgorithm, hkdfLabel, length);
    }
}

