/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.jsse.provider.DefaultSSLContextSpi;
import org.bouncycastle.jsse.provider.EngineCreator;
import org.bouncycastle.jsse.provider.ProvKeyManagerFactorySpi;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvTrustManagerFactorySpi;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCryptoProvider;
import org.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class BouncyCastleJsseProvider
extends Provider {
    public static final String PROVIDER_NAME = "BCJSSE";
    private static final String JSSE_CONFIG_PROPERTY = "org.bouncycastle.jsse.config";
    private static final double PROVIDER_VERSION = 1.0014;
    private static final String PROVIDER_INFO = "Bouncy Castle JSSE Provider Version 1.0.14";
    private final Map<String, BcJsseService> serviceMap = new HashMap<String, BcJsseService>();
    private final Map<String, EngineCreator> creatorMap = new HashMap<String, EngineCreator>();
    private final boolean isInFipsMode;
    private static final Map<Map<String, String>, Map<String, String>> attributeMaps = new HashMap<Map<String, String>, Map<String, String>>();

    public BouncyCastleJsseProvider() {
        this(BouncyCastleJsseProvider.getPropertyValue(JSSE_CONFIG_PROPERTY, "default"));
    }

    public BouncyCastleJsseProvider(boolean fipsMode) {
        super(PROVIDER_NAME, 1.0014, PROVIDER_INFO);
        this.isInFipsMode = this.configure(fipsMode, new JcaTlsCryptoProvider());
    }

    public BouncyCastleJsseProvider(Provider provider) {
        this(false, provider);
    }

    public BouncyCastleJsseProvider(boolean fipsMode, Provider provider) {
        super(PROVIDER_NAME, 1.0014, PROVIDER_INFO);
        this.isInFipsMode = this.configure(fipsMode, new JcaTlsCryptoProvider().setProvider(provider));
    }

    public BouncyCastleJsseProvider(String config) {
        super(PROVIDER_NAME, 1.0014, PROVIDER_INFO);
        JcaTlsCryptoProvider cryptoProvider;
        config = config.trim();
        boolean fipsMode = false;
        String cryptoName = config;
        int colonPos = config.indexOf(58);
        if (colonPos >= 0) {
            String first = config.substring(0, colonPos).trim();
            String second = config.substring(colonPos + 1).trim();
            fipsMode = first.equalsIgnoreCase("fips");
            cryptoName = second;
        }
        try {
            cryptoProvider = this.createCryptoProvider(cryptoName);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("unable to set up JcaTlsCryptoProvider: " + e.getMessage(), e);
        }
        this.isInFipsMode = this.configure(fipsMode, cryptoProvider);
    }

    public BouncyCastleJsseProvider(boolean fipsMode, JcaTlsCryptoProvider tlsCryptoProvider) {
        super(PROVIDER_NAME, 1.0014, PROVIDER_INFO);
        this.isInFipsMode = this.configure(fipsMode, tlsCryptoProvider);
    }

    @Override
    public Provider configure(String configArg) {
        return new BouncyCastleJsseProvider(configArg);
    }

    private JcaTlsCryptoProvider createCryptoProvider(String cryptoName) throws GeneralSecurityException {
        if (cryptoName.equalsIgnoreCase("default")) {
            return new JcaTlsCryptoProvider();
        }
        Provider provider = Security.getProvider(cryptoName);
        if (provider != null) {
            return new JcaTlsCryptoProvider().setProvider(provider);
        }
        try {
            Class<?> cryptoProviderClass = Class.forName(cryptoName);
            Object cryptoProviderInstance = cryptoProviderClass.newInstance();
            if (cryptoProviderInstance instanceof JcaTlsCryptoProvider) {
                return (JcaTlsCryptoProvider)cryptoProviderInstance;
            }
            if (cryptoProviderInstance instanceof Provider) {
                return new JcaTlsCryptoProvider().setProvider((Provider)cryptoProviderInstance);
            }
            throw new IllegalArgumentException("unrecognized class: " + cryptoName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("unable to find Provider/JcaTlsCryptoProvider class: " + cryptoName);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("unable to create Provider/JcaTlsCryptoProvider class '" + cryptoName + "': " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("unable to create Provider/JcaTlsCryptoProvider class '" + cryptoName + "': " + e.getMessage(), e);
        }
    }

    private boolean configure(final boolean fipsMode, final JcaTlsCryptoProvider cryptoProvider) {
        this.addAlgorithmImplementation("KeyManagerFactory.X.509", "org.bouncycastle.jsse.provider.KeyManagerFactory", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ProvKeyManagerFactorySpi(fipsMode, cryptoProvider.getHelper());
            }
        });
        this.addAlias("Alg.Alias.KeyManagerFactory.X509", "X.509");
        this.addAlias("Alg.Alias.KeyManagerFactory.PKIX", "X.509");
        this.addAlgorithmImplementation("TrustManagerFactory.PKIX", "org.bouncycastle.jsse.provider.TrustManagerFactory", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ProvTrustManagerFactorySpi(fipsMode, cryptoProvider.getHelper());
            }
        });
        this.addAlias("Alg.Alias.TrustManagerFactory.X.509", "PKIX");
        this.addAlias("Alg.Alias.TrustManagerFactory.X509", "PKIX");
        this.addAlgorithmImplementation("SSLContext.TLS", "org.bouncycastle.jsse.provider.SSLContext.TLS", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ProvSSLContextSpi(fipsMode, cryptoProvider, null);
            }
        });
        this.addAlgorithmImplementation("SSLContext.TLSV1", "org.bouncycastle.jsse.provider.SSLContext.TLSv1", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ProvSSLContextSpi(fipsMode, cryptoProvider, BouncyCastleJsseProvider.specifyClientProtocols(new String[]{"TLSv1"}));
            }
        });
        this.addAlgorithmImplementation("SSLContext.TLSV1.1", "org.bouncycastle.jsse.provider.SSLContext.TLSv1_1", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ProvSSLContextSpi(fipsMode, cryptoProvider, BouncyCastleJsseProvider.specifyClientProtocols(new String[]{"TLSv1.1", "TLSv1"}));
            }
        });
        this.addAlgorithmImplementation("SSLContext.TLSV1.2", "org.bouncycastle.jsse.provider.SSLContext.TLSv1_2", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ProvSSLContextSpi(fipsMode, cryptoProvider, BouncyCastleJsseProvider.specifyClientProtocols(new String[]{"TLSv1.2", "TLSv1.1", "TLSv1"}));
            }
        });
        this.addAlgorithmImplementation("SSLContext.TLSV1.3", "org.bouncycastle.jsse.provider.SSLContext.TLSv1_3", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ProvSSLContextSpi(fipsMode, cryptoProvider, BouncyCastleJsseProvider.specifyClientProtocols(new String[]{"TLSv1.3", "TLSv1.2", "TLSv1.1", "TLSv1"}));
            }
        });
        this.addAlgorithmImplementation("SSLContext.DEFAULT", "org.bouncycastle.jsse.provider.SSLContext.Default", new EngineCreator(){

            public Object createInstance(Object constructorParameter) throws GeneralSecurityException {
                return new DefaultSSLContextSpi(fipsMode, cryptoProvider);
            }
        });
        this.addAlias("Alg.Alias.SSLContext.SSL", "TLS");
        this.addAlias("Alg.Alias.SSLContext.SSLV3", "TLSV1");
        return fipsMode;
    }

    void addAttribute(String key, String attributeName, String attributeValue) {
        String attributeKey = key + " " + attributeName;
        if (this.containsKey(attributeKey)) {
            throw new IllegalStateException("duplicate provider attribute key (" + attributeKey + ") found");
        }
        this.doPut(attributeKey, attributeValue);
    }

    void addAlgorithmImplementation(String key, String className, EngineCreator creator) {
        if (this.containsKey(key)) {
            throw new IllegalStateException("duplicate provider key (" + key + ") found");
        }
        this.addAttribute(key, "ImplementedIn", "Software");
        this.doPut(key, className);
        this.creatorMap.put(className, creator);
    }

    void addAlias(String key, String value) {
        if (this.containsKey(key)) {
            throw new IllegalStateException("duplicate provider key (" + key + ") found");
        }
        this.doPut(key, value);
    }

    @Override
    public final synchronized Provider.Service getService(String type, String algorithm) {
        String upperCaseAlgName = Strings.toUpperCase((String)algorithm);
        BcJsseService service = this.serviceMap.get(type + "." + upperCaseAlgName);
        if (service == null) {
            String className;
            String aliasString = "Alg.Alias." + type + ".";
            String realName = (String)this.get(aliasString + upperCaseAlgName);
            if (realName == null) {
                realName = upperCaseAlgName;
            }
            if ((className = (String)this.get(type + "." + realName)) == null) {
                return null;
            }
            String attributeKeyStart = type + "." + upperCaseAlgName + " ";
            ArrayList<String> aliases = new ArrayList<String>();
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (Object key : this.keySet()) {
                String sKey = (String)key;
                if (sKey.startsWith(aliasString) && this.get(key).equals(algorithm)) {
                    aliases.add(sKey.substring(aliasString.length()));
                }
                if (!sKey.startsWith(attributeKeyStart)) continue;
                attributes.put(sKey.substring(attributeKeyStart.length()), (String)this.get(sKey));
            }
            service = new BcJsseService(this, type, upperCaseAlgName, className, aliases, BouncyCastleJsseProvider.getAttributeMap(attributes), this.creatorMap.get(className));
            this.serviceMap.put(type + "." + upperCaseAlgName, service);
        }
        return service;
    }

    @Override
    public final synchronized Set<Provider.Service> getServices() {
        Set<Provider.Service> serviceSet = super.getServices();
        HashSet<Provider.Service> bcServiceSet = new HashSet<Provider.Service>();
        for (Provider.Service service : serviceSet) {
            bcServiceSet.add(this.getService(service.getType(), service.getAlgorithm()));
        }
        return bcServiceSet;
    }

    private static Map<String, String> getAttributeMap(Map<String, String> attributeMap) {
        Map<String, String> attrMap = attributeMaps.get(attributeMap);
        if (attrMap != null) {
            return attrMap;
        }
        attributeMaps.put(attributeMap, attributeMap);
        return attributeMap;
    }

    private Object doPut(final String key, final String value) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return BouncyCastleJsseProvider.this.put(key, value);
            }
        });
    }

    private static List<String> specifyClientProtocols(String ... protocols) {
        return Arrays.asList(protocols);
    }

    public boolean isFipsMode() {
        return this.isInFipsMode;
    }

    private static String getPropertyValue(final String propertyName, final String defValue) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String v = Security.getProperty(propertyName);
                if (v != null) {
                    return v;
                }
                v = System.getProperty(propertyName);
                if (v != null) {
                    return v;
                }
                return defValue;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class BcJsseService
    extends Provider.Service {
        private final EngineCreator creator;

        public BcJsseService(Provider provider, String type, String algorithm, String className, List<String> aliases, Map<String, String> attributes, EngineCreator creator) {
            super(provider, type, algorithm, className, aliases, attributes);
            this.creator = creator;
        }

        @Override
        public Object newInstance(Object constructorParameter) throws NoSuchAlgorithmException {
            try {
                Object instance = this.creator.createInstance(constructorParameter);
                if (instance == null) {
                    throw new NoSuchAlgorithmException("No such algorithm in FIPS approved mode: " + this.getAlgorithm());
                }
                return instance;
            }
            catch (NoSuchAlgorithmException e) {
                throw e;
            }
            catch (Exception e) {
                throw new NoSuchAlgorithmException("Unable to invoke creator for " + this.getAlgorithm() + ": " + e.getMessage(), e);
            }
        }
    }
}

