/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JceBlockCipherImpl
implements TlsBlockCipherImpl {
    private static final int BUF_SIZE = 32768;
    private final int cipherMode;
    private final Cipher cipher;
    private final String algorithm;
    private final int keySize;
    private SecretKey key;

    public JceBlockCipherImpl(Cipher cipher, String algorithm, int keySize, boolean isEncrypting) throws GeneralSecurityException {
        this.cipher = cipher;
        this.algorithm = algorithm;
        this.keySize = keySize;
        this.cipherMode = isEncrypting ? 1 : 2;
    }

    public void setKey(byte[] key, int keyOff, int keyLen) {
        if (this.keySize != keyLen) {
            throw new IllegalStateException();
        }
        this.key = new SecretKeySpec(key, keyOff, keyLen, this.algorithm);
    }

    public void init(byte[] iv, int ivOff, int ivLen) {
        try {
            this.cipher.init(this.cipherMode, (Key)this.key, new IvParameterSpec(iv, ivOff, ivLen), null);
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.illegalStateException(e.getMessage(), e);
        }
    }

    public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
        try {
            int totLen = 0;
            while (inputLength > 32768) {
                totLen += this.cipher.update(input, inputOffset, 32768, output, outputOffset + totLen);
                inputOffset += 32768;
                inputLength -= 32768;
            }
            totLen += this.cipher.update(input, inputOffset, inputLength, output, outputOffset + totLen);
            totLen += this.cipher.doFinal(output, outputOffset + totLen);
            return totLen;
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.illegalStateException(e.getMessage(), e);
        }
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }
}

