/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.provider.JsseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JsseUtils_8
extends JsseUtils {
    JsseUtils_8() {
    }

    static SNIMatcher exportSNIMatcher(BCSNIMatcher matcher) {
        if (matcher == null) {
            return null;
        }
        if (matcher instanceof ImportSNIMatcher) {
            return ((ImportSNIMatcher)matcher).unwrap();
        }
        return new ExportSNIMatcher(matcher);
    }

    static Object exportSNIMatchers(Collection<BCSNIMatcher> matchers) {
        if (matchers == null) {
            return null;
        }
        ArrayList<SNIMatcher> result = new ArrayList<SNIMatcher>(matchers.size());
        for (BCSNIMatcher matcher : matchers) {
            SNIMatcher exported = JsseUtils_8.exportSNIMatcher(matcher);
            if (exported == null) continue;
            result.add(exported);
        }
        if (!result.isEmpty()) {
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    static SNIHostName exportSNIServerName(BCSNIServerName serverName) {
        if (serverName == null || serverName.getType() != 0) {
            return null;
        }
        return new SNIHostName(serverName.getEncoded());
    }

    static Object exportSNIServerNames(Collection<BCSNIServerName> serverNames) {
        if (serverNames == null) {
            return null;
        }
        ArrayList<SNIHostName> result = new ArrayList<SNIHostName>(serverNames.size());
        for (BCSNIServerName serverName : serverNames) {
            SNIHostName exported = JsseUtils_8.exportSNIServerName(serverName);
            if (exported == null) continue;
            result.add(exported);
        }
        if (!result.isEmpty()) {
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    static BCSNIMatcher importSNIMatcher(SNIMatcher matcher) {
        if (matcher == null) {
            return null;
        }
        if (matcher instanceof ExportSNIMatcher) {
            return ((ExportSNIMatcher)matcher).unwrap();
        }
        return new ImportSNIMatcher(matcher);
    }

    static List<BCSNIMatcher> importSNIMatchers(Object getSNIMatchersResult) {
        if (getSNIMatchersResult == null) {
            return null;
        }
        Collection matchers = (Collection)getSNIMatchersResult;
        ArrayList<BCSNIMatcher> result = new ArrayList<BCSNIMatcher>(matchers.size());
        for (SNIMatcher matcher : matchers) {
            BCSNIMatcher imported = JsseUtils_8.importSNIMatcher(matcher);
            if (imported == null) continue;
            result.add(imported);
        }
        if (!result.isEmpty()) {
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    static BCSNIHostName importSNIServerName(SNIServerName serverName) {
        if (serverName == null || serverName.getType() != 0) {
            return null;
        }
        return new BCSNIHostName(serverName.getEncoded());
    }

    static List<BCSNIServerName> importSNIServerNames(Object getServerNamesResult) {
        if (getServerNamesResult == null) {
            return null;
        }
        Collection serverNames = (Collection)getServerNamesResult;
        ArrayList<BCSNIHostName> result = new ArrayList<BCSNIHostName>(serverNames.size());
        for (SNIServerName serverName : serverNames) {
            BCSNIHostName imported = JsseUtils_8.importSNIServerName(serverName);
            if (imported == null) continue;
            result.add(imported);
        }
        if (!result.isEmpty()) {
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    static class ExportSNIMatcher
    extends SNIMatcher {
        private final BCSNIMatcher matcher;

        ExportSNIMatcher(BCSNIMatcher matcher) {
            super(matcher.getType());
            this.matcher = matcher;
        }

        public boolean matches(SNIServerName serverName) {
            return this.matcher.matches(JsseUtils_8.importSNIServerName(serverName));
        }

        BCSNIMatcher unwrap() {
            return this.matcher;
        }
    }

    static class ImportSNIMatcher
    extends BCSNIMatcher {
        private final SNIMatcher matcher;

        ImportSNIMatcher(SNIMatcher matcher) {
            super(matcher.getType());
            this.matcher = matcher;
        }

        public boolean matches(BCSNIServerName serverName) {
            return this.matcher.matches(JsseUtils_8.exportSNIServerName(serverName));
        }

        SNIMatcher unwrap() {
            return this.matcher;
        }
    }
}

