/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsPeer;
import org.bouncycastle.tls.CertificateStatusRequest;
import org.bouncycastle.tls.DefaultTlsECConfigVerifier;
import org.bouncycastle.tls.DefaultTlsKeyExchangeFactory;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.OCSPStatusRequest;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.ServerNameList;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientContext;
import org.bouncycastle.tls.TlsCompression;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsECCUtils;
import org.bouncycastle.tls.TlsECConfigVerifier;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsKeyExchangeFactory;
import org.bouncycastle.tls.TlsNullCompression;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;

public abstract class AbstractTlsClient
extends AbstractTlsPeer
implements TlsClient {
    protected TlsKeyExchangeFactory keyExchangeFactory;
    protected TlsClientContext context;
    protected Vector supportedGroups;
    protected Vector supportedSignatureAlgorithms;
    protected short[] clientECPointFormats;
    protected short[] serverECPointFormats;
    protected int selectedCipherSuite;
    protected short selectedCompressionMethod;

    public AbstractTlsClient(TlsCrypto crypto) {
        this(crypto, new DefaultTlsKeyExchangeFactory());
    }

    public AbstractTlsClient(TlsCrypto crypto, TlsKeyExchangeFactory keyExchangeFactory) {
        super(crypto);
        this.keyExchangeFactory = keyExchangeFactory;
    }

    protected boolean allowUnexpectedServerExtension(Integer extensionType, byte[] extensionData) throws IOException {
        switch (extensionType) {
            case 10: {
                TlsExtensionsUtils.readSupportedGroupsExtension(extensionData);
                return true;
            }
            case 11: {
                TlsECCUtils.readSupportedPointFormatsExtension(extensionData);
                return true;
            }
        }
        return false;
    }

    protected void checkForUnexpectedServerExtension(Hashtable serverExtensions, Integer extensionType) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(serverExtensions, extensionType);
        if (extensionData != null && !this.allowUnexpectedServerExtension(extensionType, extensionData)) {
            throw new TlsFatalAlert(47);
        }
    }

    protected TlsECConfigVerifier createECConfigVerifier() {
        int minimumCurveBits = TlsECCUtils.getMinimumCurveBits(this.selectedCipherSuite);
        return new DefaultTlsECConfigVerifier(minimumCurveBits, this.supportedGroups);
    }

    protected CertificateStatusRequest getCertificateStatusRequest() {
        return new CertificateStatusRequest(1, new OCSPStatusRequest(null, null));
    }

    protected Vector getSNIServerNames() {
        return null;
    }

    protected short[] getSupportedPointFormats() {
        return new short[]{0, 1, 2};
    }

    protected Vector getSupportedGroups(boolean offeringDH, boolean offeringEC) {
        Vector<Integer> supportedGroups = new Vector<Integer>();
        if (offeringEC) {
            supportedGroups.addElement(23);
            supportedGroups.addElement(24);
        }
        if (offeringDH) {
            supportedGroups.addElement(256);
            supportedGroups.addElement(257);
            supportedGroups.addElement(258);
        }
        return supportedGroups;
    }

    protected Vector getSupportedSignatureAlgorithms() {
        return TlsUtils.getDefaultSupportedSignatureAlgorithms(this.context);
    }

    public void init(TlsClientContext context) {
        this.context = context;
    }

    public TlsSession getSessionToResume() {
        return null;
    }

    public ProtocolVersion getClientHelloRecordLayerVersion() {
        return this.getClientVersion();
    }

    public ProtocolVersion getClientVersion() {
        return ProtocolVersion.TLSv12;
    }

    public boolean isFallback() {
        return false;
    }

    public Hashtable getClientExtensions() throws IOException {
        Vector supportedGroups;
        ProtocolVersion clientVersion;
        CertificateStatusRequest statusRequest;
        Hashtable clientExtensions = new Hashtable();
        TlsExtensionsUtils.addEncryptThenMACExtension(clientExtensions);
        TlsExtensionsUtils.addExtendedMasterSecretExtension(clientExtensions);
        Vector sniServerNames = this.getSNIServerNames();
        if (sniServerNames != null) {
            TlsExtensionsUtils.addServerNameExtension(clientExtensions, new ServerNameList(sniServerNames));
        }
        if ((statusRequest = this.getCertificateStatusRequest()) != null) {
            TlsExtensionsUtils.addStatusRequestExtension(clientExtensions, statusRequest);
        }
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(clientVersion = this.context.getClientVersion())) {
            this.supportedSignatureAlgorithms = this.getSupportedSignatureAlgorithms();
            TlsUtils.addSignatureAlgorithmsExtension(clientExtensions, this.supportedSignatureAlgorithms);
        }
        int[] cipherSuites = this.getCipherSuites();
        boolean offeringDH = TlsDHUtils.containsDHECipherSuites(cipherSuites);
        boolean offeringEC = TlsECCUtils.containsECCipherSuites(cipherSuites);
        if (offeringEC) {
            this.clientECPointFormats = this.getSupportedPointFormats();
            TlsECCUtils.addSupportedPointFormatsExtension(clientExtensions, this.clientECPointFormats);
        }
        if ((supportedGroups = this.getSupportedGroups(offeringDH, offeringEC)) != null && !supportedGroups.isEmpty()) {
            this.supportedGroups = supportedGroups;
            TlsExtensionsUtils.addSupportedGroupsExtension(clientExtensions, supportedGroups);
        }
        return clientExtensions;
    }

    public ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.TLSv10;
    }

    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        if (!this.getMinimumVersion().isEqualOrEarlierVersionOf(serverVersion)) {
            throw new TlsFatalAlert(70);
        }
    }

    public short[] getCompressionMethods() {
        return new short[]{0};
    }

    public void notifySessionID(byte[] sessionID) {
    }

    public void notifySelectedCipherSuite(int selectedCipherSuite) {
        this.selectedCipherSuite = selectedCipherSuite;
    }

    public void notifySelectedCompressionMethod(short selectedCompressionMethod) {
        this.selectedCompressionMethod = selectedCompressionMethod;
    }

    public void processServerExtensions(Hashtable serverExtensions) throws IOException {
        if (serverExtensions != null) {
            this.checkForUnexpectedServerExtension(serverExtensions, TlsUtils.EXT_signature_algorithms);
            this.checkForUnexpectedServerExtension(serverExtensions, TlsExtensionsUtils.EXT_supported_groups);
            if (TlsECCUtils.isECCipherSuite(this.selectedCipherSuite)) {
                this.serverECPointFormats = TlsECCUtils.getSupportedPointFormatsExtension(serverExtensions);
            } else {
                this.checkForUnexpectedServerExtension(serverExtensions, TlsECCUtils.EXT_ec_point_formats);
            }
            this.checkForUnexpectedServerExtension(serverExtensions, TlsExtensionsUtils.EXT_padding);
        }
    }

    public void processServerSupplementalData(Vector serverSupplementalData) throws IOException {
        if (serverSupplementalData != null) {
            throw new TlsFatalAlert(10);
        }
    }

    public Vector getClientSupplementalData() throws IOException {
        return null;
    }

    public TlsCompression getCompression() throws IOException {
        switch (this.selectedCompressionMethod) {
            case 0: {
                return new TlsNullCompression();
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsCipher getCipher() throws IOException {
        int encryptionAlgorithm = TlsUtils.getEncryptionAlgorithm(this.selectedCipherSuite);
        int macAlgorithm = TlsUtils.getMACAlgorithm(this.selectedCipherSuite);
        if (encryptionAlgorithm < 0 || macAlgorithm < 0) {
            throw new TlsFatalAlert(80);
        }
        return this.context.getSecurityParameters().getMasterSecret().createCipher(new TlsCryptoParameters(this.context), encryptionAlgorithm, macAlgorithm);
    }

    public void notifyNewSessionTicket(NewSessionTicket newSessionTicket) throws IOException {
    }
}

