/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import org.bouncycastle.tls.DTLSRecordLayer;
import org.bouncycastle.tls.DatagramTransport;
import org.bouncycastle.tls.TlsFatalAlert;

public class DTLSTransport
implements DatagramTransport {
    private final DTLSRecordLayer recordLayer;

    DTLSTransport(DTLSRecordLayer recordLayer) {
        this.recordLayer = recordLayer;
    }

    public int getReceiveLimit() throws IOException {
        return this.recordLayer.getReceiveLimit();
    }

    public int getSendLimit() throws IOException {
        return this.recordLayer.getSendLimit();
    }

    public int receive(byte[] buf, int off, int len, int waitMillis) throws IOException {
        try {
            return this.recordLayer.receive(buf, off, len, waitMillis);
        }
        catch (TlsFatalAlert fatalAlert) {
            this.recordLayer.fail(fatalAlert.getAlertDescription());
            throw fatalAlert;
        }
        catch (IOException e) {
            this.recordLayer.fail((short)80);
            throw e;
        }
        catch (RuntimeException e) {
            this.recordLayer.fail((short)80);
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    public void send(byte[] buf, int off, int len) throws IOException {
        try {
            this.recordLayer.send(buf, off, len);
        }
        catch (TlsFatalAlert fatalAlert) {
            this.recordLayer.fail(fatalAlert.getAlertDescription());
            throw fatalAlert;
        }
        catch (IOException e) {
            this.recordLayer.fail((short)80);
            throw e;
        }
        catch (RuntimeException e) {
            this.recordLayer.fail((short)80);
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    public void close() throws IOException {
        this.recordLayer.close();
    }
}

