/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.Hashtable;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.HashAlgorithm;
import org.bouncycastle.tls.MACAlgorithm;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.SRP6Group;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoException;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsDHDomain;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsECDomain;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.tls.crypto.TlsNonceGenerator;
import org.bouncycastle.tls.crypto.TlsSRP6Client;
import org.bouncycastle.tls.crypto.TlsSRP6Server;
import org.bouncycastle.tls.crypto.TlsSRP6VerifierGenerator;
import org.bouncycastle.tls.crypto.TlsSRPConfig;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipher;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipher;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsEncryptor;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsNullCipher;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaNonceGenerator;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCertificate;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsHash;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaUtils;
import org.bouncycastle.tls.crypto.impl.jcajce.JceAEADCipherImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.JceBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.JceBlockCipherWithCBCImplicitIVImpl;
import org.bouncycastle.tls.crypto.impl.jcajce.JceChaCha20Poly1305;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsDHDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsECDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsHMAC;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.srp.SRP6Client;
import org.bouncycastle.tls.crypto.impl.jcajce.srp.SRP6Server;
import org.bouncycastle.tls.crypto.impl.jcajce.srp.SRP6VerifierGenerator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;

public class JcaTlsCrypto
extends AbstractTlsCrypto {
    private final JcaJceHelper helper;
    private final SecureRandom entropySource;
    private final SecureRandom nonceEntropySource;
    private final Hashtable supportedGroups = new Hashtable();

    protected JcaTlsCrypto(JcaJceHelper helper, SecureRandom entropySource, SecureRandom nonceEntropySource) {
        this.helper = helper;
        this.entropySource = entropySource;
        this.nonceEntropySource = nonceEntropySource;
    }

    JceTlsSecret adoptLocalSecret(byte[] data) {
        return new JceTlsSecret(this, data);
    }

    Cipher createRSAEncryptionCipher() throws GeneralSecurityException {
        try {
            return this.getHelper().createCipher("RSA/NONE/PKCS1Padding");
        }
        catch (GeneralSecurityException e) {
            return this.getHelper().createCipher("RSA/ECB/PKCS1Padding");
        }
    }

    public TlsNonceGenerator createNonceGenerator(byte[] additionalSeedMaterial) {
        return new JcaNonceGenerator(this.nonceEntropySource, additionalSeedMaterial);
    }

    public SecureRandom getSecureRandom() {
        return this.entropySource;
    }

    public SecretKey calculateKeyAgreement(String agreementAlgorithm, PrivateKey privateKey, PublicKey publicKey, String secretAlgorithm) throws GeneralSecurityException {
        KeyAgreement agreement = this.helper.createKeyAgreement(agreementAlgorithm);
        agreement.init(privateKey);
        agreement.doPhase(publicKey, true);
        return agreement.generateSecret(secretAlgorithm);
    }

    public TlsCertificate createCertificate(byte[] encoding) throws IOException {
        return new JcaTlsCertificate(this, encoding);
    }

    protected TlsCipher createCipher(TlsCryptoParameters cryptoParams, int encryptionAlgorithm, int macAlgorithm) throws IOException {
        try {
            switch (encryptionAlgorithm) {
                case 7: {
                    return this.createDESedeCipher(cryptoParams, macAlgorithm);
                }
                case 8: {
                    return this.createAESCipher(cryptoParams, 16, macAlgorithm);
                }
                case 15: {
                    return this.createCipher_AES_CCM(cryptoParams, 16, 16);
                }
                case 16: {
                    return this.createCipher_AES_CCM(cryptoParams, 16, 8);
                }
                case 10: {
                    return this.createCipher_AES_GCM(cryptoParams, 16, 16);
                }
                case 103: {
                    return this.createCipher_AES_OCB(cryptoParams, 16, 12);
                }
                case 9: {
                    return this.createAESCipher(cryptoParams, 32, macAlgorithm);
                }
                case 17: {
                    return this.createCipher_AES_CCM(cryptoParams, 32, 16);
                }
                case 18: {
                    return this.createCipher_AES_CCM(cryptoParams, 32, 8);
                }
                case 11: {
                    return this.createCipher_AES_GCM(cryptoParams, 32, 16);
                }
                case 104: {
                    return this.createCipher_AES_OCB(cryptoParams, 32, 12);
                }
                case 22: {
                    return this.createARIACipher(cryptoParams, 16, macAlgorithm);
                }
                case 24: {
                    return this.createCipher_ARIA_GCM(cryptoParams, 16, 16);
                }
                case 23: {
                    return this.createARIACipher(cryptoParams, 32, macAlgorithm);
                }
                case 25: {
                    return this.createCipher_ARIA_GCM(cryptoParams, 32, 16);
                }
                case 12: {
                    return this.createCamelliaCipher(cryptoParams, 16, macAlgorithm);
                }
                case 19: {
                    return this.createCipher_Camellia_GCM(cryptoParams, 16, 16);
                }
                case 13: {
                    return this.createCamelliaCipher(cryptoParams, 32, macAlgorithm);
                }
                case 20: {
                    return this.createCipher_Camellia_GCM(cryptoParams, 32, 16);
                }
                case 21: {
                    return this.createChaCha20Poly1305(cryptoParams);
                }
                case 0: {
                    return this.createNullCipher(cryptoParams, macAlgorithm);
                }
                case 14: {
                    return this.createSEEDCipher(cryptoParams, macAlgorithm);
                }
            }
            throw new TlsFatalAlert(80);
        }
        catch (GeneralSecurityException e) {
            throw new TlsCryptoException("cannot create cipher: " + e.getMessage(), e);
        }
    }

    public TlsHMAC createHMAC(int macAlgorithm) {
        switch (macAlgorithm) {
            case 0: {
                return null;
            }
            case 1: {
                return this.createHMAC("HmacMD5");
            }
            case 2: {
                return this.createHMAC("HmacSHA1");
            }
            case 3: {
                return this.createHMAC("HmacSHA256");
            }
            case 4: {
                return this.createHMAC("HmacSHA384");
            }
            case 5: {
                return this.createHMAC("HmacSHA512");
            }
        }
        throw new IllegalArgumentException("unknown MACAlgorithm: " + MACAlgorithm.getText(macAlgorithm));
    }

    public TlsSRP6Client createSRP6Client(TlsSRPConfig srpConfig) {
        final SRP6Client srpClient = new SRP6Client();
        BigInteger[] ng = srpConfig.getExplicitNG();
        SRP6Group srpGroup = new SRP6Group(ng[0], ng[1]);
        srpClient.init(srpGroup, this.createHash((short)2), this.getSecureRandom());
        return new TlsSRP6Client(){

            public BigInteger calculateSecret(BigInteger serverB) throws TlsFatalAlert {
                try {
                    return srpClient.calculateSecret(serverB);
                }
                catch (IllegalArgumentException e) {
                    throw new TlsFatalAlert(47, (Throwable)e);
                }
            }

            public BigInteger generateClientCredentials(byte[] srpSalt, byte[] identity, byte[] password) {
                return srpClient.generateClientCredentials(srpSalt, identity, password);
            }
        };
    }

    public TlsSRP6Server createSRP6Server(TlsSRPConfig srpConfig, BigInteger srpVerifier) {
        final SRP6Server srpServer = new SRP6Server();
        BigInteger[] ng = srpConfig.getExplicitNG();
        SRP6Group srpGroup = new SRP6Group(ng[0], ng[1]);
        srpServer.init(srpGroup, srpVerifier, this.createHash((short)2), this.getSecureRandom());
        return new TlsSRP6Server(){

            public BigInteger generateServerCredentials() {
                return srpServer.generateServerCredentials();
            }

            public BigInteger calculateSecret(BigInteger clientA) throws IOException {
                try {
                    return srpServer.calculateSecret(clientA);
                }
                catch (IllegalArgumentException e) {
                    throw new TlsFatalAlert(47, (Throwable)e);
                }
            }
        };
    }

    public TlsSRP6VerifierGenerator createSRP6VerifierGenerator(TlsSRPConfig srpConfig) {
        BigInteger[] ng = srpConfig.getExplicitNG();
        final SRP6VerifierGenerator verifierGenerator = new SRP6VerifierGenerator();
        verifierGenerator.init(ng[0], ng[1], this.createHash((short)2));
        return new TlsSRP6VerifierGenerator(){

            public BigInteger generateVerifier(byte[] salt, byte[] identity, byte[] password) {
                return verifierGenerator.generateVerifier(salt, identity, password);
            }
        };
    }

    public boolean hasAllRawSignatureAlgorithms() {
        return !JcaUtils.isSunMSCAPIProviderActive();
    }

    public boolean hasDHAgreement() {
        return true;
    }

    public boolean hasECDHAgreement() {
        return true;
    }

    public boolean hasEncryptionAlgorithm(int encryptionAlgorithm) {
        try {
            switch (encryptionAlgorithm) {
                case 21: {
                    this.helper.createCipher("ChaCha7539");
                    this.helper.createMac("Poly1305");
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    this.helper.createCipher("AES/CCM/NoPadding");
                    break;
                }
                case 10: 
                case 11: {
                    this.helper.createCipher("AES/GCM/NoPadding");
                    break;
                }
                case 24: 
                case 25: {
                    this.helper.createCipher("ARIA/GCM/NoPadding");
                    break;
                }
                case 19: 
                case 20: {
                    this.helper.createCipher("CAMELLIA/GCM/NoPadding");
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return false;
                }
            }
        }
        catch (GeneralSecurityException e) {
            return false;
        }
        return true;
    }

    public boolean hasHashAlgorithm(short hashAlgorithm) {
        return true;
    }

    public boolean hasMacAlgorithm(int macAlgorithm) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNamedGroup(int namedGroup) {
        if (NamedGroup.refersToASpecificFiniteField(namedGroup)) {
            return true;
        }
        if (!NamedGroup.refersToASpecificCurve(namedGroup)) {
            return false;
        }
        String curveName = NamedGroup.getName(namedGroup);
        if (curveName == null) {
            return false;
        }
        int key = Integers.valueOf((int)namedGroup);
        Hashtable hashtable = this.supportedGroups;
        synchronized (hashtable) {
            Boolean cached = (Boolean)this.supportedGroups.get(key);
            if (cached != null) {
                return cached;
            }
        }
        boolean result = this.isCurveSupported(curveName);
        Hashtable hashtable2 = this.supportedGroups;
        synchronized (hashtable2) {
            this.supportedGroups.put(key, result);
        }
        return result;
    }

    public boolean hasRSAEncryption() {
        try {
            this.createRSAEncryptionCipher();
            return true;
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }

    public boolean hasSignatureAlgorithm(int signatureAlgorithm) {
        return true;
    }

    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm sigAndHashAlgorithm) {
        return sigAndHashAlgorithm.getHash() != 3 || !JcaUtils.isSunMSCAPIProviderActive();
    }

    public boolean hasSRPAuthentication() {
        return true;
    }

    public TlsSecret createSecret(byte[] data) {
        return this.adoptLocalSecret(Arrays.clone((byte[])data));
    }

    public TlsSecret generateRSAPreMasterSecret(ProtocolVersion version) {
        byte[] data = new byte[48];
        this.getSecureRandom().nextBytes(data);
        TlsUtils.writeVersion(version, data, 0);
        return this.adoptLocalSecret(data);
    }

    public TlsHash createHash(short algorithm) {
        try {
            return this.createHash(this.getDigestName(algorithm));
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("unable to create message digest:" + e.getMessage(), e);
        }
    }

    public TlsDHDomain createDHDomain(TlsDHConfig dhConfig) {
        return new JceTlsDHDomain(this, dhConfig);
    }

    public TlsECDomain createECDomain(TlsECConfig ecConfig) {
        return new JceTlsECDomain(this, ecConfig);
    }

    public TlsEncryptor createEncryptor(TlsCertificate certificate) throws IOException {
        JcaTlsCertificate jcaCert = JcaTlsCertificate.convert(this, certificate);
        jcaCert.validateKeyUsage(32);
        final RSAPublicKey pubKeyRSA = jcaCert.getPubKeyRSA();
        return new TlsEncryptor(){

            public byte[] encrypt(byte[] input, int inOff, int length) throws IOException {
                try {
                    Cipher c = JcaTlsCrypto.this.createRSAEncryptionCipher();
                    try {
                        c.init(3, (Key)pubKeyRSA, JcaTlsCrypto.this.getSecureRandom());
                        return c.wrap(new SecretKeySpec(input, inOff, length, "TLS"));
                    }
                    catch (Exception e) {
                        c.init(1, (Key)pubKeyRSA, JcaTlsCrypto.this.getSecureRandom());
                        return c.doFinal(input, inOff, length);
                    }
                }
                catch (GeneralSecurityException e) {
                    throw new TlsFatalAlert(80, (Throwable)e);
                }
            }
        };
    }

    protected TlsAEADCipherImpl createAEADCipher(String cipherName, String algorithm, int keySize, boolean isEncrypting) throws GeneralSecurityException {
        return new JceAEADCipherImpl(this.helper.createCipher(cipherName), algorithm, isEncrypting);
    }

    protected TlsBlockCipherImpl createBlockCipher(String cipherName, String algorithm, int keySize, boolean isEncrypting) throws GeneralSecurityException {
        return new JceBlockCipherImpl(this.helper.createCipher(cipherName), algorithm, isEncrypting);
    }

    protected TlsBlockCipherImpl createBlockCipherWithCBCImplicitIV(String cipherName, String algorithm, int keySize, boolean isEncrypting) throws GeneralSecurityException {
        return new JceBlockCipherWithCBCImplicitIVImpl(this.helper.createCipher(cipherName), algorithm, isEncrypting);
    }

    protected TlsHMAC createHMAC(String hmacName) {
        try {
            return new JceTlsHMAC(this.helper.createMac(hmacName), hmacName);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("cannot create HMAC: " + hmacName, e);
        }
    }

    protected TlsHash createHash(String digestName) throws GeneralSecurityException {
        return new JcaTlsHash(this.helper.createDigest(digestName));
    }

    protected TlsNullCipher createNullCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException, GeneralSecurityException {
        return new TlsNullCipher(cryptoParams, this.createMAC(macAlgorithm), this.createMAC(macAlgorithm));
    }

    protected boolean isCurveSupported(String curveName) {
        try {
            AlgorithmParameters params = this.getHelper().createAlgorithmParameters("EC");
            params.init(new ECGenParameterSpec(curveName));
            if (params.getParameterSpec(ECParameterSpec.class) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    JcaJceHelper getHelper() {
        return this.helper;
    }

    private TlsBlockCipher createAESCipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, cryptoParams, this.createCBCBlockOperator(cryptoParams, "AES", true, cipherKeySize), this.createCBCBlockOperator(cryptoParams, "AES", false, cipherKeySize), this.createMAC(macAlgorithm), this.createMAC(macAlgorithm), cipherKeySize);
    }

    private TlsBlockCipher createARIACipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, cryptoParams, this.createCBCBlockOperator(cryptoParams, "ARIA", true, cipherKeySize), this.createCBCBlockOperator(cryptoParams, "ARIA", false, cipherKeySize), this.createMAC(macAlgorithm), this.createMAC(macAlgorithm), cipherKeySize);
    }

    private TlsBlockCipher createCamelliaCipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, cryptoParams, this.createCBCBlockOperator(cryptoParams, "Camellia", true, cipherKeySize), this.createCBCBlockOperator(cryptoParams, "Camellia", false, cipherKeySize), this.createMAC(macAlgorithm), this.createMAC(macAlgorithm), cipherKeySize);
    }

    private TlsBlockCipher createDESedeCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, cryptoParams, this.createCBCBlockOperator(cryptoParams, "DESede", true, 24), this.createCBCBlockOperator(cryptoParams, "DESede", false, 24), this.createMAC(macAlgorithm), this.createMAC(macAlgorithm), 24);
    }

    private TlsBlockCipher createSEEDCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException, GeneralSecurityException {
        return new TlsBlockCipher(this, cryptoParams, this.createCBCBlockOperator(cryptoParams, "SEED", true, 16), this.createCBCBlockOperator(cryptoParams, "SEED", false, 16), this.createMAC(macAlgorithm), this.createMAC(macAlgorithm), 16);
    }

    private TlsBlockCipherImpl createCBCBlockOperator(TlsCryptoParameters cryptoParams, String algorithm, boolean forEncryption, int keySize) throws GeneralSecurityException {
        String cipherName = algorithm + "/CBC/NoPadding";
        if (TlsImplUtils.isTLSv11(cryptoParams)) {
            return this.createBlockCipher(cipherName, algorithm, keySize, forEncryption);
        }
        return this.createBlockCipherWithCBCImplicitIV(cipherName, algorithm, keySize, forEncryption);
    }

    private TlsHMAC createMAC(int macAlgorithm) throws IOException {
        return this.createHMAC(macAlgorithm);
    }

    private TlsCipher createChaCha20Poly1305(TlsCryptoParameters cryptoParams) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(cryptoParams, new JceChaCha20Poly1305(this.helper, true), new JceChaCha20Poly1305(this.helper, false), 32, 16, 2);
    }

    private TlsAEADCipher createCipher_AES_CCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(cryptoParams, this.createAEADCipher("AES/CCM/NoPadding", "AES", cipherKeySize, true), this.createAEADCipher("AES/CCM/NoPadding", "AES", cipherKeySize, false), cipherKeySize, macSize);
    }

    private TlsAEADCipher createCipher_AES_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(cryptoParams, this.createAEADCipher("AES/GCM/NoPadding", "AES", cipherKeySize, true), this.createAEADCipher("AES/GCM/NoPadding", "AES", cipherKeySize, false), cipherKeySize, macSize);
    }

    private TlsAEADCipher createCipher_AES_OCB(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(cryptoParams, this.createAEADCipher("AES/OCB/NoPadding", "AES", cipherKeySize, true), this.createAEADCipher("AES/OCB/NoPadding", "AES", cipherKeySize, false), cipherKeySize, macSize, 2);
    }

    private TlsAEADCipher createCipher_ARIA_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(cryptoParams, this.createAEADCipher("ARIA/GCM/NoPadding", "ARIA", cipherKeySize, true), this.createAEADCipher("ARIA/GCM/NoPadding", "ARIA", cipherKeySize, false), cipherKeySize, macSize);
    }

    private TlsAEADCipher createCipher_Camellia_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException, GeneralSecurityException {
        return new TlsAEADCipher(cryptoParams, this.createAEADCipher("Camellia/GCM/NoPadding", "Camellia", cipherKeySize, true), this.createAEADCipher("Camellia/GCM/NoPadding", "Camellia", cipherKeySize, false), cipherKeySize, macSize);
    }

    String getDigestName(short hashAlgorithm) {
        String digestName;
        switch (hashAlgorithm) {
            case 1: {
                digestName = "MD5";
                break;
            }
            case 2: {
                digestName = "SHA-1";
                break;
            }
            case 3: {
                digestName = "SHA-224";
                break;
            }
            case 4: {
                digestName = "SHA-256";
                break;
            }
            case 5: {
                digestName = "SHA-384";
                break;
            }
            case 6: {
                digestName = "SHA-512";
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown HashAlgorithm: " + HashAlgorithm.getText(hashAlgorithm));
            }
        }
        return digestName;
    }
}

