/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.tls.crypto.impl.TlsStreamCipherImpl;

public class JceStreamCipherImpl
implements TlsStreamCipherImpl {
    private final int cipherMode;
    private final Cipher cipher;
    private final String baseAlgorithm;
    private SecretKey key;
    private boolean hasNoIv;

    public JceStreamCipherImpl(Cipher cipher, String algorithm, boolean isEncrypting) throws GeneralSecurityException {
        this.cipher = cipher;
        this.baseAlgorithm = algorithm;
        this.cipherMode = isEncrypting ? 1 : 2;
    }

    public void setKey(byte[] key) {
        this.key = new SecretKeySpec(key, this.baseAlgorithm);
    }

    public void init(byte[] iv) {
        try {
            if (iv != null) {
                this.hasNoIv = false;
                this.cipher.init(this.cipherMode, (Key)this.key, new IvParameterSpec(iv));
            } else {
                this.hasNoIv = true;
                this.cipher.init(this.cipherMode, this.key);
            }
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
        try {
            if (this.hasNoIv) {
                int len = this.cipher.update(input, inputOffset, inputLength, output, outputOffset);
                return len;
            }
            int len = this.cipher.doFinal(input, inputOffset, inputLength, output, outputOffset);
            return len;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }
}

