/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jsse.BCSSLConnection;
import org.bouncycastle.jsse.BCSSLEngine;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSessionImpl;
import org.bouncycastle.jsse.provider.ProvTlsClient;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.ProvTlsServer;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.tls.RecordPreview;
import org.bouncycastle.tls.TlsClientProtocol;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsServerProtocol;

class ProvSSLEngine
extends SSLEngine
implements BCSSLEngine,
ProvTlsManager {
    protected final ProvSSLContextSpi context;
    protected final ContextData contextData;
    protected final ProvSSLParameters sslParameters;
    protected boolean enableSessionCreation = true;
    protected boolean useClientMode = false;
    protected boolean initialHandshakeBegun = false;
    protected SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected BCSSLConnection connection = null;
    protected SSLSession handshakeSession = null;
    protected SSLException deferredException = null;

    protected ProvSSLEngine(ProvSSLContextSpi context, ContextData contextData) {
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
    }

    protected ProvSSLEngine(ProvSSLContextSpi context, ContextData contextData, String host, int port) {
        super(host, port);
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
    }

    public ProvSSLContextSpi getContext() {
        return this.context;
    }

    public ContextData getContextData() {
        return this.contextData;
    }

    public synchronized void beginHandshake() throws SSLException {
        if (this.initialHandshakeBegun) {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
        this.initialHandshakeBegun = true;
        try {
            if (this.useClientMode) {
                TlsClientProtocol clientProtocol = new TlsClientProtocol();
                this.protocol = clientProtocol;
                ProvTlsClient client = new ProvTlsClient(this, this.sslParameters.copy());
                this.protocolPeer = client;
                clientProtocol.connect(client);
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
            } else {
                TlsServerProtocol serverProtocol = new TlsServerProtocol();
                this.protocol = serverProtocol;
                ProvTlsServer server = new ProvTlsServer(this, this.sslParameters.copy());
                this.protocolPeer = server;
                serverProtocol.accept(server);
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
        }
        catch (SSLException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SSLException(e);
        }
    }

    public synchronized void closeInbound() throws SSLException {
        try {
            this.protocol.closeInput();
        }
        catch (IOException e) {
            throw new SSLException(e);
        }
    }

    public synchronized void closeOutbound() {
        try {
            this.protocol.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized BCSSLConnection getConnection() {
        return this.connection;
    }

    public synchronized Runnable getDelegatedTask() {
        return null;
    }

    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public synchronized SSLSession getHandshakeSession() {
        return this.handshakeSession;
    }

    public synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.handshakeStatus;
    }

    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    public synchronized BCSSLParameters getParameters() {
        return SSLParametersUtil.getParameters(this.sslParameters);
    }

    public synchronized SSLSession getSession() {
        return this.connection == null ? ProvSSLSessionImpl.NULL_SESSION.getExportSession() : this.connection.getSession();
    }

    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.getSSLParameters(this.sslParameters);
    }

    public synchronized String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    public synchronized String[] getSupportedProtocols() {
        return this.context.getSupportedProtocols();
    }

    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    public synchronized boolean isInboundDone() {
        return this.protocol != null && this.protocol.isClosed();
    }

    public synchronized boolean isOutboundDone() {
        return this.protocol != null && this.protocol.isClosed() && this.protocol.getAvailableOutputBytes() < 1;
    }

    public synchronized void setEnabledCipherSuites(String[] suites) {
        this.sslParameters.setCipherSuites(suites);
    }

    public synchronized void setEnabledProtocols(String[] protocols) {
        this.sslParameters.setProtocols(protocols);
    }

    public synchronized void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
    }

    public synchronized void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    public synchronized void setParameters(BCSSLParameters parameters) {
        SSLParametersUtil.setParameters(this.sslParameters, parameters);
    }

    public synchronized void setSSLParameters(SSLParameters sslParameters) {
        SSLParametersUtil.setSSLParameters(this.sslParameters, sslParameters);
    }

    public synchronized void setUseClientMode(boolean mode) {
        if (this.useClientMode == mode) {
            return;
        }
        if (this.initialHandshakeBegun) {
            throw new IllegalArgumentException("Mode cannot be changed after the initial handshake has begun");
        }
        this.useClientMode = mode;
        this.context.updateDefaultProtocols(this.sslParameters, !this.useClientMode);
    }

    public synchronized void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    public synchronized SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
        if (!this.initialHandshakeBegun) {
            this.beginHandshake();
        }
        SSLEngineResult.Status resultStatus = SSLEngineResult.Status.OK;
        int bytesConsumed = 0;
        int bytesProduced = 0;
        if (this.protocol.isClosed()) {
            resultStatus = SSLEngineResult.Status.CLOSED;
        } else {
            try {
                RecordPreview preview = this.getRecordPreview(src);
                if (preview == null || src.remaining() < preview.getRecordSize()) {
                    resultStatus = SSLEngineResult.Status.BUFFER_UNDERFLOW;
                } else if (this.hasInsufficientSpace(dsts, offset, length, preview.getApplicationDataLimit())) {
                    resultStatus = SSLEngineResult.Status.BUFFER_OVERFLOW;
                } else {
                    byte[] record = new byte[preview.getRecordSize()];
                    src.get(record);
                    this.protocol.offerInput(record);
                    bytesConsumed += record.length;
                    int appDataAvailable = this.protocol.getAvailableInputBytes();
                    for (int dstIndex = 0; dstIndex < length && appDataAvailable > 0; ++dstIndex) {
                        ByteBuffer dst = dsts[offset + dstIndex];
                        int count = Math.min(dst.remaining(), appDataAvailable);
                        if (count <= 0) continue;
                        byte[] appData = new byte[count];
                        int numRead = this.protocol.readInput(appData, 0, count);
                        assert (numRead == count);
                        dst.put(appData);
                        bytesProduced += count;
                        appDataAvailable -= count;
                    }
                    if (appDataAvailable != 0) {
                        throw new TlsFatalAlert(22);
                    }
                }
            }
            catch (IOException e) {
                if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    throw new SSLException(e);
                }
                if (this.deferredException == null) {
                    this.deferredException = new SSLException(e);
                }
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, bytesConsumed, bytesProduced);
            }
        }
        SSLEngineResult.HandshakeStatus resultHandshakeStatus = this.handshakeStatus;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            if (this.protocol.getAvailableOutputBytes() > 0) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
            } else if (this.protocolPeer.isHandshakeComplete()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.FINISHED;
            } else if (this.protocol.isClosed()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            }
        }
        return new SSLEngineResult(resultStatus, resultHandshakeStatus, bytesConsumed, bytesProduced);
    }

    public synchronized SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws SSLException {
        int outputAvailable;
        if (this.deferredException != null) {
            SSLException e = this.deferredException;
            this.deferredException = null;
            throw e;
        }
        if (!this.initialHandshakeBegun) {
            this.beginHandshake();
        }
        SSLEngineResult.Status resultStatus = SSLEngineResult.Status.OK;
        int bytesConsumed = 0;
        int bytesProduced = 0;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            if (this.protocol.isClosed()) {
                resultStatus = SSLEngineResult.Status.CLOSED;
            } else if (this.protocol.getAvailableOutputBytes() <= 0) {
                try {
                    int srcRemaining = this.getTotalRemaining(srcs, offset, length, this.protocol.getApplicationDataLimit());
                    if (srcRemaining > 0) {
                        RecordPreview preview = this.protocol.previewOutputRecord(srcRemaining);
                        int srcLimit = preview.getApplicationDataLimit();
                        int dstLimit = preview.getRecordSize();
                        if (dst.remaining() < dstLimit) {
                            resultStatus = SSLEngineResult.Status.BUFFER_OVERFLOW;
                        } else {
                            for (int srcIndex = 0; srcIndex < length && srcLimit > 0; ++srcIndex) {
                                ByteBuffer src = srcs[offset + srcIndex];
                                int count = Math.min(src.remaining(), srcLimit);
                                if (count <= 0) continue;
                                byte[] input = new byte[count];
                                src.get(input);
                                this.protocol.writeApplicationData(input, 0, count);
                                bytesConsumed += count;
                                srcLimit -= count;
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new SSLException(e);
                }
            }
        }
        if ((outputAvailable = this.protocol.getAvailableOutputBytes()) > 0) {
            int count = Math.min(dst.remaining(), outputAvailable);
            if (count > 0) {
                byte[] output = new byte[count];
                int numRead = this.protocol.readOutput(output, 0, count);
                assert (numRead == count);
                dst.put(output);
                bytesProduced += count;
                outputAvailable -= count;
            } else {
                resultStatus = SSLEngineResult.Status.BUFFER_OVERFLOW;
            }
        }
        SSLEngineResult.HandshakeStatus resultHandshakeStatus = this.handshakeStatus;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && outputAvailable <= 0) {
            if (this.protocolPeer.isHandshakeComplete()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.FINISHED;
            } else if (this.protocol.isClosed()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            } else {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
        }
        return new SSLEngineResult(resultStatus, resultHandshakeStatus, bytesConsumed, bytesProduced);
    }

    public String getPeerHost() {
        return super.getPeerHost();
    }

    public int getPeerPort() {
        return super.getPeerPort();
    }

    public boolean isClientTrusted(X509Certificate[] chain, String authType) {
        X509TrustManager tm = this.contextData.getTrustManager();
        if (tm != null) {
            try {
                tm.checkClientTrusted(chain, authType);
                return true;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isServerTrusted(X509Certificate[] chain, String authType) {
        X509TrustManager tm = this.contextData.getTrustManager();
        if (tm != null) {
            try {
                tm.checkServerTrusted(chain, authType);
                return true;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return false;
    }

    public synchronized void notifyHandshakeComplete(ProvSSLConnection connection) {
        this.connection = connection;
    }

    private RecordPreview getRecordPreview(ByteBuffer src) throws IOException {
        if (src.remaining() < 5) {
            return null;
        }
        byte[] recordHeader = new byte[5];
        int position = src.position();
        src.get(recordHeader);
        src.position(position);
        return this.protocol.previewInputRecord(recordHeader);
    }

    private int getTotalRemaining(ByteBuffer[] bufs, int off, int len, int limit) {
        int result = 0;
        for (int i = 0; i < len; ++i) {
            ByteBuffer buf = bufs[off + i];
            int next = buf.remaining();
            if (next >= limit - result) {
                return limit;
            }
            result += next;
        }
        return result;
    }

    private boolean hasInsufficientSpace(ByteBuffer[] dsts, int off, int len, int amount) {
        return this.getTotalRemaining(dsts, off, len, amount) < amount;
    }
}

