/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jsse.BCSSLConnection;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSessionImpl;
import org.bouncycastle.jsse.provider.ProvSSLSocketBase;
import org.bouncycastle.jsse.provider.ProvTlsClient;
import org.bouncycastle.jsse.provider.ProvTlsClientProtocol;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.ProvTlsServer;
import org.bouncycastle.jsse.provider.ProvTlsServerProtocol;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.tls.TlsProtocol;

class ProvSSLSocketDirect
extends ProvSSLSocketBase
implements ProvTlsManager {
    private static Logger LOG = Logger.getLogger(ProvSSLSocketDirect.class.getName());
    protected final AppDataInput appDataIn = new AppDataInput();
    protected final AppDataOutput appDataOut = new AppDataOutput();
    protected final ProvSSLContextSpi context;
    protected final ContextData contextData;
    protected final ProvSSLParameters sslParameters;
    protected boolean enableSessionCreation = true;
    protected boolean useClientMode = true;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected BCSSLConnection connection = null;
    protected SSLSession handshakeSession = null;

    ProvSSLSocketDirect(ProvSSLContextSpi context, ContextData contextData, boolean enableSessionCreation, boolean useClientMode, ProvSSLParameters sslParameters) {
        this.context = context;
        this.contextData = contextData;
        this.enableSessionCreation = enableSessionCreation;
        this.useClientMode = useClientMode;
        this.sslParameters = sslParameters;
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi context, ContextData contextData) {
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi context, ContextData contextData, InetAddress address, int port, InetAddress clientAddress, int clientPort) throws IOException {
        super(address, port, clientAddress, clientPort);
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi context, ContextData contextData, InetAddress address, int port) throws IOException {
        super(address, port);
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi context, ContextData contextData, String host, int port, InetAddress clientAddress, int clientPort) throws IOException, UnknownHostException {
        super(host, port, clientAddress, clientPort);
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi context, ContextData contextData, String host, int port) throws IOException, UnknownHostException {
        super(host, port);
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
    }

    public ProvSSLContextSpi getContext() {
        return this.context;
    }

    public ContextData getContextData() {
        return this.contextData;
    }

    public synchronized void close() throws IOException {
        if (this.protocol == null) {
            this.closeSocket();
        } else {
            this.protocol.close();
        }
    }

    public synchronized BCSSLConnection getConnection() {
        try {
            this.handshakeIfNecessary(false);
        }
        catch (IOException e) {
            LOG.log(Level.FINE, "Failed to establish connection", e);
        }
        return this.connection;
    }

    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public synchronized SSLSession getHandshakeSession() {
        return this.handshakeSession;
    }

    public InputStream getInputStream() throws IOException {
        return this.appDataIn;
    }

    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.appDataOut;
    }

    public synchronized BCSSLParameters getParameters() {
        return SSLParametersUtil.getParameters(this.sslParameters);
    }

    public synchronized SSLSession getSession() {
        BCSSLConnection connection = this.getConnection();
        return connection == null ? ProvSSLSessionImpl.NULL_SESSION.getExportSession() : connection.getSession();
    }

    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.getSSLParameters(this.sslParameters);
    }

    public synchronized String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    public synchronized String[] getSupportedProtocols() {
        return this.context.getSupportedProtocols();
    }

    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    public synchronized void setEnabledCipherSuites(String[] suites) {
        this.sslParameters.setCipherSuites(suites);
    }

    public synchronized void setEnabledProtocols(String[] protocols) {
        this.sslParameters.setProtocols(protocols);
    }

    public synchronized void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
    }

    public synchronized void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    public synchronized void setParameters(BCSSLParameters parameters) {
        SSLParametersUtil.setParameters(this.sslParameters, parameters);
    }

    public synchronized void setSSLParameters(SSLParameters sslParameters) {
        SSLParametersUtil.setSSLParameters(this.sslParameters, sslParameters);
    }

    public synchronized void setUseClientMode(boolean mode) {
        if (this.useClientMode == mode) {
            return;
        }
        if (this.protocol != null) {
            throw new IllegalArgumentException("Mode cannot be changed after the initial handshake has begun");
        }
        this.useClientMode = mode;
        this.context.updateDefaultProtocols(this.sslParameters, !this.useClientMode);
    }

    public synchronized void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    public synchronized void startHandshake() throws IOException {
        this.startHandshake(true);
    }

    protected void startHandshake(boolean resumable) throws IOException {
        if (this.protocol == null) {
            InputStream input = super.getInputStream();
            OutputStream output = super.getOutputStream();
            if (this.useClientMode) {
                ProvTlsClientProtocol clientProtocol = new ProvTlsClientProtocol(input, output, this.socketCloser);
                clientProtocol.setResumableHandshake(resumable);
                this.protocol = clientProtocol;
                ProvTlsClient client = new ProvTlsClient(this, this.sslParameters.copy());
                this.protocolPeer = client;
                clientProtocol.connect(client);
            } else {
                ProvTlsServerProtocol serverProtocol = new ProvTlsServerProtocol(input, output, this.socketCloser);
                serverProtocol.setResumableHandshake(resumable);
                this.protocol = serverProtocol;
                ProvTlsServer server = new ProvTlsServer(this, this.sslParameters.copy());
                this.protocolPeer = server;
                serverProtocol.accept(server);
            }
        } else if (this.protocol.isHandshaking()) {
            this.protocol.setResumableHandshake(resumable);
            this.protocol.resumeHandshake();
        } else {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
    }

    public String getPeerHost() {
        String peerHost;
        int pos;
        InetAddress peerAddress = this.getInetAddress();
        if (peerAddress != null && (pos = (peerHost = peerAddress.toString()).lastIndexOf(47)) > 0) {
            return peerHost.substring(0, pos);
        }
        return null;
    }

    public int getPeerPort() {
        return this.getPort();
    }

    public boolean isClientTrusted(X509Certificate[] chain, String authType) {
        X509TrustManager tm = this.contextData.getTrustManager();
        if (tm != null) {
            try {
                tm.checkClientTrusted(chain, authType);
                return true;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isServerTrusted(X509Certificate[] chain, String authType) {
        X509TrustManager tm = this.contextData.getTrustManager();
        if (tm != null) {
            try {
                tm.checkServerTrusted(chain, authType);
                return true;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return false;
    }

    public synchronized void notifyHandshakeComplete(ProvSSLConnection connection) {
        this.connection = connection;
    }

    synchronized void handshakeIfNecessary(boolean resumable) throws IOException {
        if (this.protocol == null || this.protocol.isHandshaking()) {
            this.startHandshake(resumable);
        }
    }

    class AppDataInput
    extends InputStream {
        AppDataInput() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int available() throws IOException {
            ProvSSLSocketDirect provSSLSocketDirect = ProvSSLSocketDirect.this;
            synchronized (provSSLSocketDirect) {
                return ProvSSLSocketDirect.this.protocol == null ? 0 : ProvSSLSocketDirect.this.protocol.applicationDataAvailable();
            }
        }

        public void close() throws IOException {
            ProvSSLSocketDirect.this.close();
        }

        public int read() throws IOException {
            ProvSSLSocketDirect.this.handshakeIfNecessary(true);
            byte[] buf = new byte[1];
            int ret = ProvSSLSocketDirect.this.protocol.readApplicationData(buf, 0, 1);
            return ret < 0 ? -1 : buf[0] & 0xFF;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (len < 1) {
                return 0;
            }
            ProvSSLSocketDirect.this.handshakeIfNecessary(true);
            return ProvSSLSocketDirect.this.protocol.readApplicationData(b, off, len);
        }
    }

    class AppDataOutput
    extends OutputStream {
        AppDataOutput() {
        }

        public void close() throws IOException {
            ProvSSLSocketDirect.this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            ProvSSLSocketDirect provSSLSocketDirect = ProvSSLSocketDirect.this;
            synchronized (provSSLSocketDirect) {
                if (ProvSSLSocketDirect.this.protocol != null) {
                    ProvSSLSocketDirect.this.protocol.flush();
                }
            }
        }

        public void write(int b) throws IOException {
            ProvSSLSocketDirect.this.handshakeIfNecessary(true);
            byte[] buf = new byte[]{(byte)b};
            ProvSSLSocketDirect.this.protocol.writeApplicationData(buf, 0, 1);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (len > 0) {
                ProvSSLSocketDirect.this.handshakeIfNecessary(true);
                ProvSSLSocketDirect.this.protocol.writeApplicationData(b, off, len);
            }
        }
    }
}

