/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.crypto.TlsCrypto;

public abstract class AbstractTlsPeer
implements TlsPeer {
    private final TlsCrypto crypto;

    protected AbstractTlsPeer(TlsCrypto crypto) {
        this.crypto = crypto;
    }

    public TlsCrypto getCrypto() {
        return this.crypto;
    }

    public boolean shouldUseExtendedPadding() {
        return false;
    }

    public boolean shouldUseGMTUnixTime() {
        return false;
    }

    public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
        if (!secureRenegotiation) {
            throw new TlsFatalAlert(40);
        }
    }

    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
    }

    public void notifyAlertReceived(short alertLevel, short alertDescription) {
    }

    public void notifyHandshakeComplete() throws IOException {
    }
}

