/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.AccessController;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.cms.GCMParameters;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;

public class JceAEADCipherImpl
implements TlsAEADCipherImpl {
    private static final boolean canDoAEAD = JceAEADCipherImpl.checkForAEAD();
    private final JcaJceHelper helper;
    private final int cipherMode;
    private final Cipher cipher;
    private final String algorithm;
    private final String algorithmParamsName;
    private SecretKey key;

    private static boolean checkForAEAD() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    return Cipher.class.getMethod("updateAAD", byte[].class) != null;
                }
                catch (Exception ignore) {
                    return Boolean.FALSE;
                }
            }
        });
    }

    private static String getAlgParamsName(JcaJceHelper helper, String cipherName) {
        try {
            String algName = cipherName.contains("CCM") ? "CCM" : "GCM";
            helper.createAlgorithmParameters(algName);
            return algName;
        }
        catch (Exception e) {
            return null;
        }
    }

    public JceAEADCipherImpl(JcaJceHelper helper, String cipherName, String algorithm, boolean isEncrypting) throws GeneralSecurityException {
        this.helper = helper;
        this.cipher = helper.createCipher(cipherName);
        this.algorithm = algorithm;
        this.cipherMode = isEncrypting ? 1 : 2;
        this.algorithmParamsName = JceAEADCipherImpl.getAlgParamsName(helper, cipherName);
    }

    public void setKey(byte[] key, int keyOff, int keyLen) {
        this.key = new SecretKeySpec(key, keyOff, keyLen, this.algorithm);
    }

    public void init(byte[] nonce, int macSize, byte[] additionalData) {
        try {
            if (canDoAEAD && this.algorithmParamsName != null) {
                AlgorithmParameters algParams = this.helper.createAlgorithmParameters(this.algorithmParamsName);
                algParams.init(new GCMParameters(nonce, macSize).getEncoded());
                this.cipher.init(this.cipherMode, (Key)this.key, algParams);
                if (additionalData != null && additionalData.length > 0) {
                    this.cipher.updateAAD(additionalData);
                }
            } else {
                this.cipher.init(this.cipherMode, (Key)this.key, (AlgorithmParameterSpec)new AEADParameterSpec(nonce, macSize * 8, additionalData));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public int getOutputSize(int inputLength) {
        return this.cipher.getOutputSize(inputLength);
    }

    public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
        try {
            return this.cipher.doFinal(input, inputOffset, inputLength, output, outputOffset);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }
}

