/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509ExtendedKeyManager;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.BCX509ExtendedTrustManager;
import org.bouncycastle.jsse.provider.JsseSessionParameters;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvSSLSessionHandshake;
import org.bouncycastle.jsse.provider.ProvSSLSessionResumed;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.SupportedGroups;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsServer;
import org.bouncycastle.tls.ProtocolName;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceDefaultTlsCredentialedDecryptor;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvTlsServer
extends DefaultTlsServer
implements ProvTlsPeer {
    private static final Logger LOG = Logger.getLogger(ProvTlsServer.class.getName());
    private static final int provEphemeralDHKeySize = PropertyUtils.getIntegerSystemProperty("jdk.tls.ephemeralDHKeySize", 2048, 1024, 8192);
    protected final ProvTlsManager manager;
    protected final ProvSSLParameters sslParameters;
    protected ProvSSLSession sslSession = null;
    protected BCSNIServerName matchedSNIServerName = null;
    protected Set<String> keyManagerMissCache = null;
    protected TlsCredentials credentials = null;
    protected boolean handshakeComplete = false;

    ProvTlsServer(ProvTlsManager provTlsManager, ProvSSLParameters provSSLParameters) throws SSLException {
        super(provTlsManager.getContextData().getCrypto());
        this.manager = provTlsManager;
        this.sslParameters = provSSLParameters;
        if (!provTlsManager.getEnableSessionCreation()) {
            throw new SSLException("Session resumption not implemented yet and session creation is disabled");
        }
    }

    @Override
    protected boolean allowCertificateStatus() {
        return false;
    }

    @Override
    protected int getMaximumNegotiableCurveBits() {
        int[] nArray = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        return SupportedGroups.getServerMaximumNegotiableCurveBits(this.manager.getContext().isFips(), nArray);
    }

    @Override
    protected int getMaximumNegotiableFiniteFieldBits() {
        int[] nArray = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        int n = SupportedGroups.getServerMaximumNegotiableFiniteFieldBits(this.manager.getContext().isFips(), nArray);
        return n >= provEphemeralDHKeySize ? n : 0;
    }

    @Override
    public ProtocolVersion[] getSupportedVersions() {
        return this.manager.getContext().getSupportedVersions(this.sslParameters.getProtocols());
    }

    @Override
    protected Vector getProtocolNames() {
        return JsseUtils.getProtocolNames(this.sslParameters.getApplicationProtocols());
    }

    @Override
    protected int[] getSupportedCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.manager.getContextData().getCrypto(), this.manager.getContext().convertCipherSuites(this.sslParameters.getCipherSuites()));
    }

    @Override
    protected boolean preferLocalCipherSuites() {
        return this.sslParameters.getUseCipherSuitesOrder();
    }

    @Override
    protected boolean selectCipherSuite(int n) throws IOException {
        if (!this.selectCredentials(n)) {
            LOG.finer("Server found no credentials for cipher suite: " + this.manager.getContext().getCipherSuiteString(n));
            return false;
        }
        this.manager.getContext().validateNegotiatedCipherSuite(n);
        return super.selectCipherSuite(n);
    }

    @Override
    protected int selectDH(int n) {
        n = Math.max(n, provEphemeralDHKeySize);
        int[] nArray = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (nArray == null) {
            return this.selectDHDefault(n);
        }
        return SupportedGroups.getServerSelectedFiniteField(this.getCrypto(), this.manager.getContext().isFips(), n, nArray);
    }

    @Override
    protected int selectDHDefault(int n) {
        return SupportedGroups.getServerDefaultDH(this.manager.getContext().isFips(), n);
    }

    @Override
    protected int selectECDH(int n) {
        int[] nArray = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (nArray == null) {
            return this.selectECDHDefault(n);
        }
        return SupportedGroups.getServerSelectedCurve(this.getCrypto(), this.manager.getContext().isFips(), n, nArray);
    }

    @Override
    protected int selectECDHDefault(int n) {
        return SupportedGroups.getServerDefaultECDH(this.manager.getContext().isFips(), n);
    }

    @Override
    protected ProtocolName selectProtocolName() throws IOException {
        if (null == this.sslParameters.getEngineAPSelector() && null == this.sslParameters.getSocketAPSelector()) {
            return super.selectProtocolName();
        }
        List<String> list = JsseUtils.getProtocolNames(this.clientProtocolNames);
        String string = this.manager.selectApplicationProtocol(Collections.unmodifiableList(list));
        if (null == string) {
            throw new TlsFatalAlert(120);
        }
        if (string.length() < 1) {
            return null;
        }
        if (!list.contains(string)) {
            throw new TlsFatalAlert(120);
        }
        return ProtocolName.asUtf8Encoding(string);
    }

    @Override
    protected boolean shouldSelectProtocolNameEarly() {
        return null == this.sslParameters.getEngineAPSelector() && null == this.sslParameters.getSocketAPSelector();
    }

    @Override
    public synchronized boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        return this.credentials;
    }

    @Override
    public CertificateRequest getCertificateRequest() throws IOException {
        boolean bl;
        boolean bl2 = bl = this.sslParameters.getNeedClientAuth() || this.sslParameters.getWantClientAuth();
        if (!bl) {
            return null;
        }
        short[] sArray = new short[]{1, 2, 64};
        Vector vector = null;
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.context.getServerVersion())) {
            vector = JsseUtils.getSupportedSignatureAlgorithms(this.getCrypto());
        }
        Vector<X500Name> vector2 = new Vector<X500Name>();
        BCX509ExtendedTrustManager bCX509ExtendedTrustManager = this.manager.getContextData().getX509TrustManager();
        for (X509Certificate x509Certificate : bCX509ExtendedTrustManager.getAcceptedIssuers()) {
            vector2.addElement(X500Name.getInstance((Object)x509Certificate.getSubjectX500Principal().getEncoded()));
        }
        return new CertificateRequest(sArray, vector, vector2);
    }

    @Override
    public int getSelectedCipherSuite() throws IOException {
        ProvSSLSessionContext provSSLSessionContext = this.manager.getContextData().getServerSessionContext();
        String string = this.manager.getPeerHost();
        int n = this.manager.getPeerPort();
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        ProvSSLSessionHandshake provSSLSessionHandshake = null == this.sslSession ? new ProvSSLSessionHandshake(provSSLSessionContext, string, n, securityParameters) : new ProvSSLSessionResumed(provSSLSessionContext, string, n, securityParameters, this.sslSession.getTlsSession(), this.sslSession.getJsseSessionParameters());
        this.manager.notifyHandshakeSession(provSSLSessionHandshake);
        this.keyManagerMissCache = new HashSet<String>();
        int n2 = super.getSelectedCipherSuite();
        LOG.fine("Server selected cipher suite: " + this.manager.getContext().getCipherSuiteString(n2));
        this.keyManagerMissCache = null;
        return n2;
    }

    @Override
    public Hashtable getServerExtensions() throws IOException {
        super.getServerExtensions();
        if (null != this.matchedSNIServerName) {
            TlsExtensionsUtils.addServerNameExtensionServer(this.checkServerExtensions());
        }
        return this.serverExtensions;
    }

    @Override
    public TlsSession getSessionToResume(byte[] byArray) {
        TlsSession tlsSession;
        ProvSSLSessionContext provSSLSessionContext = this.manager.getContextData().getServerSessionContext();
        ProvSSLSession provSSLSession = provSSLSessionContext.getSessionImpl(byArray);
        if (null != provSSLSession && null != (tlsSession = provSSLSession.getTlsSession()) && this.isResumable(provSSLSession)) {
            this.sslSession = provSSLSession;
            return tlsSession;
        }
        if (!this.manager.getEnableSessionCreation()) {
            throw new IllegalStateException("No resumable sessions and session creation is disabled");
        }
        return null;
    }

    @Override
    public void notifyAlertRaised(short s, short s2, String string, Throwable throwable) {
        Level level;
        Level level2 = s == 1 ? Level.FINE : (level = s2 == 80 ? Level.WARNING : Level.INFO);
        if (LOG.isLoggable(level)) {
            Object object = JsseUtils.getAlertLogMessage("Server raised", s, s2);
            if (string != null) {
                object = (String)object + ": " + string;
            }
            LOG.log(level, (String)object, throwable);
        }
    }

    @Override
    public void notifyAlertReceived(short s, short s2) {
        Level level;
        super.notifyAlertReceived(s, s2);
        Level level2 = level = s == 1 ? Level.FINE : Level.INFO;
        if (LOG.isLoggable(level)) {
            String string = JsseUtils.getAlertLogMessage("Server received", s, s2);
            LOG.log(level, string);
        }
    }

    @Override
    public ProtocolVersion getServerVersion() throws IOException {
        ProtocolVersion protocolVersion = super.getServerVersion();
        String string = this.manager.getContext().getProtocolString(protocolVersion);
        LOG.fine("Server selected protocol version: " + string);
        return protocolVersion;
    }

    @Override
    public void notifyClientCertificate(Certificate certificate) throws IOException {
        if (!this.sslParameters.getNeedClientAuth() && !this.sslParameters.getWantClientAuth()) {
            throw new TlsFatalAlert(80);
        }
        if (null == certificate || certificate.isEmpty()) {
            if (this.sslParameters.getNeedClientAuth()) {
                throw new TlsFatalAlert(40);
            }
        } else {
            X509Certificate[] x509CertificateArray = JsseUtils.getX509CertificateChain(this.manager.getContextData().getCrypto(), certificate);
            short s = certificate.getCertificateAt(0).getLegacySignatureAlgorithm();
            String string = JsseUtils.getAuthStringClient(s);
            this.manager.checkClientTrusted(x509CertificateArray, string);
        }
    }

    @Override
    public synchronized void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        this.handshakeComplete = true;
        TlsSession tlsSession = this.context.getSession();
        if (null == this.sslSession || this.sslSession.getTlsSession() != tlsSession) {
            ProvSSLSessionContext provSSLSessionContext = this.manager.getContextData().getServerSessionContext();
            String string = this.manager.getPeerHost();
            int n = this.manager.getPeerPort();
            JsseSessionParameters jsseSessionParameters = new JsseSessionParameters(this.sslParameters.getEndpointIdentificationAlgorithm());
            this.sslSession = provSSLSessionContext.reportSession(string, n, tlsSession, jsseSessionParameters);
        }
        this.manager.notifyHandshakeComplete(new ProvSSLConnection(this.context, this.sslSession));
    }

    @Override
    public void notifySecureRenegotiation(boolean bl) throws IOException {
        boolean bl2;
        if (!bl && !(bl2 = PropertyUtils.getBooleanSystemProperty("sun.security.ssl.allowLegacyHelloMessages", true))) {
            throw new TlsFatalAlert(40);
        }
    }

    @Override
    public void processClientExtensions(Hashtable hashtable) throws IOException {
        super.processClientExtensions(hashtable);
        Vector vector = this.context.getSecurityParametersHandshake().getClientServerNames();
        if (null != vector) {
            Collection<BCSNIMatcher> collection = this.sslParameters.getSNIMatchers();
            if (null == collection || collection.isEmpty()) {
                LOG.fine("Server ignored SNI (no matchers specified)");
            } else {
                this.matchedSNIServerName = JsseUtils.findMatchingSNIServerName(vector, collection);
                if (null == this.matchedSNIServerName) {
                    throw new TlsFatalAlert(112);
                }
                LOG.fine("Server accepted SNI: " + this.matchedSNIServerName);
            }
        }
    }

    protected boolean isResumable(ProvSSLSession provSSLSession) {
        return false;
    }

    protected boolean selectCredentials(int n) throws IOException {
        this.credentials = null;
        int n2 = TlsUtils.getKeyExchangeAlgorithm(n);
        switch (n2) {
            case 11: 
            case 20: {
                return true;
            }
            case 1: 
            case 3: 
            case 5: 
            case 17: 
            case 19: {
                break;
            }
            default: {
                return false;
            }
        }
        String string = JsseUtils.getAuthTypeServer(n2);
        if (this.keyManagerMissCache.contains(string)) {
            return false;
        }
        Principal[] principalArray = null;
        String string2 = this.manager.chooseServerAlias(string, principalArray);
        if (string2 == null) {
            this.keyManagerMissCache.add(string);
            return false;
        }
        TlsCrypto tlsCrypto = this.getCrypto();
        if (!(tlsCrypto instanceof JcaTlsCrypto)) {
            throw new UnsupportedOperationException();
        }
        X509ExtendedKeyManager x509ExtendedKeyManager = this.manager.getContextData().getX509KeyManager();
        PrivateKey privateKey = x509ExtendedKeyManager.getPrivateKey(string2);
        Certificate certificate = JsseUtils.getCertificateMessage(tlsCrypto, x509ExtendedKeyManager.getCertificateChain(string2));
        if (privateKey == null || !JsseUtils.isUsableKeyForServer(n2, privateKey) || certificate.isEmpty()) {
            this.keyManagerMissCache.add(string);
            return false;
        }
        switch (n2) {
            case 3: 
            case 5: 
            case 17: 
            case 19: {
                short s = TlsUtils.getLegacySignatureAlgorithmServer(n2);
                SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.chooseSignatureAndHashAlgorithm(this.context, this.context.getSecurityParametersHandshake().getClientSigAlgs(), s);
                this.credentials = new JcaDefaultTlsCredentialedSigner(new TlsCryptoParameters(this.context), (JcaTlsCrypto)tlsCrypto, privateKey, certificate, signatureAndHashAlgorithm);
                return true;
            }
            case 1: {
                this.credentials = new JceDefaultTlsCredentialedDecryptor((JcaTlsCrypto)tlsCrypto, certificate, privateKey);
                return true;
            }
        }
        return false;
    }
}

