/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.List;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.provider.JsseSessionParameters;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvSSLSessionBase;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvSSLSessionHandshake
extends ProvSSLSessionBase {
    protected final SecurityParameters securityParameters;

    ProvSSLSessionHandshake(ProvSSLSessionContext provSSLSessionContext, String string, int n, SecurityParameters securityParameters) {
        super(provSSLSessionContext, string, n);
        this.securityParameters = securityParameters;
    }

    String getApplicationProtocol() {
        return JsseUtils.getApplicationProtocol(this.securityParameters);
    }

    @Override
    protected int getCipherSuiteTLS() {
        return this.securityParameters.getCipherSuite();
    }

    @Override
    protected byte[] getIDArray() {
        return this.securityParameters.getSessionID();
    }

    @Override
    protected JsseSessionParameters getJsseSessionParameters() {
        return null;
    }

    @Override
    protected Certificate getLocalCertificateTLS() {
        return this.securityParameters.getLocalCertificate();
    }

    @Override
    public String[] getLocalSupportedSignatureAlgorithms() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Certificate getPeerCertificateTLS() {
        return this.securityParameters.getPeerCertificate();
    }

    @Override
    public String[] getPeerSupportedSignatureAlgorithms() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ProtocolVersion getProtocolTLS() {
        return this.securityParameters.getNegotiatedVersion();
    }

    @Override
    public List<BCSNIServerName> getRequestedServerNames() {
        return JsseUtils.convertSNIServerNames(this.securityParameters.getClientServerNames());
    }

    @Override
    public List<byte[]> getStatusResponses() {
        throw new UnsupportedOperationException();
    }
}

